package ohd.hseb.util.fews;

public enum DISCHARGE_DATATYPE
{
    QINE(DataType.QINE_DATATYPE), //
    QINH(DataType.QINH_DATATYPE), //
    SQIN(DataType.SQIN_DATATYPE);

    final private String _type; //will not be changed

    private DISCHARGE_DATATYPE(final String type)
    {
        _type = type;
    }

    public String getTypeName()
    {
        return _type;
    }

    public static boolean isDischargeType(final String typeStr)
    {
        for(final DISCHARGE_DATATYPE type: values())
        {
            if(type.getTypeName().equalsIgnoreCase(typeStr))
            {
                return true;
            }
        }

        return false;
    }
}
