package ohd.hseb.util.fews;

/**
 * The Diagnostic class represents a single message(line) in the FEWS schema pi_diag.xsd
 * 
 * @author FewsPilot team
 * 
 */
final public class Diagnostic
{
    private final int _level;
    private String _message;

    /**
     * @param message the actual message string
     * @param level the level - 3=INFO,2=WARN,1=ERROR,0=FATAL
     */
    public Diagnostic(final String message, final int level)
    {
        _level = level;
        _message = message;
    }

    public void append(final String message)
    {
        _message += message;
    }

    /**
     * @return the level - number to conform to the schema
     */
    public int getLevel()
    {
        return _level;
    }

    /**
     * @return actual message string
     */
    public String getMessage()
    {
        return _message;
    }

    public void clear()
    {
        _message = null;
    }
}
