package ohd.hseb.util.fews;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

import ohd.hseb.util.Logger;

/**
 * The Diagnostics class allows the user to accumulate diagnostic messages which can be dumped to xml (conforming to
 * pi_diag.xsd) with writeLog
 * 
 * @author FewsPilot team
 */
final public class Diagnostics implements Logger
{

    private final ArrayList<Diagnostic> _diagList = new ArrayList<Diagnostic>();
    private int debugOn = 0;

    private String _prependStr; //if set, all the logging message will be prepended with it; if not set, then no prepending.

    /*
     * (non-Javadoc)
     * @see ohd.hseb.util.Logger#log(int, java.lang.String)
     */
    public void log(final int level, final String message)
    {
        if(level == Logger.DEBUG)
        {
            if(debugOn > 0)
            {
                addMessage(message, level);
            }
        }
        else
        {
            addMessage(message, level);
        }
    }

    /*
     * (non-Javadoc)
     * @see ohd.hseb.util.Logger#log(java.lang.String)
     */
    public void log(final String message)
    {
        addMessage(message, Logger.INFO);
    }

    private void addMessage(final String message, final int level)
    {

        if(_prependStr != null)
        {//_prependStr has been set
            _diagList.add(new Diagnostic(_prependStr + ": " + message, level));
        }
        else
        {
            _diagList.add(new Diagnostic(message, level));
        }
    }

    public void close()
    {
    }

    /*
     * (non-Javadoc)
     * @see ohd.hseb.util.Logger#getPrintWriter()
     */
    public PrintWriter getPrintWriter()
    {
        PrintWriter d = null;
        try
        {
            d = new PrintWriter(new FileOutputStream("dummy"));
        }
        catch(final Exception e)
        {
        }
        return d;
    }

    /**
     * @return list of diagnostics accumulated
     */
    public ArrayList<Diagnostic> getList()
    {
        return _diagList;
    }

    public String getListOfDiagnosticsAsString()
    {
        String returnString = "";

        for(final Diagnostic diag: _diagList)
        {
            returnString = returnString + diag.getMessage() + "\n";
        }
        return returnString;
    }

    public String getListOfDiagnosticsWithLevelAsString(final int level)
    {
        String returnString = "";

        for(final Diagnostic diag: _diagList)
        {
            if(diag.getLevel() == level)
            {
                returnString = returnString + diag.getMessage() + "\n";
            }
        }
        return returnString;
    }

    public int getPrintDebugInfo()
    {
        return debugOn;
    }

    public void setPrintDebugInfo(final int debugValue)
    {
        debugOn = debugValue;
    }

    /**
     * After setting _prependStr, then all the logging messages will be prepended.
     */
    public void setPrependStr(final String prependStr)
    {
        _prependStr = prependStr;
    }

    public String getPrependStr()
    {
        return _prependStr;
    }

}
