package ohd.hseb.util.fews;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;

/**
 * For grid filling 6 purpose: stores a bunch of numbers(double). Then return the dominant number. For example, adding
 * four numbers("1.1", "2.2", "3.3" and "1.1") to this class. The dominant number is "1.1", since it happens twice and
 * others only once.<br>
 * Note: if adding five numbers("1.1", "2.2", "3.3", "2.2" and "1.1"), the dominant number returned is "1.1", since
 * "1.1" was added ahead of "2.2".
 */
public class DominantNumberFinder
{
    private final Map<String, Integer> _map = new LinkedHashMap<String, Integer>(); //key is the number converted String, value is the occurrence of this number; LinkedHashMap keeps insertion-order
    private int _occuranceCount; //this number can be obtained indirectly by summing _map's values, but may not be efficient. 

    public DominantNumberFinder()
    {
        _occuranceCount = 0;
    }

    public void add(double d)
    {
        _occuranceCount++;

        d = OHDUtilities.getFortranPrecison(d);

        final String keyStr = String.valueOf(d);

        if(_map.containsKey(keyStr))
        {
            final int dominanceCount = _map.get(keyStr).intValue() + 1;

            _map.put(keyStr, Integer.valueOf(dominanceCount));
        }
        else
        {
            _map.put(keyStr, Integer.valueOf(1));
        }
    }

    /**
     * Return the dominant number as a double. For example, adding four numbers("1.1", "2.2", "3.3" and "1.1") to this
     * class. The predominant number is "1.1", since it happens twice and others only once.
     */
    double getPredominatValue()
    {

        double predominant = 0.0;
        int domCount = 0;

        for(final Entry<String, Integer> entry: _map.entrySet())
        {
            final int count = entry.getValue().intValue();

            //find the entry that has the max value, then the key(String) is the dominant double String
            if(count > domCount)
            {
                domCount = entry.getValue().intValue();
                predominant = Double.valueOf(entry.getKey());
            }
        }

        return predominant;
    }

    /**
     * Return the dominant number as a float. For example, adding four numbers("1.1", "2.2", "3.3" and "1.1") to this
     * class. The predominant number is "1.1", since it happens twice and others only once.
     */
    public float getPredominatValueAsFloat()
    {
        return (float)this.getPredominatValue();
    }

    /**
     * Back to the initial state. Be ready for next usage.
     */
    public void reSet()
    {
        _occuranceCount = 0;
        _map.clear();
    }

    /**
     * Return the total number that have been added. For example, four numbers("1.1", "2.2", "3.3" and "1.1") have been
     * added to this class, this method returns 4.
     */
    public int getTotalCount()
    {
        return _occuranceCount;
    }

    //for testing purpose
    public static void main(final String[] args)
    {
        final DominantNumberFinder finder = new DominantNumberFinder();

        finder.add(3.3);

        finder.add(1.1);
        finder.add(2.2);
        finder.add(1.1);
        finder.add(2.2);

        System.out.println("dominant number= " + finder.getPredominatValue()); //should be 1.1, not 2.2
    }

}
