package ohd.hseb.util.fews;

public enum FEWS_RTS_TYPE
{
    INSTANTANEOUS(OHDConstants.INSTANTANEOUS_TYPE), //
    ACCUMULATIVE(OHDConstants.ACCUMULATED_TYPE), //
    MEAN(OHDConstants.MEAN_TYPE), //
    UNKNOWN("UNKNOWN");

    final private String _type; //will not be changed

    private FEWS_RTS_TYPE(final String type)
    {
        _type = type;
    }

    public String getTypeName()
    {
        return _type;
    }

    public static FEWS_RTS_TYPE convertFromString(final String typeStr) throws Exception
    {
        for(final FEWS_RTS_TYPE type: values())
        {
            if(type.getTypeName().equalsIgnoreCase(typeStr))
            {
                return type;
            }
        }

        throw new Exception("The type " + typeStr + " does not belong to any FewsRegularTimeSeriesType");
    }
}
