/**
 * 
 */
package ohd.hseb.util.fews;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * @author freddy.camacho
 *
 */
public class FewsFileFromMemory {
	
	
	
	public static BufferedInputStream newInputStream(File file) throws IOException {
	    //noinspection UseOfPropertiesAsHashtable
	    var stream = System.getProperties().get(file);
	    if (stream instanceof BufferedInputStream) return (BufferedInputStream) stream;
	    return new BufferedInputStream(new FileInputStream(file));
	}

	public static BufferedOutputStream newOutputStream(File file) throws IOException {
	    //noinspection UseOfPropertiesAsHashtable
	    var stream = System.getProperties().get(file);
	    if (stream instanceof BufferedOutputStream) return (BufferedOutputStream) stream;
	    return new BufferedOutputStream(new FileOutputStream(file));
	}
	

	/**
	 * @param args
	 * @throws IOException 
	 */
	public static void main(String[] args) throws IOException {
		// TODO Auto-generated method stub
		File fileIn = new File("/home/freddy.camacho/test.log");
		BufferedInputStream streamIn = FewsFileFromMemory.newInputStream(fileIn);
		
        /*available() method of BufferedInputStream
         * returns 0 when there are no more bytes
         * present in the file to be read*/
        while( streamIn.available() > 0 ){             	
            System.out.print((char)streamIn.read());
        }

        File fileOut = new File("/home/freddy.camacho/test_out.log");
        
        BufferedOutputStream streamOut = newOutputStream(fileOut);
        streamOut.write("Hello Word".getBytes());
        streamOut.write(System.lineSeparator().getBytes());
        streamOut.write("I am wrinting to the outpuStream".getBytes());
        streamOut.write(System.lineSeparator().getBytes());
        streamOut.close();
        
        

	}

}
