package ohd.hseb.util.fews;

import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import ohd.hseb.util.Logger;

import org.xml.sax.SAXException;

/**
 * An abstract class for {@link TimeSeriesHandler}, {@link StateMetaFileHandler}, {@link ParameterHandler} and
 * {@link RunInfoHandler}
 */
public abstract class FewsXmlHandler
{
    protected String _curValue = "";

    protected Logger _logger;

    public void find(final XMLStreamReader reader) throws SAXException, Exception
    {
        try
        {
            int event = reader.getEventType();
            while(true)
            {
                switch(event)
                {
                    case XMLStreamConstants.START_DOCUMENT:
                        break;
                    case XMLStreamConstants.START_ELEMENT:
                        startElement(reader);
                        break;

                    case XMLStreamConstants.CHARACTERS:
                        if(reader.hasText())
                        {
                            if(!reader.isWhiteSpace())
                            {
                                _curValue += reader.getText();
                            }
                            else if(reader.getText() != null)
                                if(reader.getText().trim().length() > 0)
                                {
                                    _curValue += reader.getText();
                                }
                                else
                                {
                                    if(_curValue.length() > 0
                                        && (reader.getText().contains(System.getProperty("line.separator")) || reader.getText()
                                                                                                                     .contains("\n")))
                                    {
                                        _curValue += reader.getText();
                                    }
                                }
                            
                        }
                        break;

                    case XMLStreamConstants.END_ELEMENT:
                        endElement(reader);
                        break;

                    case XMLStreamConstants.END_DOCUMENT:
                        endDocument();
                        break;

                    default:
                        break;
                } // end of switch

                if(!reader.hasNext())
                {
                    break;
                }

                event = reader.next();
            } // end of while
        }
        catch(final XMLStreamException e)
        {
            e.printStackTrace();
        } // end try/catch
    } //  end of find method    

    abstract public void startElement(final XMLStreamReader reader) throws Exception;

    abstract public void endElement(final XMLStreamReader reader) throws SAXException;

    /**
     * {@link RunInfoHandler} does not need this method, so the default is empty. {@link StateMetaFileHandler},
     * {@link ParameterHandler} and {@link TimeSeriesHandler} need this method, so they will override it.
     */
    protected void endDocument() throws Exception
    {
        //empty
    }
}
