package ohd.hseb.util.fews;

import java.net.URL;

import javax.xml.XMLConstants;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import ohd.hseb.util.Logger;

import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class FewsXmlValidation
{

    /**
     * Validate a xml file against the schema. If the file name ends with ".fi", do not validate it, since we don't
     * validate fast info files. In addition, to cut normal cpu time, we only validate when log debug level is > 0.
     */
    public static void validateXmlFileAgainsXMLSchema(final String fileName,
                                                      final String xmlSchemaName,
                                                      final Logger logger) throws Exception
    {
        //we cannot validate *.fi files
        if(fileName.endsWith(".fi"))
        {
            logger.log(Logger.DEBUG, fileName + " is fast info file. Do not validate it against xml schema "
                + xmlSchemaName);
            return;
        }

        if(logger.getPrintDebugInfo() > 0)
        {
            String schemaSource = null;

            // find the jar file using the _logger object
            final URL myURL = logger.getClass().getClassLoader().getResource(xmlSchemaName);
            if(myURL == null)
            {
                logger.log(Logger.FATAL, "Unable to find the XML Schema file: " + xmlSchemaName
                    + " to validate the XML file: " + fileName);

                throw new Exception("Unable to find the XML Schema file: " + xmlSchemaName
                    + " to validate the XML file: " + fileName);
            }

            schemaSource = myURL.getPath();

            // create a SchemaFactory capable of understanding WXS schemas
            final SchemaFactory schemaFactory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

            final Schema schema = schemaFactory.newSchema(myURL);

            // create a Validator instance, which can be used to validate an instance document
            final Validator validator = schema.newValidator();

            // Create a SAX Source 
            final SAXSource sXML = new SAXSource(new InputSource(fileName));

            // Validate Xml file vs XML schema 
            try
            {
                validator.validate(sXML);

                logger.log(Logger.DEBUG, fileName + " has been successfully validated against the schema "
                    + xmlSchemaName);
            }
            catch(final SAXParseException spe)
            {
                // Error generated by the parser
                // Use the contained exception, if any

                logger.log(Logger.FATAL,
                           "\n** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId()
                               + ", using Schema " + schemaSource);
                logger.log(Logger.FATAL, "   " + spe.getMessage());

                final Exception x = spe;

                throw x;
            }
        }
    }

}
