package ohd.hseb.util.fews;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GroupOfParameters
{

    private String _description;
    private String _locationId;
    private String _model;
    private ValidPeriod _validPeriod;
    private final Map<String, ParameterType> _parameterMap;
    private ModelEnsemble _ensemble;
    private String _id;
    private String _name;
    private Boolean _readonly = null;

    public GroupOfParameters()
    {
        _parameterMap = new LinkedHashMap<String, ParameterType>();
    }

    /**
     * Gets the value of the description property.
     * 
     * @return possible object is {@link String }
     */
    public String getDescription()
    {
        return _description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setDescription(final String value)
    {
        this._description = value;
    }

    /**
     * Gets the value of the locationId property.
     * 
     * @return possible object is {@link String }
     */
    public String getLocationId()
    {
        return _locationId;
    }

    /**
     * Sets the value of the locationId property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setLocationId(final String value)
    {
        this._locationId = value;
    }

    /**
     * Gets the value of the model property.
     * 
     * @return possible object is {@link String }
     */
    public String getModel()
    {
        return _model;
    }

    /**
     * Sets the value of the model property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setModel(final String value)
    {
        this._model = value;
    }

    /**
     * Gets the value of the validPeriod property.
     * 
     * @return possible object is {@link ValidPeriod }
     */
    public ValidPeriod getValidPeriod()
    {
        return _validPeriod;
    }

    /**
     * Sets the value of the validPeriod property.
     * 
     * @param value allowed object is {@link ValidPeriod }
     */
    public void setValidPeriod(final ValidPeriod value)
    {
        this._validPeriod = value;
    }

    /**
     * Gets the value of the parameter property.
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you make to
     * the returned list will be present inside the object.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getParameter().add(newItem);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list {@link ParameterType }
     */
    public Map<String, ParameterType> getParameterMap()
    {
        return this._parameterMap;
    }

    public void setParameter(final ParameterType value)
    {
        this._parameterMap.put(value.getId(), value);
    }

    /**
     * Gets the value of the ensemble property.
     * 
     * @return possible object is {@link ModelEnsemble }
     */
    public ModelEnsemble getEnsemble()
    {
        return _ensemble;
    }

    /**
     * Sets the value of the ensemble property.
     * 
     * @param value allowed object is {@link ModelEnsemble }
     */
    public void setEnsemble(final ModelEnsemble value)
    {
        this._ensemble = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return possible object is {@link String }
     */
    public String getId()
    {
        return _id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setId(final String value)
    {
        this._id = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return possible object is {@link String }
     */
    public String getName()
    {
        return _name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setName(final String value)
    {
        this._name = value;
    }

    /**
     * Gets the value of the readonly property.
     * 
     * @return possible object is {@link Boolean }
     */
    public Boolean getReadonly()
    {
        return _readonly;
    }

    /**
     * Sets the value of the readonly property.
     * 
     * @param value allowed object is {@link Boolean }
     */
    public void setReadonly(final Boolean value)
    {
        this._readonly = value;
    }

    @Override
    public String toString()
    {
        final StringBuffer resultStr = new StringBuffer();

        resultStr.append("Group:").append(OHDConstants.NEW_LINE);
        if(this.getId() != null)
        {
            resultStr.append("Id = " + this.getId()).append(OHDConstants.NEW_LINE);
        }
        if(this.getName() != null)
        {
            resultStr.append("Name = " + this.getName()).append(OHDConstants.NEW_LINE);
        }
        if(_readonly != null)
        {
            resultStr.append("Read Only = " + this.getReadonly()).append(OHDConstants.NEW_LINE);
        }
        if(this.getDescription() != null)
        {
            resultStr.append("Description = " + this.getDescription()).append(OHDConstants.NEW_LINE);
        }
        if(this.getLocationId() != null)
        {
            resultStr.append("Location Id = " + this.getLocationId()).append(OHDConstants.NEW_LINE);
        }
        if(this.getModel() != null)
        {
            resultStr.append("Model = " + this.getModel()).append(OHDConstants.NEW_LINE);
        }
        if(this.getValidPeriod() != null)
        {
            resultStr.append("Valid Period: ").append(OHDConstants.NEW_LINE);
            resultStr.append(this.getValidPeriod().toString());
        }
        if(this.getParameterMap() != null)
        {
            resultStr.append("Parameter:").append(OHDConstants.NEW_LINE);
            for(final ParameterType param: this.getParameterMap().values())
            {
                resultStr.append(param.toString());
            }
        }
        if(this.getEnsemble() != null)
        {
            resultStr.append("Ensemble:").append(OHDConstants.NEW_LINE);
        }
        return resultStr.toString();
    }

    @Override
    public boolean equals(final Object other)
    {
        boolean returnVal = false;

        if(other == this)
        {
            returnVal = true;
        }
        else if(other == null)
        {
            returnVal = false;
        }
        else if(!getClass().equals(other.getClass()))
        {
            returnVal = false;
        }
        else if(other instanceof GroupOfParameters)
        {
            final GroupOfParameters other2 = (GroupOfParameters)other;
            returnVal = testEqualsWithNull(this.getDescription(), other2.getDescription())
                && testEqualsWithNull(this.getEnsemble(), other2.getEnsemble())
                && testEqualsWithNull(this.getId(), other2.getId())
                && testEqualsWithNull(this.getLocationId(), other2.getLocationId())
                && testEqualsWithNull(this.getModel(), other2.getModel())
                && testEqualsWithNull(this.getName(), other2.getName())
                && testEqualsWithNull(this.getParameterMap(), other2.getParameterMap())
                && testEqualsWithNull(this.getReadonly(), other2.getReadonly());
            if(this.getValidPeriod() != null)
            {
                returnVal = returnVal && this.getValidPeriod().equals(other2.getValidPeriod());
            }
        }

        return returnVal;
    }

    private static boolean testEqualsWithNull(final Object a, final Object b)
    {
        return (a == null && b == null) || (a != null && b != null) && (a.equals(b));
    }

    /**
     * Check if the parameter is present or not.
     */
    public boolean isParameterExisting(final String paramTag)
    {
        if(_parameterMap.keySet().contains(paramTag))
        {
            return true;
        }

        return false;
    }

    /**
     * **********************************************
     */

    public static class ValidPeriod
    {

        protected Double timeZone;
        protected DateTime startDate;
        protected DateTime endDate;
        protected DateTime validBeforeDate;
        protected DateTime validAfterDate;
        protected String startMonthDay;
        protected String endMonthDay;
        protected List<String> monthDay;
        protected List<String> month;
        protected List<String> day;

        private int _hashCode = -1;

        /**
         * Gets the value of the timeZone property.
         * 
         * @return possible object is {@link Double }
         */
        public Double getTimeZone()
        {
            return timeZone;
        }

        /**
         * Sets the value of the timeZone property.
         * 
         * @param value allowed object is {@link Double }
         */
        public void setTimeZone(final Double value)
        {
            this.timeZone = value;
        }

        /**
         * Gets the value of the startDate property.
         * 
         * @return possible object is {@link DateTime }
         */
        public DateTime getStartDate()
        {
            return startDate;
        }

        /**
         * Sets the value of the startDate property.
         * 
         * @param value allowed object is {@link DateTime }
         */
        public void setStartDate(final DateTime value)
        {
            this.startDate = value;
        }

        /**
         * Gets the value of the endDate property.
         * 
         * @return possible object is {@link DateTime }
         */
        public DateTime getEndDate()
        {
            return endDate;
        }

        /**
         * Sets the value of the endDate property.
         * 
         * @param value allowed object is {@link DateTime }
         */
        public void setEndDate(final DateTime value)
        {
            this.endDate = value;
        }

        /**
         * Gets the value of the validBeforeDate property.
         * 
         * @return possible object is {@link DateTime }
         */
        public DateTime getValidBeforeDate()
        {
            return validBeforeDate;
        }

        /**
         * Sets the value of the validBeforeDate property.
         * 
         * @param value allowed object is {@link DateTime }
         */
        public void setValidBeforeDate(final DateTime value)
        {
            this.validBeforeDate = value;
        }

        /**
         * Gets the value of the validAfterDate property.
         * 
         * @return possible object is {@link DateTime }
         */
        public DateTime getValidAfterDate()
        {
            return validAfterDate;
        }

        /**
         * Sets the value of the validAfterDate property.
         * 
         * @param value allowed object is {@link DateTime }
         */
        public void setValidAfterDate(final DateTime value)
        {
            this.validAfterDate = value;
        }

        /**
         * Gets the value of the startMonthDay property.
         * 
         * @return possible object is {@link XMLString }
         */
        public String getStartMonthDay()
        {
            return startMonthDay;
        }

        /**
         * Sets the value of the startMonthDay property.
         * 
         * @param value allowed object is {@link XMLString }
         */
        public void setStartMonthDay(final String value)
        {
            this.startMonthDay = value;
        }

        /**
         * Gets the value of the endMonthDay property.
         * 
         * @return possible object is {@link XMLString }
         */
        public String getEndMonthDay()
        {
            return endMonthDay;
        }

        /**
         * Sets the value of the endMonthDay property.
         * 
         * @param value allowed object is {@link XMLString }
         */
        public void setEndMonthDay(final String value)
        {
            this.endMonthDay = value;
        }

        /**
         * Gets the value of the monthDay property.
         * <p>
         * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you
         * make to the returned list will be present inside the object. This is why there is not a <CODE>set</CODE>
         * method for the monthDay property.
         * <p>
         * For example, to add a new item, do as follows:
         * 
         * <pre>
         * getMonthDay().add(newItem);
         * </pre>
         * <p>
         * Objects of the following type(s) are allowed in the list {@link XMLString }
         */
        public List<String> getMonthDay()
        {
            if(monthDay == null)
            {
                monthDay = new ArrayList<String>();
            }
            return this.monthDay;
        }

        public void setMonthDay(final String value)
        {
            if(monthDay == null)
            {
                this.monthDay = new ArrayList<String>();
            }
            this.monthDay.add(value);
        }

        /**
         * Gets the value of the month property.
         * <p>
         * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you
         * make to the returned list will be present inside the object. This is why there is not a <CODE>set</CODE>
         * method for the month property.
         * <p>
         * For example, to add a new item, do as follows:
         * 
         * <pre>
         * getMonth().add(newItem);
         * </pre>
         * <p>
         * Objects of the following type(s) are allowed in the list {@link XMLString }
         */
        public List<String> getMonth()
        {
            if(month == null)
            {
                month = new ArrayList<String>();
            }
            return this.month;
        }

        public void setMonth(final String value)
        {
            if(month == null)
            {
                month = new ArrayList<String>();
            }
            this.month.add(value);
        }

        /**
         * Gets the value of the day property.
         * <p>
         * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you
         * make to the returned list will be present inside the object. This is why there is not a <CODE>set</CODE>
         * method for the day property.
         * <p>
         * For example, to add a new item, do as follows:
         * 
         * <pre>
         * getDay().add(newItem);
         * </pre>
         * <p>
         * Objects of the following type(s) are allowed in the list {@link XMLString }
         */
        public List<String> getDay()
        {
            if(day == null)
            {
                day = new ArrayList<String>();
            }
            return this.day;
        }

        public void setDay(final String value)
        {
            if(day == null)
            {
                day = new ArrayList<String>();
            }
            this.day.add(value);
        }

        @Override
        public String toString()
        {
            final StringBuffer resultStr = new StringBuffer();

            if(this.getTimeZone() != null)
            {
                resultStr.append("Time Zone = " + this.getTimeZone()).append(OHDConstants.NEW_LINE);
            }
            if(this.getStartDate() != null)
            {
                resultStr.append("Start Date: ").append(OHDConstants.NEW_LINE);
                resultStr.append(this.getStartDate().toString());
            }
            if(this.getEndDate() != null)
            {
                resultStr.append("End Date: ").append(OHDConstants.NEW_LINE);
                resultStr.append(this.getEndDate().toString());
            }
            if(this.getValidBeforeDate() != null)
            {
                resultStr.append("Valid Before Date:").append(OHDConstants.NEW_LINE);
                resultStr.append(this.getValidBeforeDate().toString());
            }
            if(this.getValidAfterDate() != null)
            {
                resultStr.append("Valid After Date:").append(OHDConstants.NEW_LINE);
                resultStr.append(this.getValidAfterDate().toString());
            }
            if(this.getStartMonthDay() != null)
            {
                resultStr.append("Start Month Day = " + this.getStartMonthDay()).append(OHDConstants.NEW_LINE);
            }
            if(this.getEndMonthDay() != null)
            {
                resultStr.append("End Month Day = " + this.getEndMonthDay()).append(OHDConstants.NEW_LINE);
            }
            if(this.getMonthDay() != null && this.getMonthDay().size() > 0)
            {
                resultStr.append("Month Day:").append(OHDConstants.NEW_LINE);
                for(final String monthDay: this.getMonthDay())
                {
                    resultStr.append(monthDay).append(OHDConstants.NEW_LINE);
                }
            }
            if(this.getMonth() != null && this.getMonth().size() > 0)
            {
                resultStr.append("Month:").append(OHDConstants.NEW_LINE);
                for(final String month: this.getMonth())
                {
                    resultStr.append(month).append(OHDConstants.NEW_LINE);
                }
            }
            if(this.getDay() != null && this.getDay().size() > 0)
            {
                resultStr.append("Day:").append(OHDConstants.NEW_LINE);
                for(final String day: this.getDay())
                {
                    resultStr.append(day).append(OHDConstants.NEW_LINE);
                }
            }

            return resultStr.toString();
        }

        @Override
        public boolean equals(final Object other)
        {
            boolean returnVal = false;

            if(other == this)
            {
                returnVal = true;
            }
            else if(other == null)
            {
                returnVal = false;
            }
            else if(!getClass().equals(other.getClass()))
            {
                returnVal = false;
            }
            else if(other instanceof ValidPeriod)
            {

                if(hashCode() == other.hashCode())
                {
                    returnVal = true;
                }

                //   final ValidPeriod other2 = (ValidPeriod)other;
                //  returnVal = testEqualsWithNull(this.getDay(), other2.getDay())
                //       && testEqualsWithNull(this.getEndDate(), other2.getEndDate())
                //       && testEqualsWithNull(this.getEndMonthDay(), other2.getEndMonthDay())
                //       && testEqualsWithNull(this.getMonth(), other2.getMonth())
                //       && testEqualsWithNull(this.getMonthDay(), other2.getMonthDay())
                //        && testEqualsWithNull(this.getStartDate(), other2.getStartDate())
                //       && testEqualsWithNull(this.getStartMonthDay(), other2.getStartMonthDay())
                //       && testEqualsWithNull(this.getTimeZone(), other2.getTimeZone())
                //       && testEqualsWithNull(this.getValidAfterDate(), other2.getValidAfterDate())
                //       && testEqualsWithNull(this.getValidBeforeDate(), other2.getValidBeforeDate());

            }
            return returnVal;
        }

        @Override
        public int hashCode()
        {
            if(_hashCode == -1)
            {
                _hashCode = toString().hashCode();
            }

            return _hashCode;
        }

    }

    /**
     * *****************************************************
     * 
     * @author camachof
     */

    public static class DateTime
    {

        protected String date;
        protected String time;

        /**
         * Gets the value of the date property.
         * 
         * @return possible object is {@link String }
         */
        public String getDate()
        {
            return date;
        }

        /**
         * Sets the value of the date property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setDate(final String value)
        {
            this.date = value;
        }

        /**
         * Gets the value of the time property.
         * 
         * @return possible object is {@link String }
         */
        public String getTime()
        {
            return time;
        }

        /**
         * Sets the value of the time property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setTime(final String value)
        {
            this.time = value;
        }

        @Override
        public String toString()
        {
            final StringBuffer resultStr = new StringBuffer();
            if(this.getDate() != null)
            {
                resultStr.append("Date = " + this.getDate()).append(OHDConstants.NEW_LINE);
            }
            if(this.getTime() != null)
            {
                resultStr.append("Time = " + this.getTime()).append(OHDConstants.NEW_LINE);
            }
            return resultStr.toString();
        }

        @Override
        public boolean equals(final Object other)
        {
            boolean returnVal = false;

            if(other == this)
            {
                returnVal = true;
            }
            else if(other == null)
            {
                returnVal = false;
            }
            else if(!getClass().equals(other.getClass()))
            {
                returnVal = false;
            }
            else if(other instanceof DateTime)
            {
                final DateTime other2 = (DateTime)other;
                returnVal = testEqualsWithNull(this.getDate(), other2.getDate())
                    && testEqualsWithNull(this.getTime(), other2.getTime());
            }
            return returnVal;
        }

    }

}
