package ohd.hseb.util.fews;

import java.util.List;
import java.util.Properties;

import ohd.hseb.measurement.RegularTimeSeries;
import ohd.hseb.util.CodeTimer;
import ohd.hseb.util.Logger;

public interface IDriver
{
    public IState getState();

    public IParameters getParameters();

    public void executeDriver() throws Exception;

    public List<RegularTimeSeries> getTsList();

    public Logger getLogger();

    public void setLogger(Logger logger);

    public RunInfo getRunInfo();

    public void setRunInfo(RunInfo runInfo);

    public long getInitialStateTime();

    public long getComputationEndTime();

    public long getSwitchFromObservedToForecastTime();

    public String getWorkDir();

    public void setWorkDir(final String workDir);

    public void setOutputStateFile(final String outputStateFile);

    public void setInputStateFile(final String inputStateFile);

    public Properties getDriverProperties();

    public void setStopWatch(final CodeTimer stopWatch);

    public void setReadAndWriteBinary(final boolean b);

    public boolean isReadAndWriteBinary();

    public boolean getAreMissingValuesAlwaysAllowed();

}
