package ohd.hseb.util.fews;

import java.io.IOException;
import java.util.Map;
import java.util.TimeZone;

import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDUtilities.StateLocation;

public interface IState
{
    public void loadState(final String stateFileName, final Logger logger) throws IOException, Exception;

    public void writeState(final String outputStateFileName, final Logger logger) throws Exception;

    public void setDateTime(final long dateTime);

    public long getDateTime();

    public void setVersion(final String value);

    public String getVersion();

    public void setStateLocation(final StateLocation value);

    public Map<String, StateLocation> getStateLocation();

    public void setLogger(final Logger logger);

    public void setId(final String id);

    public String getId();

    public void setName(final String name);

    public void setDaylightSavingObservatingTimeZone(final String daylightSavingObservatingTimeZone);

    public String getDaylightSavingObservatingTimeZone();

    public void setTimeZone(final TimeZone timeZone);

    public TimeZone getTimeZone();
}
