package ohd.hseb.util.fews;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

import ohd.hseb.util.CommandAdapter;
import ohd.hseb.util.Logger;

public abstract class LegacyAdapter
{
    protected String _workDir = null;
    protected Logger _logger;

    protected String _diagFileName;
    protected String _printDebugInfo;

    protected NwsrfsDataFileExtractor _extractor = null;

    /**
     * Instantiates a CommandAdapter and runs the external executable
     * 
     * @param arguments - Arguments to be passed to external executable
     * @param executableName executable file name -
     * @throws Exception
     */
    public void executeLegacy(final String executableName, final String[] arguments) throws Exception
    {
        final CommandAdapter cmd = new CommandAdapter();

        final File fileName = new File(executableName);

        if(!fileName.canExecute())
        {
            if(!fileName.setExecutable(true))
            {
                final String message = "Error: could not set execute permission to file : " + executableName
                    + " Check that file exist or if application can write it";
                throw new Exception(message);
            }
        }

        final String str[] = new String[arguments.length + 1];
        str[0] = executableName;

        try
        {
            _logger.log(Logger.DEBUG, "Starting legacy model/utility with arg: ");
            for(int i = 1; i < str.length; i++)
            {
                str[i] = arguments[i - 1];
                _logger.log(Logger.DEBUG, str[i]);
            }

            cmd.invoke(str);

            _logger.log(Logger.DEBUG, "C/FORTRAN executable terminated successfully");
        }
        catch(final Exception e)
        {
            // conversion of diagnostics from txt to list 
            // normally done later; but when there's a failure
            // we want logs from legacy to appear
            readFromFlatFileToDiagnosticsList();
            throw e;
        }

    }

    /**
     * converts txt diagnostics file to xml file; NOTE: this is shared by LegacyModelAdapter and LegacyUtilitiesAdapter
     * 
     * @throws Exception
     */

    public void readFromFlatFileToDiagnosticsList() throws Exception
    {

        String[] diagLine = null;
        Diagnostic currentDiag = null;
        String lineStr;
        final BufferedReader TSReader = new BufferedReader(new FileReader(_diagFileName));

        try
        {

            lineStr = TSReader.readLine();
            while(lineStr != null)
            {

                diagLine = lineStr.split(OHDConstants.PIPE_DELIMITER, 2);
                lineStr = TSReader.readLine();

                //some logs are on multiple lines, treat them the same
                //way in the output XML diagnostics file
                if(diagLine.length == 2)
                {
                    //log any previously accumulated message
                    if(((currentDiag != null) && currentDiag.getMessage() != null)
                        && (currentDiag.getMessage().length()) > 0)
                    {
                        _logger.log(currentDiag.getLevel(), currentDiag.getMessage());
                        currentDiag.clear();
                    }

                    currentDiag = new Diagnostic(diagLine[1], Integer.parseInt((diagLine[0].trim())));
                }
                else
                {
                    currentDiag.append("\n");
                    currentDiag.append(diagLine[0]);
                }

            }
            //dump any last accumulated message
            if((currentDiag != null) && (currentDiag.getMessage() != null) && (currentDiag.getMessage().length()) > 0)
            {
                _logger.log(currentDiag.getLevel(), currentDiag.getMessage());
            }

        }
        finally
        {
            TSReader.close();
        }
    }

    /**
     * Set diagnostics file name
     * 
     * @param diagFileName - diagnostics file name
     */
    public void setDiagFileName(final String diagFileName)
    {
        _diagFileName = diagFileName;
    }

    /**
     * Get diagnostics file name
     * 
     * @return diagnostics file name
     */
    public String getDiagFileName()
    {
        return _diagFileName;
    }

}
