package ohd.hseb.util.fews;

import java.util.List;

import ohd.hseb.util.fews.ParameterType.Row;

/**
 * Each LineSeg object contains a list of Row objects. Each Row object is created from a row in the table
 * "FFG_THRESHOLD_RUNOFF_1_HOUR", "FFG_THRESHOLD_RUNOFF_3_HOUR" etc. Each row object has the same threshold runoff
 * value, including missing value. Most of time, one lineseg only has one row; but if the pixels of one lineseg has two
 * different threshold runoff values, they will be divided to two rows. The first row in _rowList is the left most
 * columns, the last row in _rowList is the most right columns.
 */
public class LineSeg
{
    private final List<Row> _rowList;

    public LineSeg(final List<Row> rowList)
    {
        _rowList = rowList;
    }

    public List<Row> getRowList()
    {
        return _rowList;
    }

    /**
     * All the columns within a lineseg has the same HRAP row number.
     */
    public int getHrapRowNum()
    {
        final int num = Integer.valueOf(_rowList.get(0).getB());

        return num;
    }

    public void setHrapRowNum(final int rowNum)
    {
        for(final Row row: _rowList)
        {
            row.setB(String.valueOf(rowNum));
        }
    }

    public int getHrapStartColunm()
    {
        return Integer.valueOf(getFirstRow().getC());
    }

    public void setHrapStartColunm(final int newStartColNum)
    {
        getFirstRow().setC(String.valueOf(newStartColNum));
    }

    public int getHrapEndColunm()
    {
        return Integer.valueOf(getLastRow().getD());
    }

    public void setHrapEndColunm(final int newEndColNum)
    {
        getLastRow().setD(String.valueOf(newEndColNum));
    }

    /**
     * Get the first pixel's ffg value. If it does not exist, return a missing value.
     */
    public float getFirstPixelFfgValue()
    {
        float result = (float)OHDConstants.MISSING_DATA;

        if(getFirstRow().getF() != null)
        {
            result = Float.valueOf(getFirstRow().getF());
        }

        return result;
    }

    /**
     * Get the last pixel's ffg value. If it does not exist, return a missing value.
     */
    public float getLastPixelFfgValue()
    {
        float result = (float)OHDConstants.MISSING_DATA;

        if(getLastRow().getF() != null)
        {
            result = Float.valueOf(getLastRow().getF());
        }

        return result;
    }

    /**
     * First row covers the most left columns.
     */
    public Row getFirstRow()
    {
        return _rowList.get(0);
    }

    /**
     * Last row covers the most right columns.
     */
    public Row getLastRow()
    {
        return _rowList.get(_rowList.size() - 1);
    }

    @Override
    public String toString()
    {
        final StringBuilder builder = new StringBuilder();

        for(final Row row: _rowList)
        {
            builder.append(" A=" + row.getA()).append(" B=" + row.getB()).append(" C=" + row.getC()).append(" D="
                + row.getD()).append(" E=" + row.getE());

            if(row.getF() != null)
            {
                builder.append(" F=" + row.getF()); //ffgValue
            }
        }

        return builder.toString();
    }
}
