package ohd.hseb.util.fews;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import ohd.hseb.util.Logger;

public class NwsrfsDataFileExtractor
{

    /** "nwsrfs_datatype_mapping_file.txt" */
    public static final String DATATYPE_MAPPING_FILENAME = "nwsrfs_datatype_mapping_file.txt";

    /** "nwsrfs_dataunit_file.txt" */
    public static final String DATAUNIT_FILENAME = "nwsrfs_dataunit_file.txt";

    private final Logger _logger;
    private final String _dataTypeMappingFullPathForLegacyModels;
    private final String _dataUnitFullPathForLegacyModels;
    private String _outputDir = null;

    public NwsrfsDataFileExtractor(final String outputDir)
    {
        _outputDir = outputDir + File.separator;
        _logger = NwsrfsDataTypeMappingReader._logger;

        _dataTypeMappingFullPathForLegacyModels = _outputDir + DATATYPE_MAPPING_FILENAME;
        _dataUnitFullPathForLegacyModels = _outputDir + DATAUNIT_FILENAME;
    }

    /**
     * Copy two files {@link this#DATATYPE_MAPPING_FILENAME} and {@link this#DATAUNIT_FILENAME} from "nonsrc/utils/"
     * directory in the file system(nonsrc/ must be in Eclips's classpath) or from "utils/" directory inside the JAR
     * file(ohdcommonchps.jar) and put the text copies in the output directory for the legacy code to use.
     */
    public void copyNwsrfsFilesFromClasspath() throws Exception, FileNotFoundException, IOException
    {

        ResourceTools.copyResourcefile("utils/" + DATATYPE_MAPPING_FILENAME, _outputDir + DATATYPE_MAPPING_FILENAME);
        //access nonsrc/utils/nwsrfs_datatype_mapping_file.txt: nonsrc must be in Eclipse's classpath; "utils/nwsrfs_datatype_mapping_file.txt" is packed in ohdcommonchps.jar

        ResourceTools.copyResourcefile("utils/" + DATAUNIT_FILENAME, _outputDir + DATAUNIT_FILENAME); //same as above

    }

    private InputStream checkForNwsrfsFileInJar(final String filename, final Logger logger) throws Exception
    {
        final InputStream is = NwsrfsDataFileExtractor.class.getClassLoader().getResourceAsStream(filename);

        if(is == null)
        {
            throw new FileNotFoundException("Error opening/reading file name: " + filename + " from jar");
        }

        return is;
    }

    public InputStream getHandleToDataTypeMappingFile() throws Exception
    {

        //access nonsrc/utils/nwsrfs_datatype_mapping_file.txt: nonsrc must be in Eclipse's classpath; "utils/nwsrfs_datatype_mapping_file.txt" is packed in ohdcommonchps.jar
        return checkForNwsrfsFileInJar("utils/" + DATATYPE_MAPPING_FILENAME, _logger);

    }

    public String getDataTypeMappingFullPathForLegacyModels()
    {
        return _dataTypeMappingFullPathForLegacyModels;
    }

    public String getDataUnitFullPathForLegacyModels()
    {
        return _dataUnitFullPathForLegacyModels;
    }

}
