package ohd.hseb.util.fews;

import ohd.hseb.util.Logger;

public class OHDConfigurationInfo
{
    private String _version;
    private String _date;
    private String _ohdCoreVersion;
    private String _fewsVersion;

    private final Logger _logger;

    public OHDConfigurationInfo(final Logger logger)
    {
        _logger = logger;

    }

    /**
     * @return the version
     */
    public String getVersion()
    {
        return _version;
    }

    /**
     * @param version the version to set
     */
    public void setVersion(final String version)
    {
        this._version = version;
    }

    /**
     * @return the date
     */
    public String getDate()
    {
        return _date;
    }

    /**
     * @param date the date to set
     */
    public void setDate(final String date)
    {
        this._date = date;
    }

    /**
     * @return the chpsVersion
     */
    public String getOHDCoreVersion()
    {
        return _ohdCoreVersion;
    }

    /**
     * @param chpsVersion the chpsVersion to set
     */
    public void setOHDCoreVersion(final String ohdCoreVersion)
    {
        this._ohdCoreVersion = ohdCoreVersion;
    }

    /**
     * @return the fewsVersion
     */
    public String getFewsVersion()
    {
        return _fewsVersion;
    }

    /**
     * @param fewsVersion the fewsVersion to set
     */
    public void setFewsVersion(final String fewsVersion)
    {
        this._fewsVersion = fewsVersion;
    }

    /**
     * Put Version Control Info into the log.
     * 
     * @param debugLevel
     */
    public void logVersionControl(final int debugLevel)
    {

        _logger.log(debugLevel, "Version Control Info:");
        _logger.log(debugLevel, "Version = " + this.getVersion());
        _logger.log(debugLevel, "Date  = " + this.getDate());
        _logger.log(debugLevel, "Compatible OHD Core Version = " + this.getOHDCoreVersion());
        _logger.log(debugLevel, "Compatible FEWS Version = " + this.getFewsVersion());

    }

    @Override
    public String toString()
    {
        final StringBuilder resultStr = new StringBuilder();

        resultStr.append("Version Control Info:").append(OHDConstants.NEW_LINE);
        resultStr.append("Version = ").append(this.getVersion()).append(OHDConstants.NEW_LINE);
        resultStr.append("Date  = ").append(this.getDate()).append(OHDConstants.NEW_LINE);
        resultStr.append("Compatible OHD Core Version = ")
                 .append(this.getOHDCoreVersion())
                 .append(OHDConstants.NEW_LINE);
        resultStr.append("Compatible FEWS Version = ").append(this.getFewsVersion()).append(OHDConstants.NEW_LINE);

        return resultStr.toString();
    }

    @Override
    public Object clone()
    {
        try
        {
            final OHDConfigurationInfo cloned = (OHDConfigurationInfo)super.clone();
            return cloned;
        }
        catch(final CloneNotSupportedException e)
        {
            return null;
        }
    }

}
