package ohd.hseb.util.fews;

import java.io.BufferedInputStream;
import java.io.InputStream;

import javax.xml.stream.XMLStreamReader;

import ohd.hseb.util.Logger;
import ohd.hseb.util.xml.OHDXmlUtils;

import org.xml.sax.SAXException;

/**
 * This class load information for XML files that contain information related to version number. The idea of this class
 * is to get a way to get the version number of the CHPS model being executed. The version number is contained in a XML
 * file. Any other information could be added in the future into this xml file.
 * 
 * @author camachof
 */
public final class OHDConfigurationInfoReader
{

    private final OHDConfigurationInfo _versionCtrl;

    public OHDConfigurationInfoReader(final Logger logger, final String resourceName) throws Exception
    {
        _versionCtrl = new OHDConfigurationInfo(logger);
        this.init(logger, resourceName);
    }

    public OHDConfigurationInfo getVersionControl()
    {
        return _versionCtrl;
    }

    /**
     * Loads properties and initializes the instance with its values.
     * 
     * @throws Exception
     */
    private void init(final Logger logger, final String resourceName) throws Exception
    {
        BufferedInputStream bis = null;
        XMLStreamReader xsr = null;

        // find the file "resourceName" from the self containing jar
        final InputStream xmlFileStream = this.getClass().getClassLoader().getResourceAsStream(resourceName);

        if(xmlFileStream == null)
        {
            logger.log(Logger.WARNING, "Unable to find the XML file " + resourceName);
            throw new Exception("Unable to find the XML file " + resourceName);
        }

        final OhdFewsAdapterConfigHandler handler = new OhdFewsAdapterConfigHandler();

        try
        {
            bis = new BufferedInputStream(xmlFileStream);
            xsr = OHDXmlUtils.getStreamReader(bis, resourceName);

            handler.find(xsr); //depending on what fileHandler is, calling various *Handler's find(xsr) method

            logger.log(Logger.DEBUG, "Parsed " + resourceName);
        }
        finally
        {//close inputStream and reader no matter what happens
            if(bis != null)
            {
                bis.close();
            }

            if(xsr != null)
            {
                xsr.close();
            }

            if(xmlFileStream != null)
            {
                xmlFileStream.close();
            }
        }
    }

    /**
     * Handler to parse the xml file
     * 
     * @author camachof
     */
    public class OhdFewsAdapterConfigHandler extends FewsXmlHandler
    {

        @Override
        public void startElement(final XMLStreamReader reader) throws SAXException
        {
        }

        @Override
        public void endElement(final XMLStreamReader reader) throws SAXException
        {
            final String elementName = reader.getLocalName().trim().toUpperCase();
            if(elementName.equals("VERSION"))
            {
                _versionCtrl.setVersion(_curValue);
            }
            if(elementName.equals("DATE"))
            {
                _versionCtrl.setDate(_curValue);
            }
            if(elementName.equals("OHDCOREVERSION"))
            {
                _versionCtrl.setOHDCoreVersion(_curValue);
            }
            if(elementName.equals("FEWSVERSION"))
            {
                _versionCtrl.setFewsVersion(_curValue);
            }

            _curValue = "";
        }
    }
}
