package ohd.hseb.util.fews;

import java.util.TimeZone;
import java.util.regex.Pattern;

import ohd.hseb.measurement.MeasuringUnit;
import ohd.hseb.util.FileLogger;
import ohd.hseb.util.Logger;

final public class OHDConstants
{
    private OHDConstants()
    {
        /*
         * This class only contains static constants, so an instance of this class should never be created. If not
         * providing this private constructor, users still can create objects of this class by using the invisible
         * default constructor provided by Java, which is wrong. Now, with this private constructor, the default
         * constructor by Java is destroyed. Now, nobdy from outside of this class can create the object of OHDConstants
         */
    }

    /** diag.txt **/
    public static final String DIAGNOSTICS_FILENAME = "diag.txt";

    /** module_properties */
    public final static String PRINT_DEBUG_INFO = "printDebugInfo";
    public final static String OUTPUT_LOCATION_ID = "outputLocationId";

    /** outputDir */
    public static final String OUTPUT_DIR_NAME = "outputDir";

    /** model */
    public static final String MODEL_STRING = "model";
    /** driver */
    public static final String DRIVER_STRING = "driver";

    /** FRZE */
    public static final String FRZE_STRING = "FRZE";

    public static final String ZELV_DATATYPE = "ZELV";

    /** YES */
    public static final String YES_STRING = "YES";
    /** NO */
    public static final String NO_STRING = "NO";

    /** TRUE */
    public static final String TRUE_STR = "TRUE";
    /** FALSE */
    public static final String FALSE_STR = "FALSE";

    /** The Constant MISSING_DATA, -999.0. */
    public final static double MISSING_DATA = -999.0;

    /** The Constant MINUTES_PER_HOUR, 60 */
    public final static int MINUTES_PER_HOUR = 60;

    /** The Constant HOURS_PER_DAY, 24 */
    public final static int HOURS_PER_DAY = 24;

    /** The Constant MONTH_PER_YEAR, 12 */
    public final static int NUMBER_OF_MONTHS_IN_YEAR = 12;

    /** STRING "GMT" */
    public final static String TIMEZONE_GMT_STRING = "GMT";

    /** GMT TIME ZONE */
    public final static TimeZone GMT_TIMEZONE = TimeZone.getTimeZone(TIMEZONE_GMT_STRING);

    public final static String DEFAULT_DAYLIGHT_SAVING_OBSERVATION_TIMEZONE = null;

    /** "yyyy-MM-dd HH:mm:ss" for SimpleDateFormat usage H: 0-23;h:1-12 */
    public final static String DATE_TIME_FORMAT_STR = "yyyy-MM-dd HH:mm:ss";

    /** "yyyy-MM-dd" - for SimpleDateFormat usage */
    public final static String DATE_FORMAT_STR = "yyyy-MM-dd";

    /** "HH:mm:ss" - for SimpleDateFormat usage H: 0-23;h:1-12 */
    public final static String TIME_FORMAT_STR = "HH:mm:ss";

    /** "MMddyyyyHH" - for SimpleDateFormat usage */
    public final static String DATE_TIME_FORMAT_STR2 = "MMddyyyyHH";

    /** "MMddyyHH" - for SimpleDateFormat usage */
    public final static String DATE_TIME_FORMAT_STR3 = "MMddyyHH";

    public final static String LEGACY_LOCATION_DIR = "legacyLocation";

    /** apart by at least one space or tab */
    public final static Pattern DELIMITER_PATTERN = Pattern.compile("\\p{Blank}+");
    public final static Pattern PIPE_DELIMITER_PATTERN = Pattern.compile("\\|");
    public final static String PIPE_DELIMITER = "\\|";
    public final static Pattern SPACE_PATTERN = Pattern.compile("\\s");

    /** String "ENGLISH" */
    public final static String UNIT_ENGLISH = "ENGLISH";

    /** String "METRIC" */
    public final static String UNIT_METRIC = "METRIC";

    /** String "UNIT". The value corresponding to this tag an only be {@link #UNIT_ENGLISH} or {@link #UNIT_METRIC} */
    public final static String UNIT_TAG = "UNIT";

    public static final String OPERATION_CONTENTS_TAG = "OPERATION_CONTENTS";

    /** CMS */
    public final static MeasuringUnit DISCHARGE_UNIT = MeasuringUnit.cms;

    /** MM */
    public final static MeasuringUnit RUNOFF_UNIT = MeasuringUnit.mm;

    /** line.separator */
    public final static String NEW_LINE = System.getProperty("line.separator");

    public static final String OHD_FEWSADAPTER_CONFIG = "ohdcommonchps_config.xml";

    /** SAC-SMA STATE NAME: UPPER ZONE TENSION WATER CONTENTS */
    public static final String SAC_STATE_UZTWC = "UZTWC";

    /** SAC-SMA STATE NAME: UPPER ZONE FREE WATER CONTENTS */
    public static final String SAC_STATE_UZFWC = "UZFWC";

    /** SAC-SMA STATE NAME: LOWER ZONE TENSION WATER CONTENTS */
    public static final String SAC_STATE_LZTWC = "LZTWC";

    /** SAC-SMA STATE NAME: LOWER ZONE FREE SUPPLEMENTAL CONTENTS */
    public static final String SAC_STATE_LZFSC = "LZFSC";

    /** SAC-SMA STATE NAME: LOWER ZONE FREE PRIMARY CONTENTS */
    public static final String SAC_STATE_LZFPC = "LZFPC";

    /** SAC-SMA STATE NAME: TENSION WATER CONTENTS OF THE ADIMP AREA */
    public static final String SAC_STATE_ADIMC = "ADIMC";

    /** SAC-SMA STATE NAME: FROZEN GROUND INDEX */
    public static final String SAC_STATE_FGIX = DataType.FGIX_DATATYPE;

    /** SAC-SMA MOD SACBASEF */
    public static final String SAC_MOD_BASEF = "SACBASEF";

    /** RUNOFF COMPONENT NAME: IMPERVIOUS RUNOFF */
    static final String ROCL_IMP = "IMP_RO";

    /** RUNOFF COMPONENT NAME: DIRECT RUNOFF */
    static final String ROCL_DIR = "DIR_RO";

    /** RUNOFF COMPONENT NAME: SURFACE RUNOFF */
    static final String ROCL_SUR = "SUR_RO";

    /** RUNOFF COMPONENT NAME: INTERFLOW RUNOFF */
    static final String ROCL_INT = "INT_RO";

    /** RUNOFF COMPONENT NAME: SUPPLEMENTAL BASEFLOW */
    static final String ROCL_SUP = "SUP_RO";

    /** RUNOFF COMPONENT NAME: PRIMARY BASEFLOW */
    static final String ROCL_PRI = "PRI_RO";

    /** LOWER ZONE DEFICIENCY RATIO */
    public static final String SACSMA_LZDEFR = "LZDEFR";

    /** StartHourOfDay - property key to change the default value(12Z) to 0 for MCP3 test or other values for ESP mode */
    public final static String START_HOUR_OF_DAY = "startHourOfDay";

    /**
     * StartLocalHourOfDay - property key to set the start hour at local time zone. For most cases, the value is 12.
     */
    public final static String START_LOCAL_HOUR_OF_DAY = "startLocalHourOfDay";

    /** A useless logger, just for plugging in the method parameter */
    public static final Logger DUMMY_LOG = new FileLogger(null);

    /** NWSRFS always start from 12Z. The common sense 18Z means 6Z for NWSRFS */
    final public static int NWSRFS_START_OF_DAY = 12;
    /** 1 inch = 25.4 mm */
    public static final double MM_PER_INCH = 25.4;

    public static final double INCHES_PER_MM = 1. / MM_PER_INCH;

    /** "TS_RUNOFF_ID" */
    public final static String TS_RUNOFF_ID = "TS_RUNOFF_ID";
    /** "TS_RUNOFF_TYPE" */
    public final static String TS_RUNOFF_TYPE = "TS_RUNOFF_TYPE";
    /** "TS_ID" */
    public final static String TS_ID = "TS_ID";
    /** "TS_TYPE" */
    public final static String TS_TYPE = "TS_TYPE";
    public final static GroupOfParameters.ValidPeriod DEFAULT_VALID_PERIOD = null;

    /** "default" */
    public final static String DEFAULT_STRING = "default";

    /** FEWS RTS type */
    public final static String INSTANTANEOUS_TYPE = "instantaneous";
    public final static String ACCUMULATED_TYPE = "accumulative";
    public final static String MEAN_TYPE = "mean";

    /** 0.00999 the nearest two decimal places in metric(not for discharge, volume, or RSEL data type) */
    public final static double RFC_GENERAL_ERROR_TOLERANCE = 0.00999;

    /** The array: 1, 3, 6 */
    public final static int[] FFG_MODEL_1_3_6_INTERVAL_ARRAY = new int[]{1, 3, 6};

    /** The array: 1, 3, 6, 12 */
    public final static int[] FFG_MODEL_1_3_6_12_INTERVAL_ARRAY = new int[]{1, 3, 6, 12};

    /** The array: 1, 3, 6, 12, 24 */
    public final static int[] FFG_MODEL_1_3_6_12_24_INTERVAL_ARRAY = new int[]{1, 3, 6, 12, 24};

    public final static String FINDEX_TAG = "FROST_INDEX";

    /** SACSMA states' 7 names as array */
    public static final String[] SAC_SMA_STATE_NAMES = new String[]{SAC_STATE_UZTWC, SAC_STATE_UZFWC, SAC_STATE_LZTWC,
        SAC_STATE_LZFSC, SAC_STATE_LZFPC, SAC_STATE_ADIMC, SAC_STATE_FGIX};

    /** "ERROR in OHDFewsAdapter: ", the string will be added to the diagnostic file when the model didn't finish. */
    public final static String ERROR_MESSAGE_PREFIX = "ERROR in OHDFewsAdapter: ";
    public final static String EXLAGARRAY_TAG = "EXLAG_ARRAY"; // _exlag [MM]
    // INPUT CARD NUMBER 8
    public final static String ADC_TAG = "AREA_DEPLETION_CURVE"; // _adc = new double[11]

    /** "units" */
    public final static String UNITS_ATT_NAME = "units";

    public final static char FORWARD_SLASH_CHAR = '/';

    public final static char BACKWARD_SLASH_CHAR = '\\';

    /** "java.io.tmpdir" */
    public final static String JAVA_TEMP_DIR_PROPERTY_NAME = "java.io.tmpdir";
}
