package ohd.hseb.util.fews;

public enum PRECIP_DATATYPE
{
    RAIM(DataType.RAIM_DATATYPE), //
    MAP(DataType.MAP_DATATYPE), //
    MAPX(DataType.MAPX_DATATYPE); //

    final private String _type; //will not be changed

    private PRECIP_DATATYPE(final String type)
    {
        _type = type;
    }

    public String getTypeName()
    {
        return _type;
    }

    public static boolean isPrecipType(final String typeStr)
    {
        for(final PRECIP_DATATYPE type: values())
        {
            if(type.getTypeName().equalsIgnoreCase(typeStr))
            {
                return true;
            }
        }

        return false;
    }
}
