package ohd.hseb.util.fews;

/*
 * Copyright (c) 2006 Sun Microsystems, Inc. All rights reserved. U.S. Government Rights - Commercial software.
 * Government users are subject to the Sun Microsystems, Inc. standard license agreement and applicable provisions of
 * the FAR and its supplements. Use is subject to license terms. This distribution may include materials developed by
 * third parties. Sun, Sun Microsystems, the Sun logo, Java and J2EE are trademarks or registered trademarks of Sun
 * Microsystems, Inc. in the U.S. and other countries. Copyright (c) 2006 Sun Microsystems, Inc. Tous droits reserves.
 * Droits du gouvernement americain, utilisateurs gouvernementaux - logiciel commercial. Les utilisateurs
 * gouvernementaux sont soumis au contrat de licence standard de Sun Microsystems, Inc., ainsi qu'aux dispositions en
 * vigueur de la FAR (Federal Acquisition Regulations) et des supplements a celles-ci. Distribue par des licences qui en
 * restreignent l'utilisation. Cette distribution peut comprendre des composants developpes par des tierces parties.
 * Sun, Sun Microsystems, le logo Sun, Java et J2EE sont des marques de fabrique ou des marques deposees de Sun
 * Microsystems, Inc. aux Etats-Unis et dans d'autres pays.
 */

import java.util.ArrayList;
import java.util.List;

import javax.xml.stream.XMLStreamReader;

import ohd.hseb.util.Logger;

import org.xml.sax.SAXException;

final public class ParameterHandler extends FewsXmlHandler
{

    private final Parameters _parameters;
    private GroupOfParameters _group;
    private ParameterType _parameter;
    private ParameterType.Table _table;
    private ParameterType.Row _columns;
    private GroupOfParameters.ValidPeriod _validPeriod = OHDConstants.DEFAULT_VALID_PERIOD;

    private boolean _isParameter = true;
    private int _validPeriodCount = 0;

    // We need to keep the order of insertion to be able to get the last inserted ValidPeriod object when repeated.
    private final List<GroupOfParameters> _parameterList = new ArrayList<GroupOfParameters>();

    public ParameterHandler(final Parameters parameters, final Logger log)
    {
        _parameters = parameters;

        _parameters.setLogger(log);

        _logger = log;
    }

    @Override
    protected void endDocument() throws SAXException
    {
        try
        {
            _parameters.setNumberOfValidPeriods(_validPeriodCount);
            _parameters.setParametersFromList(_parameterList);
        }
        catch(final Exception e)
        {

            final SAXException spe = new SAXException(e.getMessage());
            throw spe;
        }

    }

    @Override
    public void startElement(final XMLStreamReader reader) throws SAXException
    {

        _curValue = ""; //initial it to ""

        final int numAttributes = reader.getAttributeCount();
        final String elementName = reader.getLocalName().trim();

        if(elementName.equals("parameters"))
        {
            final String attributeName = reader.getAttributeName(0).toString();
            final String attributeValue = reader.getAttributeValue(0).toString().trim();

            if(attributeName.equals("version"))
            {
                _parameters.setVersion(attributeValue);
            }
        }
        else if(elementName.equals("group"))
        {
            _group = new GroupOfParameters();
            for(int i = 0; i < numAttributes; i++)
            {
                final String attributeName = reader.getAttributeName(i).toString();
                final String attributeValue = reader.getAttributeValue(i).toString().trim();
                if(attributeName.equals("id"))
                {
                    _logger.log(Logger.DEBUG, "Loading the parameter of " + attributeValue + ".");

                    _group.setId(attributeValue);
                }
                else if(attributeName.equals("name"))
                {
                    _group.setName(attributeValue);
                }
                else if(attributeName.equals("readonly"))
                {
                    _group.setReadonly(Boolean.valueOf(attributeValue));
                }
            }
        }
        if(elementName.equals("validPeriod"))
        {

            _validPeriod = new GroupOfParameters.ValidPeriod();
        }
        else if(elementName.equals("startDate") || elementName.equals("endDate")
            || elementName.equals("validBeforeDate") || elementName.equals("validAfterDate"))
        {

            String date = null;
            String time = null;
            for(int i = 0; i < numAttributes; i++)
            {
                final String attributeName = reader.getAttributeName(i).toString();
                final String attributeValue = reader.getAttributeValue(i).toString().trim();
                if(attributeName.equals("date"))
                {
                    date = attributeValue;
                }
                else if(attributeName.equals("time"))
                {
                    time = attributeValue;
                }
            }
            final GroupOfParameters.DateTime dateTime = new GroupOfParameters.DateTime();
            dateTime.setDate(date);
            dateTime.setTime(time);
            if(elementName.equals("startDate"))
            {
                _validPeriod.setStartDate(dateTime);
            }
            else if(elementName.equals("endDate"))
            {
                _validPeriod.setEndDate(dateTime);
            }
            else if(elementName.equals("validBeforeDate"))
            {
                _validPeriod.setValidBeforeDate(dateTime);
            }
            else if(elementName.equals("validAfterDate"))
            {
                _validPeriod.setValidAfterDate(dateTime);
            }
        }
        else if(elementName.equals("parameter"))
        {
            _isParameter = true;
            _parameter = new ParameterType();
            for(int i = 0; i < numAttributes; i++)
            {
                final String attributeName = reader.getAttributeName(i).toString();
                final String attributeValue = reader.getAttributeValue(i).toString().trim();
                if(attributeName.equals("id"))
                {
                    _parameter.setId(attributeValue.toUpperCase());
                }
                else if(attributeName.equals("name"))
                {
                    _parameter.setName(attributeValue);
                }
                else if(attributeName.equals("modified"))
                {
                    _parameter.setModified(Boolean.valueOf(attributeValue));
                }
            }
        }
        if(elementName.equals("table"))
        {
            _table = new ParameterType.Table();
        }
        else if(elementName.equals("columnIds") || elementName.equals("columnTypes") || elementName.equals("row"))
        {
            _columns = new ParameterType.Row();
            for(int i = 0; i < numAttributes; i++)
            {
                final char attributeName = reader.getAttributeName(i).toString().charAt(0);
                final String attributeValue = reader.getAttributeValue(i).toString().trim();

                /**
                 * FOR TVA request. if there is a "NaN" value the whole row will be ignored.
                 */

                if(attributeValue.equals("NaN"))
                {
                    _columns = null;
//                    _logger.log(Logger.WARNING, "The parameter " + _parameter.getId()
//                        + " of type Table has a row with 'NaN' value. Row will be ignored.");
                    break;
                }

                switch(attributeName)
                {
                    case 'A':
                        _columns.setA(attributeValue);
                        break;
                    case 'B':
                        _columns.setB(attributeValue);
                        break;
                    case 'C':
                        _columns.setC(attributeValue);
                        break;
                    case 'D':
                        _columns.setD(attributeValue);
                        break;
                    case 'E':
                        _columns.setE(attributeValue);
                        break;
                    case 'F':
                        _columns.setF(attributeValue);
                        break;
                    case 'G':
                        _columns.setG(attributeValue);
                        break;
                    case 'H':
                        _columns.setH(attributeValue);
                        break;
                    case 'I':
                        _columns.setI(attributeValue);
                        break;
                    case 'J':
                        _columns.setJ(attributeValue);
                        break;
                    case 'K':
                        _columns.setK(attributeValue);
                        break;
                    case 'L':
                        _columns.setL(attributeValue);
                        break;
                    case 'M':
                        _columns.setM(attributeValue);
                        break;
                    case 'N':
                        _columns.setN(attributeValue);
                        break;
                    case 'O':
                        _columns.setO(attributeValue);
                        break;
                    case 'P':
                        _columns.setP(attributeValue);
                        break;
                    case 'Q':
                        _columns.setQ(attributeValue);
                        break;
                    case 'R':
                        _columns.setR(attributeValue);
                        break;
                    case 'S':
                        _columns.setS(attributeValue);
                        break;
                    case 'T':
                        _columns.setT(attributeValue);
                        break;
                    case 'U':
                        _columns.setU(attributeValue);
                        break;
                    case 'V':
                        _columns.setV(attributeValue);
                        break;
                    case 'W':
                        _columns.setW(attributeValue);
                        break;
                    case 'X':
                        _columns.setX(attributeValue);
                        break;
                    case 'Y':
                        _columns.setY(attributeValue);
                        break;
                    case 'Z':
                        _columns.setZ(attributeValue);
                        break;
                    default:
                        break;
                } // end of switch
            }
        }

    }

    @Override
    public void endElement(final XMLStreamReader reader) throws SAXException
    {

        //done with one parameter, so put it in model's parameter map 
        /* Need to set and check null tags since parser calls start/endElement methods multiple times */

        final String elementName = reader.getLocalName().trim();

        if(elementName.equals("group"))
        {
            _group.setParameter(_parameter);
            // TODO: need to set ensemble when needed.
            //_group.setEnsemble(value);
            _parameterList.add(_group);
            if(_group.getValidPeriod() == OHDConstants.DEFAULT_VALID_PERIOD)
            {
                _validPeriodCount++;
            }
        }
        if(elementName.equals("locationId"))
        {
            _group.setLocationId(_curValue);
        }
        if(elementName.equals("model"))
        {
            _group.setModel(_curValue);
        }
        // valid period
        if(elementName.equals("validPeriod"))
        {
            _group.setValidPeriod(_validPeriod);
        }
        if(elementName.equals("timeZone"))
        {
            _validPeriod.setTimeZone(Double.valueOf(_curValue));
        }
        if(elementName.equals("startMonthDay"))
        {
            _validPeriod.setStartMonthDay(_curValue);
        }
        if(elementName.equals("endMonthDay"))
        {
            _validPeriod.setEndMonthDay(_curValue);
        }
        if(elementName.equals("monthDay"))
        {
            _validPeriod.setMonthDay(_curValue);
        }
        if(elementName.equals("month"))
        {
            _validPeriod.setMonthDay(_curValue);
        }
        if(elementName.equals("day"))
        {
            _validPeriod.setDay(_curValue);
        }
        // parameter
        if(elementName.equals("parameter"))
        {
            _isParameter = false;
            _group.setParameter(_parameter);
        }
        else if(elementName.equals("description"))
        {
            if(_isParameter)
            {
                _parameter.setDescription(_curValue);
            }
            else
            {
                _group.setDescription(_curValue);
            }
        }
        else if(elementName.equals("dblValue"))
        {
            _parameter.setDblValue(Double.valueOf(_curValue.trim()));
        }
        else if(elementName.equals("intValue"))
        {
            _parameter.setIntValue(Integer.valueOf(_curValue.trim()));
        }
        else if(elementName.equals("boolValue"))
        {
            _parameter.setBoolValue(Boolean.valueOf(_curValue.trim()));
        }
        else if(elementName.equals("stringValue"))
        {
            _parameter.setStringValue(_curValue);
        }
        // table values
        else if(elementName.equals("columnIds"))
        {
            _table.setColumnIds(_columns);
        }
        else if(elementName.equals("columnTypes"))
        {
            _table.setColumnTypes(_columns);
        }
        else if(elementName.equals("row"))
        {
            /**
             * FOR TVA request. if there is a "NaN" value the whole row will be ignored. The column will be set to null
             * if a "NaN" was found.
             */
            if(_columns != null)
            {
                _table.setRow(_columns);
            }
        }
        else if(elementName.equals("table"))
        {
            _parameter.setTable(_table);
        }

    }

}
