package ohd.hseb.util.fews;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;


public class ParameterType
{

    protected String _description = null;
    protected Double _dblValue = null;
    protected Integer _intValue = null;
    protected Boolean _boolValue = null;
    protected String _stringValue = null;
    protected Table _table = null;
    protected String _id = null;
    protected String _name = null;
    protected Boolean _modified = null;
    
    public final static int doubleType = 0;
    public final static int integerType = 1;
    public final static int booleanType = 2;
    public final static int stringType = 3;
    public final static int tableType = 4;
    public final static String[] typeName = {"Double", "Integer", "Boolean", "String", "Table"};
    
    public int getType()
    {
    	int returnType = ParameterType.stringType;
    	
    	if (this.getDblValue() != null)
    		returnType = ParameterType.doubleType;
    	else if (this.getIntValue() != null)
    		returnType = ParameterType.integerType;
    	else if (this.getBoolValue() != null)
    		returnType = ParameterType.booleanType;
    	else if (this.getStringValue() != null)
    		returnType = ParameterType.stringType;
    	else if (this.getTable() != null)
    		returnType = ParameterType.tableType;
    	
    	return returnType;
    }
    public String getTypeName()
    {
    	String typeName = ParameterType.typeName[3];
    	switch(getType())
    	{
    	case ParameterType.doubleType:
    		typeName = ParameterType.typeName[0];
    		break;
    	case ParameterType.integerType:
    		typeName = ParameterType.typeName[1];
    		break;
    	case ParameterType.booleanType:
    		typeName = ParameterType.typeName[2];
    		break;
    	case ParameterType.stringType:
    		typeName = ParameterType.typeName[3];
    		break;
    	case ParameterType.tableType:
    		typeName = ParameterType.typeName[4];
    		break;
    	}
    	return typeName;
    }

    /**
     * Copies the parameters for this object from the passed in ModelParameterType object. This does a copy for every
     * attribute, except _table which will be the same object as that within base (so if you modify base's _table,
     * you'll modify this _table).
     */
    public void copyFrom(final ParameterType base)
    {
        this._description = base.getDescription();
        this._dblValue = base.getDblValue();
        this._intValue = base.getIntValue();
        this._boolValue = base.getBoolValue();
        this._stringValue = base.getStringValue();
        this._table = base.getTable();
        this._id = base.getId();
        this._name = base.getName();
        this._modified = base.getModified();
    }

    /**
     * Gets the value of the description property.
     * 
     * @return possible object is {@link String }
     */
    public String getDescription()
    {
        return _description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setDescription(final String value)
    {
        this._description = value;
    }

    /**
     * Gets the value of the dblValue property.
     * 
     * @return possible object is {@link Double }
     */
    public Double getDblValue()
    {
        return _dblValue;
    }

    /**
     * Sets the value of the dblValue property.
     * 
     * @param value allowed object is {@link Double }
     */
    public void setDblValue(final Double value)
    {
        this._dblValue = value;
    }

    /**
     * Gets the value of the intValue property.
     * 
     * @return possible object is {@link BigInteger }
     */
    public Integer getIntValue()
    {
        return _intValue;
    }

    /**
     * Sets the value of the intValue property.
     * 
     * @param value allowed object is {@link BigInteger }
     */
    public void setIntValue(final Integer value)
    {
        this._intValue = value;
    }

    /**
     * Gets the value of the boolValue property.
     * 
     * @return possible object is {@link Boolean }
     */
    public Boolean getBoolValue()
    {
        return _boolValue;
    }

    /**
     * Sets the value of the boolValue property.
     * 
     * @param value allowed object is {@link Boolean }
     */
    public void setBoolValue(final Boolean value)
    {
        this._boolValue = value;
    }

    /**
     * Gets the value of the stringValue property.
     * 
     * @return possible object is {@link String }
     */
    public String getStringValue()
    {
        return _stringValue;
    }

    /**
     * Sets the value of the stringValue property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setStringValue(final String value)
    {
        this._stringValue = value;
    }

    /**
     * Gets the value of the table property.
     * 
     * @return possible object is {@link GlobalTableComplexType }
     */
    public Table getTable()
    {
        return _table;
    }

    /**
     * Sets the value of the table property.
     * 
     * @param value allowed object is {@link GlobalTableComplexType }
     */
    public void setTable(final Table value)
    {
        this._table = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return possible object is {@link String }
     */
    public String getId()
    {
        return _id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setId(final String value)
    {
        this._id = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return possible object is {@link String }
     */
    public String getName()
    {
        return _name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setName(final String value)
    {
        this._name = value;
    }

    /**
     * Gets the value of the modified property.
     * 
     * @return possible object is {@link Boolean }
     */
    public Boolean getModified()
    {
//      if(_modified == null)
//      {
//          return false;
//      }
//      else
//      {
//          return _modified;
//      }
        return _modified;
    }

    /**
     * Sets the value of the modified property.
     * 
     * @param value allowed object is {@link Boolean }
     */
    public void setModified(final Boolean value)
    {
        this._modified = value;
    }

    @Override
    public String toString()
    {
        final StringBuffer resultStr = new StringBuffer();

        resultStr.append("Id = " + this.getId());
        resultStr.append(OHDConstants.NEW_LINE);
        if(this.getName() != null)
        {
            resultStr.append("Name = " + this.getName());
            resultStr.append(OHDConstants.NEW_LINE);
        }
        if(_modified != null)
        {
            resultStr.append("Modified = " + this.getModified());
            resultStr.append(OHDConstants.NEW_LINE);
        }

        resultStr.append("Description = " + this.getDescription());
        resultStr.append(OHDConstants.NEW_LINE);
        if(this.getDblValue() != null)
        {
            resultStr.append("Double value = " + this.getDblValue());
            resultStr.append(OHDConstants.NEW_LINE);
        }
        if(this.getIntValue() != null)
        {
            resultStr.append("Integer value = " + this.getIntValue());
            resultStr.append(OHDConstants.NEW_LINE);
        }
        if(this.getBoolValue() != null)
        {
            resultStr.append("Boolean Value = " + this.getBoolValue());
            resultStr.append(OHDConstants.NEW_LINE);
        }
        if(this.getStringValue() != null)
        {
            resultStr.append("String Value = " + this.getStringValue());
            resultStr.append(OHDConstants.NEW_LINE);
        }
        if(this.getTable() != null)
        {
            resultStr.append("table:").append(OHDConstants.NEW_LINE);
            resultStr.append(this.getTable().toString());
        }
        return resultStr.toString();
    }

    @Override
    public boolean equals(Object other)
    {
        boolean returnVal = false;

        if(other == this)
        {
            returnVal = true;
        }
        else if(other == null)
        {
            returnVal = false;
        }
        else if(!getClass().equals(other.getClass()))
        {
            returnVal = false;
        }
        else if(other instanceof ParameterType)
        {
            ParameterType other2 = (ParameterType)other;
            returnVal = testEqualsWithNull(this.getBoolValue(), other2.getBoolValue())
                && testEqualsWithNull(this.getDblValue(), other2.getDblValue())
                && testEqualsWithNull(this.getDescription(), other2.getDescription())
                && testEqualsWithNull(this.getId(), other2.getId())
                && testEqualsWithNull(this.getIntValue(), other2.getIntValue())
                && testEqualsWithNull(this.getModified(), other2.getModified())
                && testEqualsWithNull(this.getName(), other2.getName())
                && testEqualsWithNull(this.getStringValue(), other2.getStringValue())
                && testEqualsWithNull(this.getTable(), other2.getTable());

        }

        return returnVal;
    }

    private static boolean testEqualsWithNull(Object a, Object b)
    {
        return (a == null && b == null) || (a != null && b != null) && (a.equals(b));
    }

    /**
     * *****************************************************************
     * 
     * @author camachof
     */

    public static class Table
    {

        protected Row columnIds = null;
        protected Row columnTypes = null;
        protected List<Row> row = null;

        /**
         * Gets the value of the columnIds property.
         * 
         * @return possible object is {@link ColumnIdsComplexType }
         */
        public Row getColumnIds()
        {
            return columnIds;
        }

        /**
         * Sets the value of the columnIds property.
         * 
         * @param value allowed object is {@link ColumnIdsComplexType }
         */
        public void setColumnIds(final Row value)
        {
            this.columnIds = value;
        }

        /**
         * Gets the value of the columnTypes property.
         * 
         * @return possible object is {@link ColumnTypes }
         */
        public Row getColumnTypes()
        {
            return columnTypes;
        }

        /**
         * Sets the value of the columnTypes property.
         * 
         * @param value allowed object is {@link ColumnTypes }
         */
        public void setColumnTypes(final Row value)
        {
            this.columnTypes = value;
        }

        /**
         * Gets the value of the row property.
         * <p>
         * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you
         * make to the returned list will be present inside the JAXB object. This is why there is not a <CODE>set</CODE>
         * method for the row property.
         * <p>
         * For example, to add a new item, do as follows:
         * 
         * <pre>
         * getRow().add(newItem);
         * </pre>
         * <p>
         * Objects of the following type(s) are allowed in the list {@link RowComplexType }
         */
        public List<Row> getRow()
        {
            if(row == null)
            {
                row = new ArrayList<Row>();
            }
            return this.row;
        }

        public void setRow(final Row value)
        {
            if(row == null)
            {
                row = new ArrayList<Row>();
            }
            this.row.add(value);
        }

        @Override
        public String toString()
        {
            final StringBuffer resultStr = new StringBuffer();
            resultStr.append("Table").append(OHDConstants.NEW_LINE);
            if(this.getColumnIds() != null)
            {
                resultStr.append("Column Ids").append(OHDConstants.NEW_LINE);
                resultStr.append(this.getColumnIds().toString());
            }
            if(this.getColumnTypes() != null)
            {
                resultStr.append("Column Types").append(OHDConstants.NEW_LINE);
                resultStr.append(this.getColumnTypes().toString());
            }
            if(this.getRow() != null)
            {
                resultStr.append("Row").append(OHDConstants.NEW_LINE);
                for(final Row row: this.getRow())
                {
                    if(row != null)
                    {
                        resultStr.append(row.toString());
                    }
                }
            }

            return resultStr.toString();
        }

        @Override
        public boolean equals(Object other)
        {
            boolean returnVal = false;

            if(other == this)
            {
                returnVal = true;
            }
            else if(other == null)
            {
                returnVal = false;
            }
            else if(!getClass().equals(other.getClass()))
            {
                returnVal = false;
            }
            else if(other instanceof Table)
            {
                Table other2 = (Table)other;
                returnVal = testEqualsWithNull(this.getColumnIds(), other2.getColumnIds())
                    && testEqualsWithNull(this.getColumnTypes(), other2.getColumnTypes())
                    && testEqualsWithNull(this.getRow(), other2.getRow());

            }

            return returnVal;
        }
    }

    /**
     * ***************************************************
     * 
     * @author camachof
     */
    public static class Row
    {

        protected String a = null;
        protected String b = null;
        protected String c = null;
        protected String d = null;
        protected String e = null;
        protected String f = null;
        protected String g = null;
        protected String h = null;
        protected String i = null;
        protected String j = null;
        protected String k = null;
        protected String l = null;
        protected String m = null;
        protected String n = null;
        protected String o = null;
        protected String p = null;
        protected String q = null;
        protected String r = null;
        protected String s = null;
        protected String t = null;
        protected String u = null;
        protected String v = null;
        protected String w = null;
        protected String x = null;
        protected String y = null;
        protected String z = null;

        /**
         * Gets the value of the a property.
         * 
         * @return possible object is {@link String }
         */
        public String getA()
        {
            return a;
        }

        /**
         * Sets the value of the a property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setA(final String value)
        {
            this.a = value;
        }

        /**
         * Gets the value of the b property.
         * 
         * @return possible object is {@link String }
         */
        public String getB()
        {
            return b;
        }

        /**
         * Sets the value of the b property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setB(final String value)
        {
            this.b = value;
        }

        /**
         * Gets the value of the c property.
         * 
         * @return possible object is {@link String }
         */
        public String getC()
        {
            return c;
        }

        /**
         * Sets the value of the c property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setC(final String value)
        {
            this.c = value;
        }

        /**
         * Gets the value of the d property.
         * 
         * @return possible object is {@link String }
         */
        public String getD()
        {
            return d;
        }

        /**
         * Sets the value of the d property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setD(final String value)
        {
            this.d = value;
        }

        /**
         * Gets the value of the e property.
         * 
         * @return possible object is {@link String }
         */
        public String getE()
        {
            return e;
        }

        /**
         * Sets the value of the e property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setE(final String value)
        {
            this.e = value;
        }

        /**
         * Gets the value of the f property.
         * 
         * @return possible object is {@link String }
         */
        public String getF()
        {
            return f;
        }

        /**
         * Sets the value of the f property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setF(final String value)
        {
            this.f = value;
        }

        /**
         * Gets the value of the g property.
         * 
         * @return possible object is {@link String }
         */
        public String getG()
        {
            return g;
        }

        /**
         * Sets the value of the g property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setG(final String value)
        {
            this.g = value;
        }

        /**
         * Gets the value of the h property.
         * 
         * @return possible object is {@link String }
         */
        public String getH()
        {
            return h;
        }

        /**
         * Sets the value of the h property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setH(final String value)
        {
            this.h = value;
        }

        /**
         * Gets the value of the i property.
         * 
         * @return possible object is {@link String }
         */
        public String getI()
        {
            return i;
        }

        /**
         * Sets the value of the i property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setI(final String value)
        {
            this.i = value;
        }

        /**
         * Gets the value of the j property.
         * 
         * @return possible object is {@link String }
         */
        public String getJ()
        {
            return j;
        }

        /**
         * Sets the value of the j property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setJ(final String value)
        {
            this.j = value;
        }

        /**
         * Gets the value of the k property.
         * 
         * @return possible object is {@link String }
         */
        public String getK()
        {
            return k;
        }

        /**
         * Sets the value of the k property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setK(final String value)
        {
            this.k = value;
        }

        /**
         * Gets the value of the l property.
         * 
         * @return possible object is {@link String }
         */
        public String getL()
        {
            return l;
        }

        /**
         * Sets the value of the l property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setL(final String value)
        {
            this.l = value;
        }

        /**
         * Gets the value of the m property.
         * 
         * @return possible object is {@link String }
         */
        public String getM()
        {
            return m;
        }

        /**
         * Sets the value of the m property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setM(final String value)
        {
            this.m = value;
        }

        /**
         * Gets the value of the n property.
         * 
         * @return possible object is {@link String }
         */
        public String getN()
        {
            return n;
        }

        /**
         * Sets the value of the n property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setN(final String value)
        {
            this.n = value;
        }

        /**
         * Gets the value of the o property.
         * 
         * @return possible object is {@link String }
         */
        public String getO()
        {
            return o;
        }

        /**
         * Sets the value of the o property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setO(final String value)
        {
            this.o = value;
        }

        /**
         * Gets the value of the p property.
         * 
         * @return possible object is {@link String }
         */
        public String getP()
        {
            return p;
        }

        /**
         * Sets the value of the p property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setP(final String value)
        {
            this.p = value;
        }

        /**
         * Gets the value of the q property.
         * 
         * @return possible object is {@link String }
         */
        public String getQ()
        {
            return q;
        }

        /**
         * Sets the value of the q property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setQ(final String value)
        {
            this.q = value;
        }

        /**
         * Gets the value of the r property.
         * 
         * @return possible object is {@link String }
         */
        public String getR()
        {
            return r;
        }

        /**
         * Sets the value of the r property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setR(final String value)
        {
            this.r = value;
        }

        /**
         * Gets the value of the s property.
         * 
         * @return possible object is {@link String }
         */
        public String getS()
        {
            return s;
        }

        /**
         * Sets the value of the s property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setS(final String value)
        {
            this.s = value;
        }

        /**
         * Gets the value of the t property.
         * 
         * @return possible object is {@link String }
         */
        public String getT()
        {
            return t;
        }

        /**
         * Sets the value of the t property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setT(final String value)
        {
            this.t = value;
        }

        /**
         * Gets the value of the u property.
         * 
         * @return possible object is {@link String }
         */
        public String getU()
        {
            return u;
        }

        /**
         * Sets the value of the u property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setU(final String value)
        {
            this.u = value;
        }

        /**
         * Gets the value of the v property.
         * 
         * @return possible object is {@link String }
         */
        public String getV()
        {
            return v;
        }

        /**
         * Sets the value of the v property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setV(final String value)
        {
            this.v = value;
        }

        /**
         * Gets the value of the w property.
         * 
         * @return possible object is {@link String }
         */
        public String getW()
        {
            return w;
        }

        /**
         * Sets the value of the w property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setW(final String value)
        {
            this.w = value;
        }

        /**
         * Gets the value of the x property.
         * 
         * @return possible object is {@link String }
         */
        public String getX()
        {
            return x;
        }

        /**
         * Sets the value of the x property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setX(final String value)
        {
            this.x = value;
        }

        /**
         * Gets the value of the y property.
         * 
         * @return possible object is {@link String }
         */
        public String getY()
        {
            return y;
        }

        /**
         * Sets the value of the y property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setY(final String value)
        {
            this.y = value;
        }

        /**
         * Gets the value of the z property.
         * 
         * @return possible object is {@link String }
         */
        public String getZ()
        {
            return z;
        }

        /**
         * Sets the value of the z property.
         * 
         * @param value allowed object is {@link String }
         */
        public void setZ(final String value)
        {
            this.z = value;
        }
        
        public String get(char c)
        {
        	String value = "";
        	switch (c)
        	{
        	case 'A': case 'a':
        		value = getA();
        		break;
        	case 'B': case 'b':
        		value = getB();
        		break;
        	case 'C': case 'c':
        		value = getC();
        		break;
        	case 'D': case 'd':
        		value = getD();
        		break;
        	case 'E': case 'e':
        		value = getE();
        		break;
        	case 'F': case 'f':
        		value = getF();
        		break;
        	case 'G': case 'g':
        		value = getG();
        		break;
        	case 'H': case 'h':
        		value = getH();
        		break;
        	case 'I': case 'i':
        		value = getI();
        		break;
        	case 'J': case 'j':
        		value = getJ();
        		break;
        	case 'K': case 'k':
        		value = getK();
        		break;
        	case 'L': case 'l':
        		value = getL();
        		break;
        	case 'M': case 'm':
        		value = getM();
        		break;
        	case 'N': case 'n':
        		value = getN();
        		break;
        	case 'O': case 'o':
        		value = getO();
        		break;
        	case 'P': case 'p':
        		value = getP();
        		break;
        	case 'Q': case 'q':
        		value = getQ();
        		break;
        	case 'R': case 'r':
        		value = getR();
        		break;
        	case 'S': case 's':
        		value = getS();
        		break;
        	case 'T': case 't':
        		value = getT();
        		break;
        	case 'U': case 'u':
        		value = getU();
        		break;
        	case 'V': case 'v':
        		value = getV();
        		break;
        	case 'W': case 'w':
        		value = getW();
        		break;
        	case 'X': case 'x':
        		value = getX();
        		break;
        	case 'Y': case 'y':
        		value = getY();
        		break;
        	case 'Z': case 'z':
        		value = getZ();
        		break;
        	}
        	return value;
        }
        public void set(char c, String value)
        {
        	switch (c)
        	{
        	case 'A': case 'a':
        		setA(value);
        		break;
        	case 'B': case 'b':
        		setB(value);
        		break;
        	case 'C': case 'c':
        		setC(value);
        		break;
        	case 'D': case 'd':
        		setD(value);
        		break;
        	case 'E': case 'e':
        		setE(value);
        		break;
        	case 'F': case 'f':
        		setF(value);
        		break;
        	case 'G': case 'g':
        		setG(value);
        		break;
        	case 'H': case 'h':
        		setH(value);
        		break;
        	case 'I': case 'i':
        		setI(value);
        		break;
        	case 'J': case 'j':
        		setJ(value);
        		break;
        	case 'K': case 'k':
        		setK(value);
        		break;
        	case 'L': case 'l':
        		setL(value);
        		break;
        	case 'M': case 'm':
        		setM(value);
        		break;
        	case 'N': case 'n':
        		setN(value);
        		break;
        	case 'O': case 'o':
        		setO(value);
        		break;
        	case 'P': case 'p':
        		setP(value);
        		break;
        	case 'Q': case 'q':
        		setQ(value);
        		break;
        	case 'R': case 'r':
        		setR(value);
        		break;
        	case 'S': case 's':
        		setS(value);
        		break;
        	case 'T': case 't':
        		setT(value);
        		break;
        	case 'U': case 'u':
        		setU(value);
        		break;
        	case 'V': case 'v':
        		setV(value);
        		break;
        	case 'W': case 'w':
        		setW(value);
        		break;
        	case 'X': case 'x':
        		setX(value);
        		break;
        	case 'Y': case 'y':
        		setY(value);
        		break;
        	case 'Z': case 'z':
        		setZ(value);
        		break;
        	}
        }

        @Override
        public String toString()
        {
            final StringBuffer resultStr = new StringBuffer();

            if(this.getA() != null)
            {
                resultStr.append("A = " + this.getA());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getB() != null)
            {
                resultStr.append("B = " + this.getB());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getC() != null)
            {
                resultStr.append("C = " + this.getC());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getD() != null)
            {
                resultStr.append("D = " + this.getD());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getE() != null)
            {
                resultStr.append("E = " + this.getE());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getF() != null)
            {
                resultStr.append("F = " + this.getF());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getG() != null)
            {
                resultStr.append("G = " + this.getG());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getH() != null)
            {
                resultStr.append("H = " + this.getH());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getI() != null)
            {
                resultStr.append("I = " + this.getI());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getJ() != null)
            {
                resultStr.append("J = " + this.getJ());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getK() != null)
            {
                resultStr.append("K = " + this.getK());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getL() != null)
            {
                resultStr.append("L = " + this.getL());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getM() != null)
            {
                resultStr.append("M = " + this.getM());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getN() != null)
            {
                resultStr.append("N = " + this.getN());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getO() != null)
            {
                resultStr.append("O = " + this.getO());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getP() != null)
            {
                resultStr.append("P = " + this.getP());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getQ() != null)
            {
                resultStr.append("Q = " + this.getQ());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getR() != null)
            {
                resultStr.append("R = " + this.getR());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getS() != null)
            {
                resultStr.append("S = " + this.getS());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getT() != null)
            {
                resultStr.append("T = " + this.getT());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getU() != null)
            {
                resultStr.append("U = " + this.getU());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getV() != null)
            {
                resultStr.append("V = " + this.getV());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getW() != null)
            {
                resultStr.append("W = " + this.getW());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getX() != null)
            {
                resultStr.append("X = " + this.getX());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getY() != null)
            {
                resultStr.append("Y = " + this.getY());
                resultStr.append(OHDConstants.NEW_LINE);
            }
            if(this.getZ() != null)
            {
                resultStr.append("Z = " + this.getZ());
                resultStr.append(OHDConstants.NEW_LINE);
            }

            return resultStr.toString();
        }

        @Override
        public boolean equals(Object other)
        {
            boolean returnVal = false;

            if(other == this)
            {
                returnVal = true;
            }
            else if(other == null)
            {
                returnVal = false;
            }
            else if(!getClass().equals(other.getClass()))
            {
                returnVal = false;
            }
            else if(other instanceof Row)
            {
                Row other2 = (Row)other;
                returnVal = testEqualsWithNull(this.getA(), other2.getA())
                    && testEqualsWithNull(this.getB(), other2.getB()) && testEqualsWithNull(this.getC(), other2.getC())
                    && testEqualsWithNull(this.getD(), other2.getD()) && testEqualsWithNull(this.getE(), other2.getE())
                    && testEqualsWithNull(this.getF(), other2.getF()) && testEqualsWithNull(this.getG(), other2.getG())
                    && testEqualsWithNull(this.getH(), other2.getH()) && testEqualsWithNull(this.getI(), other2.getI())
                    && testEqualsWithNull(this.getJ(), other2.getJ()) && testEqualsWithNull(this.getK(), other2.getK())
                    && testEqualsWithNull(this.getL(), other2.getL()) && testEqualsWithNull(this.getM(), other2.getM())
                    && testEqualsWithNull(this.getN(), other2.getN()) && testEqualsWithNull(this.getO(), other2.getO())
                    && testEqualsWithNull(this.getP(), other2.getP()) && testEqualsWithNull(this.getQ(), other2.getQ())
                    && testEqualsWithNull(this.getR(), other2.getR()) && testEqualsWithNull(this.getS(), other2.getS())
                    && testEqualsWithNull(this.getT(), other2.getT()) && testEqualsWithNull(this.getU(), other2.getU())
                    && testEqualsWithNull(this.getV(), other2.getV()) && testEqualsWithNull(this.getW(), other2.getW())
                    && testEqualsWithNull(this.getX(), other2.getX()) && testEqualsWithNull(this.getY(), other2.getY())
                    && testEqualsWithNull(this.getZ(), other2.getZ());
            }

            return returnVal;
        }
    }

    /**
     * **************************
     * 
     * @author camachof
     */
    public class ColumnIds extends Row
    {
    }

    public class ColumnTypes extends ColumnIds
    {
    }

    /**
     * ***************************************************************
     * 
     * @author camachof
     */
    public class ColumnTypesOriginal
    {
        protected ValueTypeEnumStringType a;
        protected ValueTypeEnumStringType b;
        protected ValueTypeEnumStringType c;
        protected ValueTypeEnumStringType d;
        protected ValueTypeEnumStringType e;
        protected ValueTypeEnumStringType f;
        protected ValueTypeEnumStringType g;
        protected ValueTypeEnumStringType h;
        protected ValueTypeEnumStringType i;
        protected ValueTypeEnumStringType j;
        protected ValueTypeEnumStringType k;
        protected ValueTypeEnumStringType l;
        protected ValueTypeEnumStringType m;
        protected ValueTypeEnumStringType n;
        protected ValueTypeEnumStringType o;
        protected ValueTypeEnumStringType p;
        protected ValueTypeEnumStringType q;
        protected ValueTypeEnumStringType r;
        protected ValueTypeEnumStringType s;
        protected ValueTypeEnumStringType t;
        protected ValueTypeEnumStringType u;
        protected ValueTypeEnumStringType v;
        protected ValueTypeEnumStringType w;
        protected ValueTypeEnumStringType x;
        protected ValueTypeEnumStringType y;
        protected ValueTypeEnumStringType z;

        /**
         * Gets the value of the a property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getA()
        {
            return a;
        }

        /**
         * Sets the value of the a property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setA(final ValueTypeEnumStringType value)
        {
            this.a = value;
        }

        /**
         * Gets the value of the b property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getB()
        {
            return b;
        }

        /**
         * Sets the value of the b property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setB(final ValueTypeEnumStringType value)
        {
            this.b = value;
        }

        /**
         * Gets the value of the c property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getC()
        {
            return c;
        }

        /**
         * Sets the value of the c property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setC(final ValueTypeEnumStringType value)
        {
            this.c = value;
        }

        /**
         * Gets the value of the d property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getD()
        {
            return d;
        }

        /**
         * Sets the value of the d property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setD(final ValueTypeEnumStringType value)
        {
            this.d = value;
        }

        /**
         * Gets the value of the e property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getE()
        {
            return e;
        }

        /**
         * Sets the value of the e property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setE(final ValueTypeEnumStringType value)
        {
            this.e = value;
        }

        /**
         * Gets the value of the f property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getF()
        {
            return f;
        }

        /**
         * Sets the value of the f property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setF(final ValueTypeEnumStringType value)
        {
            this.f = value;
        }

        /**
         * Gets the value of the g property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getG()
        {
            return g;
        }

        /**
         * Sets the value of the g property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setG(final ValueTypeEnumStringType value)
        {
            this.g = value;
        }

        /**
         * Gets the value of the h property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getH()
        {
            return h;
        }

        /**
         * Sets the value of the h property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setH(final ValueTypeEnumStringType value)
        {
            this.h = value;
        }

        /**
         * Gets the value of the i property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getI()
        {
            return i;
        }

        /**
         * Sets the value of the i property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setI(final ValueTypeEnumStringType value)
        {
            this.i = value;
        }

        /**
         * Gets the value of the j property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getJ()
        {
            return j;
        }

        /**
         * Sets the value of the j property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setJ(final ValueTypeEnumStringType value)
        {
            this.j = value;
        }

        /**
         * Gets the value of the k property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getK()
        {
            return k;
        }

        /**
         * Sets the value of the k property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setK(final ValueTypeEnumStringType value)
        {
            this.k = value;
        }

        /**
         * Gets the value of the l property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getL()
        {
            return l;
        }

        /**
         * Sets the value of the l property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setL(final ValueTypeEnumStringType value)
        {
            this.l = value;
        }

        /**
         * Gets the value of the m property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getM()
        {
            return m;
        }

        /**
         * Sets the value of the m property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setM(final ValueTypeEnumStringType value)
        {
            this.m = value;
        }

        /**
         * Gets the value of the n property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getN()
        {
            return n;
        }

        /**
         * Sets the value of the n property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setN(final ValueTypeEnumStringType value)
        {
            this.n = value;
        }

        /**
         * Gets the value of the o property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getO()
        {
            return o;
        }

        /**
         * Sets the value of the o property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setO(final ValueTypeEnumStringType value)
        {
            this.o = value;
        }

        /**
         * Gets the value of the p property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getP()
        {
            return p;
        }

        /**
         * Sets the value of the p property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setP(final ValueTypeEnumStringType value)
        {
            this.p = value;
        }

        /**
         * Gets the value of the q property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getQ()
        {
            return q;
        }

        /**
         * Sets the value of the q property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setQ(final ValueTypeEnumStringType value)
        {
            this.q = value;
        }

        /**
         * Gets the value of the r property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getR()
        {
            return r;
        }

        /**
         * Sets the value of the r property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setR(final ValueTypeEnumStringType value)
        {
            this.r = value;
        }

        /**
         * Gets the value of the s property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getS()
        {
            return s;
        }

        /**
         * Sets the value of the s property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setS(final ValueTypeEnumStringType value)
        {
            this.s = value;
        }

        /**
         * Gets the value of the t property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getT()
        {
            return t;
        }

        /**
         * Sets the value of the t property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setT(final ValueTypeEnumStringType value)
        {
            this.t = value;
        }

        /**
         * Gets the value of the u property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getU()
        {
            return u;
        }

        /**
         * Sets the value of the u property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setU(final ValueTypeEnumStringType value)
        {
            this.u = value;
        }

        /**
         * Gets the value of the v property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getV()
        {
            return v;
        }

        /**
         * Sets the value of the v property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setV(final ValueTypeEnumStringType value)
        {
            this.v = value;
        }

        /**
         * Gets the value of the w property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getW()
        {
            return w;
        }

        /**
         * Sets the value of the w property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setW(final ValueTypeEnumStringType value)
        {
            this.w = value;
        }

        /**
         * Gets the value of the x property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getX()
        {
            return x;
        }

        /**
         * Sets the value of the x property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setX(final ValueTypeEnumStringType value)
        {
            this.x = value;
        }

        /**
         * Gets the value of the y property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getY()
        {
            return y;
        }

        /**
         * Sets the value of the y property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setY(final ValueTypeEnumStringType value)
        {
            this.y = value;
        }

        /**
         * Gets the value of the z property.
         * 
         * @return possible object is {@link ValueTypeEnumStringType }
         */
        public ValueTypeEnumStringType getZ()
        {
            return z;
        }

        /**
         * Sets the value of the z property.
         * 
         * @param value allowed object is {@link ValueTypeEnumStringType }
         */
        public void setZ(final ValueTypeEnumStringType value)
        {
            this.z = value;
        }

    }

    /**
     * **************************************************************
     * 
     * @author camachof
     */
    public enum ValueTypeEnumStringType
    {
        BOOLEAN("boolean"), INT("int"), FLOAT("float"), DOUBLE("double"), STRING("string");
        private final String value;

        ValueTypeEnumStringType(final String v)
        {
            value = v;
        }

        public String value()
        {
            return value;
        }

        public static ValueTypeEnumStringType fromValue(final String v)
        {
            for(final ValueTypeEnumStringType c: ValueTypeEnumStringType.values())
            {
                if(c.value.equals(v))
                {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
