package ohd.hseb.util.fews;

import ohd.hseb.measurement.MeasuringUnitType;

public enum RUNOFF_DATATYPE
{
    INFW(DataType.NWSRFS_CHANNEL_INFLOW_DATATYPE), //NWSRFS uses "INFW" as runoff
    TCI(DataType.CHANNEL_INFLOW_DATATYPE), //FEWS uses "TCI" as runoff
    GOUT(DataType.GOUT_DATATYPE), //
    GWRO(DataType.GWRO_DATATYPE), //
    SURO(DataType.SURO_DATATYPE);

    final private String _type; //will not be changed

    private RUNOFF_DATATYPE(final String type)
    {
        _type = type;
    }

    public String getTypeName()
    {
        return _type;
    }

    /**
     * Check if it is runoff type based on timeseries type(first), then based on unit type(if it is length type), so if
     * the ts type is not explicitly listed as one of the enum types, it could still be considered to be runoff type.
     */
    public static boolean isRunOffType(final String tsTypeStr) throws Exception
    {
        //check if the TS type is one of the enum types
        for(final RUNOFF_DATATYPE type: values())
        {
            if(type.getTypeName().equalsIgnoreCase(tsTypeStr))
            {
                return true;
            }
        }

        //check if its unit type is length: if so, it is runoff type since there are too many runoff types to be listed as enum types
        final String dim = NwsrfsDataTypeMappingReader.getNwsrfsDim(tsTypeStr, OHDConstants.DUMMY_LOG);

        if(dim.equalsIgnoreCase(MeasuringUnitType.length.toString()))
        {
            return true;
        }

        //if reach here, must be false
        return false;
    }

}
