package ohd.hseb.util.fews;

import java.util.Comparator;

  /**
 * This class sort string and integer combination separated by a prompt sign '#',
 * with format string#integer. 
 * Compare the string argument0 with argument1
 * If the string arguments are not in that format, then just do regular string
 * comparison.
 * @author <a href="mailto:Raymond.Chui@noaa.gov">Raymond.Chui@noaa.gov</a>
 * Created: Octorber, 2008
 * @version FEWS/CHPS 1.0
 * @see Comparator
 * @since OB 9.0
 */
public class StringIntegerComparator implements Comparator<String>
{
	private boolean _isCompareIntegerOnly = true;
	
	public StringIntegerComparator(boolean isCompareIntegerOnly)
	{
		setIsCompareIntegerOnly(isCompareIntegerOnly);
	}
	
	public void setIsCompareIntegerOnly(boolean isCompareIntegerOnly)
	{
		_isCompareIntegerOnly = isCompareIntegerOnly;
	}
	public boolean getIsCompareIntegerOnly()
	{
		return _isCompareIntegerOnly;
	}
	public int compare(String arg0, String arg1) {
		int returnValue = 0;
		if (arg0.contains("#") && arg1.contains("#"))
		{ // do special comparison
			// split into two string arrays
			String[] theName0 = arg0.split("#");
			String[] theName1 = arg1.split("#");
		
			int theDiff = 0;
			int int0 = 0;
			int int1 = 0;
			try {
			    int0 = Integer.parseInt(theName0[1]);
			    int1 = Integer.parseInt(theName1[1]);
			} catch (NumberFormatException nfe)
			{
				int0 = 0;
				int1 = 0;
			}
		    
		    // compare the integer int0 with int1
			// if int0 < int1 return -1; if int0 >= int1 return 1
			if (int0 == int1)
			{
				theDiff = 0;
				returnValue = 1;
			}
			else if (int0 < int1)
			{
				theDiff = -1;
				returnValue = -1;
			}
			else if (int0 > int1)
			{
				theDiff = 1;
				returnValue = 1;
			}
			// if only compare the integer parts, then return the difference in here
			if (getIsCompareIntegerOnly())
				return returnValue;
			
			returnValue = 0; // reset the return value to zero
			// Otherwise need to compare both string parts and integer parts
			// compare the string arg0 with arg1
			int compareValue = theName0[0].compareTo(theName1[0]);
		    
			// when string0 = string1, then compare the integer0 with integer1
			if (compareValue == 0 && theDiff == 0)
				returnValue = 0;
			else if (compareValue == 0 && theDiff > 0)
				returnValue = 1;
			else if (compareValue == 0 && theDiff < 0)
				returnValue = -1;
			// when string0 > string1, then return 1
			else if (compareValue > 0 && theDiff == 0)
				returnValue = 1;
			else if (compareValue > 0 && theDiff > 0)
				returnValue = 1;
			else if (compareValue > 0 && theDiff < 0)
				returnValue = 1;
			// when string0 < string1, then return -1
			else if (compareValue < 0 && theDiff == 0)
				returnValue = -1;
			else if (compareValue < 0 && theDiff > 0)
				returnValue = -1;
			else if (compareValue < 0 && theDiff < 0)
				returnValue = -1;
		}
		else // do regular string comparison if is not in the string#integer format
			returnValue = arg0.compareTo(arg1);
		
		return returnValue;
	} // end method
} // end class