package ohd.hseb.util.fews;

import ohd.hseb.measurement.Measurement;
import ohd.hseb.measurement.MeasuringUnit;

public class TimeSeriesThreshold
{

    private String _id;
    private String _name;
    private final Measurement _measurement;

    public TimeSeriesThreshold(final MeasuringUnit unit)
    {
        _measurement = new Measurement(OHDConstants.MISSING_DATA, unit);
    }

    /**
     * Gets the value of the id property.
     * 
     * @return possible object is {@link String }
     */
    public String getId()
    {
        return _id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setId(final String value)
    {
        this._id = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return possible object is {@link String }
     */
    public String getName()
    {
        return _name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setName(final String value)
    {
        this._name = value;
    }

    /**
     * Gets the threshold value in the unit passed in.
     */
    public double getValue(final MeasuringUnit unit)
    {
        return _measurement.getValue(unit);
    }

    /**
     * Sets the value of the value property.
     */
    public void setValue(final float value)
    {
        _measurement.setValue(value);
    }

    /**
     * Return a String with the format: id:xxx name:xxx value:xxx
     */
    @Override
    public String toString()
    {
        final StringBuilder result = new StringBuilder();

        result.append("id:")
              .append(this._id)
              .append(" name:")
              .append(this._name)
              .append(" value:")
              .append(_measurement.toString());

        return result.toString();
    }

}
