package ohd.hseb.util.fews.ohdmodels;

import java.util.ArrayList;
import java.util.HashMap;

import ohd.hseb.measurement.AbsTimeMeasurement;
import ohd.hseb.measurement.IrregularTimeSeries;
import ohd.hseb.measurement.Measurement;
import ohd.hseb.measurement.MeasuringUnit;
import ohd.hseb.measurement.RegularTimeSeries;

public class ModValues
{
    HashMap<Long, Measurement> _modValuesMap = new HashMap<Long, Measurement>();
    private String _timeseriesType;
    private String _qualifierId;
    private boolean _isEquidistant;

    @SuppressWarnings("deprecation")
    public ModValues(RegularTimeSeries regTs)
    {
        _timeseriesType = regTs.getTimeSeriesType();
        _qualifierId = regTs.getQualifierIds().get(0);
        _isEquidistant = true;

        int measureMentCount = regTs.getMeasurementCount();
        for(int index = 0; index < measureMentCount; index++)
        {
            AbsTimeMeasurement absTimeMeasurement = regTs.getAbsTimeMeasurementByIndex(index);
            _modValuesMap.put(absTimeMeasurement.getTime(), absTimeMeasurement);
        }

    }

    public ModValues(IrregularTimeSeries iRregTs)
    {
        _timeseriesType = iRregTs.getTimeSeriesType();
        _qualifierId = iRregTs.getQualifierId();
        _isEquidistant = false;

        int measureMentCount = iRregTs.getMeasurementCount();
        for(int index = 0; index < measureMentCount; index++)
        {
            AbsTimeMeasurement absTimeMeasurement = iRregTs.getAbsTimeMeasurementByIndex(index);
            _modValuesMap.put(absTimeMeasurement.getTime(), absTimeMeasurement);
        }

    }

    /*
     * create a ModValues object from a list of longs and list of measurments; it is assumed the lists are ordered from
     * earliest to latest
     */

    public ModValues(ArrayList<Long> timeList, ArrayList<Measurement> measurementList) throws Exception
    {
        // make sure == number of values in each List
        if(timeList.size() != measurementList.size())
        {
            throw new Exception("Unable to create a ModValues object, the number of values in timeList and valuesList do not match");
        }

        for(int i = 0; i < timeList.size(); i++)
        {
            _modValuesMap.put(timeList.get(i), measurementList.get(i));
        }

    }

    public HashMap<Long, Measurement> getModValuesMap()
    {
        return _modValuesMap;
    }

    public Measurement getMeasurementAt(long time)
    {
        return _modValuesMap.get(time);
    }

    public Measurement getMeasurementAt(long time, MeasuringUnit newUnit)
    {
        Measurement measurement = _modValuesMap.get(time);
        measurement.convert(newUnit);
        return measurement;
    }

    public String getTimeSeriesType()
    {
        return _timeseriesType;
    }

    public void setTimeSeriesType(String type)
    {
        _timeseriesType = type;
    }

    public String getQualifierId()
    {
        return _qualifierId;
    }

    public void setQualifierId(String id)
    {
        _qualifierId = id;
    }

    public boolean getIsEquidistant()
    {
        return _isEquidistant;
    }

    public void setIsEquidistant(boolean isEquidistant)
    {
        _isEquidistant = isEquidistant;
    }
}
