package ohd.hseb.util.fews.ohdmodels;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

import ohd.hseb.util.fews.State;

public class ModelState extends State
{

    public ModelState()
    {
        super();
    }

    /**
     * Construct a different hash map
     * 
     * @param whichMap -- which hash map is going to create
     */
    public ModelState(final int whichMap)
    {
        Map<String, Object> map;

        switch(whichMap)
        {
            case State.HASHMAP:
            default:
                map = new HashMap<String, Object>();
                break;
            case State.TREEMAP:
                map = new TreeMap<String, Object>();
                break;
            case State.LINKEDHASHMAP:
                map = new LinkedHashMap<String, Object>();
                break;
            case State.IDENTITYHASHMAP:
                map = new IdentityHashMap<String, Object>();
                break;
            case State.WEAKHASHMAP:
                map = new WeakHashMap<String, Object>();
                break;
        }

        setStatesMap(map);

    } //close constructor

    /**
     * method to be implemented by each model
     */
    public void doCarryOverTransfer(final ModelParameters savedParams, final ModelParameters params) throws Exception
    {
        //methods content must be implemented by each model
    }

}
