package ohd.hseb.charter;

import org.jfree.chart.axis.Axis;

import ohd.hseb.charter.parameters.AxisParameters;
import ohd.hseb.charter.parameters.ChartDrawingParameters;
import ohd.hseb.charter.parameters.ChartParametersException;
import ohd.hseb.hefs.utils.arguments.ArgumentsProcessor;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInParameters;

/**
 * Any component within {@link ChartDrawingParameters} must implement this interface.
 * 
 * @author herrhd
 */
public interface ChartParameters extends GeneralPlugInParameters
{
    /**
     * Call this method to give it another set of {@link ChartParameters} that supplies override parameter values.
     * {@link ChartParameters} allow for null parameter settings, which means the user wants to use some kind of
     * default, usually provided by a default {@link ChartParameters} object. For non-null parameters the override value
     * is used instead of the default. This method allows for copying override parameters into this
     * {@link ChartParameters} object, overriding what is in this if the override is non-null.
     * 
     * @param override
     */
    public void copyOverriddenParameters(ChartParameters override);

    /**
     * The object passed in depends on the implementing class. It should make sure the object is valid and then apply
     * the parameters to the object. For example, an {@link AxisParameters} object may be given a JFreeChart
     * {@link Axis}.
     * 
     * @param objectAppliedTo
     */
    public void applyParametersToChart(Object objectAppliedTo) throws ChartParametersException;

    /**
     * Runs without exception if all null-possible parameters are non-null. This is called for the charting parameters
     * before a plot is generated but after the override parameters are applied.
     * 
     * @throws ChartParametersException If any parameter which can be null is null.
     */
    public void haveAllParametersBeenSet() throws ChartParametersException;

    /**
     * Set the values for this parameter object to some reasonable default. What is reasonable depends on the subclass
     * and some parameters may not be reset by this method (those that should not be changed arbitrarily). After
     * calling, the object should be ready to use in plotting a chart (i.e. {@link #haveAllParametersBeenSet()} will not
     * throw an exception).
     */
    public void setupDefaultParameters();

    /**
     * Clears all parameters by setting null-possible parameters to null and calling {@link #clearParameters()} for any
     * nested parameters.
     */
    public void clearParameters();

    /**
     * Sets the arguments to the parameters object. Some types of parameters may need to make use of this object to
     * perform string substitutions or get the the system time, for example.
     */
    public void setArguments(ArgumentsProcessor arguments);

    /**
     * @return The arguments used by this {@link ChartParameters} object to make substitutions.
     */
    public ArgumentsProcessor getArguments();
}
