package ohd.hseb.charter;

import ohd.hseb.hefs.utils.arguments.ArgumentsProcessor;
import ohd.hseb.hefs.utils.arguments.DefaultArgumentsProcessor;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInParameters;
import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLWriter;

/**
 * Abstract implementation of {@link ChartParameters}.
 * 
 * @author Hank.Herr
 */
public abstract class DefaultChartParameters implements ChartParameters
{

    /**
     * The tag name.
     */
    private String _xmlTagName = null;

    /**
     * A tracker for the status of the last attempt to use. Will be false if a failure occurred.
     */
    private boolean _statusOfLastAttemptUse = true;

    /**
     * The {@link ArgumentsProcessor} set through by {@link #setArguments(ArgumentsProcessor)}.
     */
    private ArgumentsProcessor _arguments = DefaultArgumentsProcessor.createEmpty();

    @Override
    public void setStatusOfLastAttemptToUseParameters(final Boolean b)
    {
        this._statusOfLastAttemptUse = b;
    }

    @Override
    public Boolean getStatusOfLastAttemptToUseParameters()
    {
        return this._statusOfLastAttemptUse;
    }

    @Override
    public String getXMLTagName()
    {
        return _xmlTagName;
    }

    @Override
    public void setXMLTagName(final String name)
    {
        _xmlTagName = name;
    }

    @Override
    public abstract Object clone() throws CloneNotSupportedException;

    @Override
    public void setArguments(final ArgumentsProcessor arguments)
    {
        _arguments = arguments;
    }

    @Override
    public ArgumentsProcessor getArguments()
    {
        return _arguments;
    }

    @Override
    public void copyFrom(final GeneralPlugInParameters parameters)
    {
        if(parameters instanceof ChartParameters)
        {
            _arguments = ((ChartParameters)parameters).getArguments();
        }
    }

    @Override
    public void argumentsChanged()
    {
    }

    @Override
    public XMLReader getReader()
    {
        return this;
    }

    @Override
    public XMLWriter getWriter()
    {
        return this;
    }
}
