package ohd.hseb.charter;

import ohd.hseb.charter.plotter.XYChartPlotterException;

import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;

public abstract class JFreeChartTools
{

    public static XYDataset createCopyOfDataSet(XYPlot plot, int datasetIndex) throws XYChartPlotterException
    {
        try
        {
            if(plot.getDataset(datasetIndex) instanceof TimeSeriesCollection)
            {
                TimeSeriesCollection base = (TimeSeriesCollection)plot.getDataset(datasetIndex);
                TimeSeriesCollection newSet = new TimeSeriesCollection();
                for(int i = 0; i < base.getSeriesCount(); i++)
                {
                    newSet.addSeries(base.getSeries(i));
                }
                return newSet;

            }
            else if(plot.getDataset(datasetIndex) instanceof XYSeriesCollection)
            {
                return (XYSeriesCollection)((XYSeriesCollection)plot.getDataset(datasetIndex)).clone();
            }
        }
        catch(CloneNotSupportedException e)
        {
            //Shouldn't happen
        }
        throw new XYChartPlotterException("XYDataset type unrecognized; cannot make a copy.");
    }
}
