package ohd.hseb.charter.datasource;

import ohd.hseb.charter.parameters.DataSourceDrawingParameters;

/**
 * Anything that can generate an {@link XYChartDataSource} must implement this interface. That does not mean the methods
 * of the interface need to include meaningful code. Presently, this is called back in order to create an output string
 * via {@link #generateOutputString(XYChartDataSource, DataSourceDrawingParameters)}.
 * 
 * @author hank.herr
 */
public interface DataSourceGenerator
{

    /**
     * Output the data in the passed in source, presumably generated by this generator, to a {@link String} appropriate
     * for text output. Its up to the implementer to determine the format of that string.
     * 
     * @param calculatedSource The source that was calculated by this calculator.
     * @param drawingParms The drawing parameters used to plot the data.
     * @return StringBuffer containing the output.
     */
    public StringBuffer generateOutputString(XYChartDataSource calculatedSource,
                                             DataSourceDrawingParameters drawingParms);

    /**
     * @return A descriptive name for the plug-in, which may be used in menus within the GUI in the future.
     */
    public String getDescriptiveName();
}
