package ohd.hseb.charter.jfreechartoverride;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.XYPlot;

@SuppressWarnings("serial")
public class ExtendedCombinedDomainXYPlot extends CombinedDomainXYPlot
{

    /**
     * Wrapper constructor on {@link CombinedDomainXYPlot#CombinedDomainXYPlot()}
     */
    public ExtendedCombinedDomainXYPlot()
    {
        super();
    }

    /**
     * Wrapper constructor on {@link CombinedDomainXYPlot#CombinedDomainXYPlot(ValueAxis)}
     */
    public ExtendedCombinedDomainXYPlot(final ValueAxis domainAxis)
    {
        super(domainAxis);
    }

    /**
     * This has been overridden so that, for all subplots, the fixedRangeAxisSpace attributes are cleared out before
     * calculating the axis space. Otherwise, the computed space may be a memory of a previous computed space, which may
     * not be reasonable to use if the numbers displayed along the axis change.
     */
    @Override
    protected AxisSpace calculateAxisSpace(final Graphics2D g2, final Rectangle2D plotArea)
    {
        for(int i = 0; i < getSubplots().size(); i++)
        {
            ((XYPlot)getSubplots().get(i)).setFixedRangeAxisSpace(null);
            ((XYPlot)getSubplots().get(i)).setFixedDomainAxisSpace(null);
        }

        return super.calculateAxisSpace(g2, plotArea);
    }
}
