package ohd.hseb.charter.jfreechartoverride;

import java.awt.Insets;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.Zoomable;

public class FixedChartPanel extends ChartPanel
{
    private static final long serialVersionUID = 1L;
    private boolean domainZoomable;
    private boolean rangeZoomable;

    public FixedChartPanel(JFreeChart chart)
    {
        super(chart);
    }

    public FixedChartPanel(JFreeChart chart,
                           boolean properties,
                           boolean save,
                           boolean print,
                           boolean zoom,
                           boolean tooltips)
    {
        super(chart, properties, save, print, zoom, tooltips);
    }

    public FixedChartPanel(JFreeChart chart, boolean useBuffer)
    {
        super(chart, useBuffer);
    }

    public FixedChartPanel(JFreeChart chart,
                           int width,
                           int height,
                           int minimumDrawWidth,
                           int minimumDrawHeight,
                           int maximumDrawWidth,
                           int maximumDrawHeight,
                           boolean useBuffer,
                           boolean properties,
                           boolean save,
                           boolean print,
                           boolean zoom,
                           boolean tooltips)
    {
        super(chart,
              width,
              height,
              minimumDrawWidth,
              minimumDrawHeight,
              maximumDrawWidth,
              maximumDrawHeight,
              useBuffer,
              properties,
              save,
              print,
              zoom,
              tooltips);
    }

    /**
     * Zooms in on a selected region.
     * 
     * @param selection the selected region.
     */
    @Override
    public void zoom(Rectangle2D selection)
    {
        Point2D unscaledZoomPoint = unscale(new Point2D.Double(selection.getX(), selection.getY()));

        Rectangle2D scaledDataArea;
        if(this.getChartRenderingInfo().getPlotInfo().getSubplotCount() == 0)
        {
            scaledDataArea = getScreenDataArea();
        }
        else
        {
            int subplotIndex = this.getChartRenderingInfo().getPlotInfo().getSubplotIndex(unscaledZoomPoint);
            if(subplotIndex == -1)
            {
                super.zoom(selection);
                return;
            }
            scaledDataArea = scale(this.getChartRenderingInfo()
                                       .getPlotInfo()
                                       .getSubplotInfo(subplotIndex)
                                       .getDataArea());
        }

        if((selection.getHeight() > 0) && (selection.getWidth() > 0))
        {

            double hLower = (selection.getMinX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            double hUpper = (selection.getMaxX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            double vLower = (scaledDataArea.getMaxY() - selection.getMaxY()) / scaledDataArea.getHeight();
            double vUpper = (scaledDataArea.getMaxY() - selection.getMinY()) / scaledDataArea.getHeight();

            Plot p = this.getChart().getPlot();
            if(p instanceof Zoomable)
            {
                Zoomable z = (Zoomable)p;
                if(z.getOrientation() == PlotOrientation.HORIZONTAL)
                {
                    if(domainZoomable)
                    {
                        z.zoomDomainAxes(vLower, vUpper, this.getChartRenderingInfo().getPlotInfo(), unscaledZoomPoint);
                    }
                    if(rangeZoomable)
                        z.zoomRangeAxes(hLower, hUpper, this.getChartRenderingInfo().getPlotInfo(), unscaledZoomPoint);
                }
                else
                {
                    if(domainZoomable)
                    {
                        z.zoomDomainAxes(hLower, hUpper, this.getChartRenderingInfo().getPlotInfo(), unscaledZoomPoint);
                    }
                    if(rangeZoomable)
                    {
                        z.zoomRangeAxes(vLower, vUpper, this.getChartRenderingInfo().getPlotInfo(), unscaledZoomPoint);
                    }
                }
            }

        }

    }

    private Point2D unscale(Point2D point)
    {
        double x = (point.getX() - getInsets().left) / this.getScaleX();
        double y = (point.getY() - getInsets().top) / this.getScaleY();
        return new Point2D.Double(x, y);
    }

    @Override
    public Rectangle2D scale(Rectangle2D dataArea)
    {
        Insets insets = getInsets();
        double x = dataArea.getX() * this.getScaleX() + insets.left;
        double y = dataArea.getY() * this.getScaleY() + insets.top;
        double w = dataArea.getWidth() * this.getScaleX();
        double h = dataArea.getHeight() * this.getScaleY();
        return new Rectangle2D.Double(x, y, w, h);
    }

    @Override
    public void setDomainZoomable(boolean flag)
    {
        if(flag)
        {
            Plot plot = this.getChart().getPlot();
            if(plot instanceof Zoomable)
            {
                Zoomable z = (Zoomable)plot;
                this.domainZoomable = z.isDomainZoomable();
            }
        }
        else
        {
            this.domainZoomable = false;
        }
        super.setDomainZoomable(flag);
    }

    @Override
    public void setRangeZoomable(boolean flag)
    {
        if(flag)
        {
            Plot plot = this.getChart().getPlot();
            if(plot instanceof Zoomable)
            {
                Zoomable z = (Zoomable)plot;
                this.rangeZoomable = z.isRangeZoomable();
            }
        }
        else
        {
            this.rangeZoomable = false;
        }
        super.setRangeZoomable(flag);
    }

}
