package ohd.hseb.charter.jfreechartoverride;

import org.jfree.chart.LegendItem;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;

/**
 * Allows for an {@link XYLineAndShapeRenderer} to be connected to the {@link XYAreaRenderer}, such that lines and
 * shapes are drawn for the points. The legend item will be determined based on the {@link XYLineAndShapeRenderer} if
 * the shape is visible. Otherwise, it will be the default for {@link XYAreaRenderer}.
 * 
 * @author herrhd
 */
public class GraphGenXYAreaRenderer extends XYAreaRenderer
{
    private static final long serialVersionUID = 1L;

    private XYLineAndShapeRenderer _connectedLineAndShapeRenderer = null;
    private int _datasetIndexOfConnectedLineAndShapeRenderer = -1;

    public void setConnectedLineAndShapeRenderer(final int datasetIndex, final XYLineAndShapeRenderer renderer)
    {
        _datasetIndexOfConnectedLineAndShapeRenderer = datasetIndex;
        this._connectedLineAndShapeRenderer = renderer;
    }

    @Override
    public LegendItem getLegendItem(final int datasetIndex, final int series)
    {
        if(_connectedLineAndShapeRenderer != null)
        {
            if(_connectedLineAndShapeRenderer.getSeriesShapesVisible(series))
            {
                return _connectedLineAndShapeRenderer.getLegendItem(_datasetIndexOfConnectedLineAndShapeRenderer,
                                                                    series);
            }
        }
        return super.getLegendItem(datasetIndex, series);
    }
}
