package ohd.hseb.charter.jfreechartoverride;

import org.jfree.chart.LegendItem;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;

/**
 * Allows for attaching a GraphGenXYStepRenderer to an XYStepAreaRenderer. The connected other renderer will be used to
 * determine legend entries if the connect series shapes are visible.
 * 
 * @author herrhd
 */
public class GraphGenXYStepAreaRenderer extends XYStepAreaRenderer
{
    private static final long serialVersionUID = 1L;

    private GraphGenXYStepRenderer _connectedStepRenderer = null;
    private int _datasetIndexOfConnectedStepRenderer = -1;

    public void setConnectedStepRenderer(int datasetIndexOfStepRenderer, GraphGenXYStepRenderer renderer)
    {
        _datasetIndexOfConnectedStepRenderer = datasetIndexOfStepRenderer;
        this._connectedStepRenderer = renderer;
    }

    @Override
    public LegendItem getLegendItem(int datasetIndex, int series)
    {
        if(_connectedStepRenderer != null)
        {
            if(_connectedStepRenderer.getSeriesShapesVisible(series))
            {
                return _connectedStepRenderer.getLegendItem(_datasetIndexOfConnectedStepRenderer, series);
            }
        }
        return super.getLegendItem(datasetIndex, series);
    }
}
