package ohd.hseb.charter.panel.notices;

import ohd.hseb.charter.ChartEngine;
import ohd.hseb.charter.panel.ChartEngineChartAndTablePanel;
import ohd.hseb.hefs.utils.notify.Notice;

import org.jfree.chart.JFreeChart;

import com.google.common.eventbus.Subscribe;

/**
 * Notice posted when the chart engine and chart has changed. This is posted by the
 * {@link ChartEngineChartAndTablePanel} whenever its
 * {@link ChartEngineChartAndTablePanel#setChartEngineAndChart(ChartEngine, JFreeChart, boolean)} is called.
 * 
 * @author hankherr
 */
public class ChangeChartEngineAndChartNotice extends Notice
{

    private final ChartEngine _chartEngine;

    public ChartEngine getChartEngine()
    {
        return _chartEngine;
    }

    public JFreeChart getChart()
    {
        return _chart;
    }

    private final JFreeChart _chart;

    public ChangeChartEngineAndChartNotice(final Object source, final ChartEngine chartEngine, final JFreeChart chart)
    {
        super(source);
        _chartEngine = chartEngine;
        _chart = chart;
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToChangedChartEngineAndChart(ChangeChartEngineAndChartNotice evt);
    }
}
