package ohd.hseb.charter.panel.notices;

import ohd.hseb.charter.datasource.XYChartDataSource;
import ohd.hseb.hefs.utils.gui.jtable.MarkedTableScrollPanel;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * This notice should/can be posted whenever a chart data point is clicked. One current use is to indicate to a
 * {@link MarkedTableScrollPanel} that the marks need to be recomputed. When to post these events is table model
 * specific.
 * 
 * @author hankherr
 */
public class ChartDataPointClickedNotice extends Notice
{
    private final XYChartDataSource _dataSource;
    private final int _chartSeriesIndex;
    private final int _chartItemIndex;

    /**
     * A clear marks notice.
     * 
     * @param source
     * @param clearRowMarks Row marks will be cleared if true. If false, column marks are cleared.
     */
    public ChartDataPointClickedNotice(final Object source,
                                       final XYChartDataSource dataSource,
                                       final int chartSeriesIndex,
                                       final int chartItemIndex)
    {
        super(source);
        _dataSource = dataSource;
        _chartSeriesIndex = chartSeriesIndex;
        _chartItemIndex = chartItemIndex;
    }

    public XYChartDataSource getDataSource()
    {
        return _dataSource;
    }

    public int getChartSeriesIndex()
    {
        return _chartSeriesIndex;
    }

    public int getChartItemIndex()
    {
        return _chartItemIndex;
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToChartEntityClicked(ChartDataPointClickedNotice evt);
    }

}
