package ohd.hseb.charter.panel.notices;

import java.util.Date;

import ohd.hseb.charter.panel.ChartEngineTable;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * Posted by an {@link ChartEngineTable} after receiving a {@link GeneralTableCellSelectedNotice}. If nothing is
 * selected, the indices will be -1 and the values will be null. If a row is selected, then {@link #_seriesIndex} will
 * be -1 and the values will be null, while {@link #_dataSourceIndex} reflects the data source currently displayed in
 * the table. If a column is selected, then the indices will post be non-negative specifying the displayed data source
 * and the series corresponding to the selected column, but the values will be null. If a cell is selected, then the two
 * indices will be specified and the raw domain and range values, either {@link Date} or a {@link Number} of some kind
 * corresponding to that cell will be provided.
 * 
 * @author hankherr
 */
public class ChartEngineTableCellSelectedNotice extends Notice
{

    private final int _dataSourceIndex;
    private final int _seriesIndex;
    private final Object _rawDomainValue;
    private final Object _rawRangeValue;

    public ChartEngineTableCellSelectedNotice(final Object source)
    {
        super(source);
        _dataSourceIndex = -1;
        _seriesIndex = -1;
        _rawDomainValue = null;
        _rawRangeValue = null;
    }

    public ChartEngineTableCellSelectedNotice(final Object source,
                                              final int dataSourceIndex,
                                              final int seriesIndex,
                                              final Object rawDomainValue,
                                              final Object rawRangeValue)
    {
        super(source);
        _dataSourceIndex = dataSourceIndex;
        _seriesIndex = seriesIndex;
        _rawDomainValue = rawDomainValue;
        _rawRangeValue = rawRangeValue;
    }

    public int getDataSourceIndex()
    {
        return _dataSourceIndex;
    }

    public int getSeriesIndex()
    {
        return _seriesIndex;
    }

    public Object getRawDomainValue()
    {
        return _rawDomainValue;
    }

    public Object getRawRangeValue()
    {
        return _rawRangeValue;
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToChartEngineTableCellSelected(ChartEngineTableCellSelectedNotice evt);
    }

}
