package ohd.hseb.charter.panel.notices;

import ohd.hseb.charter.panel.ChartEngineChartPanel;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * Notice posted whenever the visibility of the chart data table is changed. The work underlying this notice is done
 * within {@link ChartEngineChartPanel}, where it sets the state of the popup menu checkbox by causing a click to occur.
 * 
 * @author hankherr
 */
public class ChartTableVisibilityChangedNotice extends Notice
{
    private final boolean _isVisible;

    public ChartTableVisibilityChangedNotice(final Object source, final boolean isVisible)
    {
        super(source);
        _isVisible = isVisible;
    }

    public boolean isVisible()
    {
        return _isVisible;
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToChartTableVisibilityChangedNotice(ChartTableVisibilityChangedNotice evt);
    }
}
