package ohd.hseb.charter.panel.notices;

import ohd.hseb.charter.panel.ChartEngineChartAndTablePanel;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * Notice fired indicating that the data table should be detached from a {@link ChartEngineChartAndTablePanel}.
 * 
 * @author hankherr
 */
public class DetachDataTableNotice extends Notice
{

    public DetachDataTableNotice(final Object source)
    {
        super(source);
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToDetachDataTable(DetachDataTableNotice evt);
    }
}
