package ohd.hseb.charter.panel.notices;

import ohd.hseb.hefs.utils.gui.jtable.EventPostingCellSelectableTable;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * Notice is posted by an {@link EventPostingCellSelectableTable}. If {@link #_modelRow} is -1 and {@link #_modelCol} is
 * -1, then the table selection was cleared. If {@link #_modelRow} is -1 but not {@link #_modelCol}, then a column was
 * selected, but not one cell. If {@link #_modelCol} is -1 and {@link #_modelRow} is not, then a row was selected. In
 * either case, {@link #_cellValue} will be null. If one cell was selected, then neither {@link #_modelRow} nor
 * {@link #_modelCol} will be negative and {@link #_cellValue} will be whatever is returned by the model for that cell.<br>
 * <br>
 * Both the row and col must be converted to the model value before posting.
 * 
 * @author hankherr
 */
public class GeneralTableCellSelectedNotice extends Notice
{

    private final int _modelRow;
    private final int _modelCol;
    private final Object _cellValue;

    public GeneralTableCellSelectedNotice(final Object source)
    {
        super(source);
        _modelRow = -1;
        _modelCol = -1;
        _cellValue = null;
    }

    /**
     * Be sure to convert the row and col to model values before posting.
     */
    public GeneralTableCellSelectedNotice(final Object source,
                                          final int modelRow,
                                          final int modelCol,
                                          final Object cellValue)
    {
        super(source);
        _modelRow = modelRow;
        _modelCol = modelCol;
        _cellValue = cellValue;
    }

    public int getModelRow()
    {
        return _modelRow;
    }

    public int getModelCol()
    {
        return _modelCol;
    }

    public Object getCellValue()
    {
        return _cellValue;
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToTableCellSelection(GeneralTableCellSelectedNotice evt);
    }
}
