package ohd.hseb.charter.panel.notices;

import ohd.hseb.charter.ChartTools;
import ohd.hseb.hefs.utils.notify.Notice;
import ohd.hseb.util.data.DataPoint;

import org.jfree.chart.JFreeChart;

import com.google.common.eventbus.Subscribe;

public class NavigatedSubplotAxisLimitsChangedNotice extends Notice
{

    private final DataPoint _newAxesLowerBounds;
    private final DataPoint _newAxesUpperBounds;

    public NavigatedSubplotAxisLimitsChangedNotice(final Object source,
                                   final DataPoint newAxesLowerBounds,
                                   final DataPoint newAxesUpperBounds)
    {
        super(source);
        _newAxesLowerBounds = newAxesLowerBounds;
        _newAxesUpperBounds = newAxesUpperBounds;
    }

    public double getNewDomainAxisLowerBound()
    {
        return _newAxesLowerBounds.getX();
    }

    public double getNewRangeAxisLowerBound(final int axisIndex)
    {
        return _newAxesLowerBounds.getY(axisIndex);
    }

    public double getNewDomainAxisUpperBound()
    {
        return _newAxesUpperBounds.getX();
    }

    public double getNewRangeAxisUpperBound(final int axisIndex)
    {
        return _newAxesUpperBounds.getY(axisIndex);
    }

    public boolean haveAxisLimitsChanged(final JFreeChart chart)
    {
        return !ChartTools.areAxisLimitsIdentical(chart, 0, _newAxesLowerBounds, _newAxesUpperBounds);
    }

    public DataPoint getNewLowerBounds()
    {
        return _newAxesLowerBounds;
    }

    public DataPoint getNewUpperBounds()
    {
        return _newAxesUpperBounds;
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToAxisLimitsChanged(NavigatedSubplotAxisLimitsChangedNotice evt);
    }
}
