package ohd.hseb.charter.panel.notices;

import java.awt.Rectangle;

import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

public class NavigationCanvasRectangleChangedNotice extends Notice
{

    private final Rectangle _newRectangle;

    public NavigationCanvasRectangleChangedNotice(final Object source, final Rectangle newRect)
    {
        super(source);
        _newRectangle = newRect;
    }

    public Rectangle getNewRectangle()
    {
        return _newRectangle;
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToViewedRectangleChanged(NavigationCanvasRectangleChangedNotice evt);
    }
}
