package ohd.hseb.charter.panel.notices;

import ohd.hseb.hefs.utils.gui.jtable.EventPostingCellSelectableTable;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * This is posted by the {@link EventPostingCellSelectableTable} whenever a cell is control-clicked.
 * 
 * @author hankherr
 */
public class TableCellControlClickedNotice extends Notice
{

    private final int _modelRow;
    private final int _modelCol;
    private final Object _cellValue;

    public TableCellControlClickedNotice(final Object source)
    {
        super(source);
        _modelRow = -1;
        _modelCol = -1;
        _cellValue = null;
    }

    /**
     * Be sure to convert the row and col to model values before posting.
     */
    public TableCellControlClickedNotice(final Object source,
                                         final int modelRow,
                                         final int modelCol,
                                         final Object cellValue)
    {
        super(source);
        _modelRow = modelRow;
        _modelCol = modelCol;
        _cellValue = cellValue;
    }

    public int getModelRow()
    {
        return _modelRow;
    }

    public int getModelCol()
    {
        return _modelCol;
    }

    public Object getCellValue()
    {
        return _cellValue;
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToTableCellControlClicked(TableCellControlClickedNotice evt);
    }
}
