package ohd.hseb.charter.panel.notices;

import ohd.hseb.charter.parameters.ThresholdParameters;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

public class ThresholdClickedNotice extends Notice
{
    private final ThresholdParameters _thresholdParameters;

    /**
     * A clear marks notice.
     * 
     * @param source
     * @param clearRowMarks Row marks will be cleared if true. If false, column marks are cleared.
     */
    public ThresholdClickedNotice(final Object source, final ThresholdParameters thresholdParameters)
    {
        super(source);
        _thresholdParameters = thresholdParameters;
    }

    public ThresholdParameters getThresholdParameters()
    {
        return _thresholdParameters;
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToThresholdClicked(ThresholdClickedNotice evt);
    }

}
