package ohd.hseb.charter.parameters.panels;

import ohd.hseb.charter.ChartEngine;

/**
 * All ChartParametersPanels implement this listener, whose method is called whenever the ChartEngine is reconstructed
 * resulting from changes to the parameters. A subclass of ChartParametersPanel can listen to this method for that event
 * and react accordingly.
 * 
 * @author herrhd
 */
public interface ChartEngineReconstructedListener
{

    /**
     * Called when the ChartEngine resulting from these parameters is reconstructed.
     * 
     * @param engine The new engine.
     */
    public void chartEngineReconstructed(ChartEngine engine);
}
