package ohd.hseb.charter.parameters.panels;

import javax.swing.ScrollPaneConstants;

import ohd.hseb.charter.ChartEngine;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInPanel;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInParameters;

public abstract class ChartParametersPanel extends GeneralPlugInPanel implements ChartEngineReconstructedListener
{
    private static final long serialVersionUID = 1L;

    private GeneralPlugInParameters _defaultParameters = null;

    private ChartEngine _mostRecentlyConstructedChartEngine = null;

    protected void setDefaultParameters(final GeneralPlugInParameters parameters)
    {
        this._defaultParameters = parameters;
    }

    protected GeneralPlugInParameters getDefaultParameters()
    {
        return this._defaultParameters;
    }

    @Override
    public void chartEngineReconstructed(final ChartEngine engine)
    {
        _mostRecentlyConstructedChartEngine = engine;
    }

    public ChartEngine getMostRecentlyConstructedChartEngine()
    {
        return this._mostRecentlyConstructedChartEngine;
    }

    /**
     * This method is called whenever a panel is selected for editing. It must make sure the GUI displays the parameters
     * correctly.
     */
    public abstract void makePanelReflectParameters();

    /**
     * This method is called whenever the AppearanceModifierPanel is left or the tree selection is changed so that this
     * panel is no longer being edited.
     */
    public void cleanUpManagedParameters()
    {
    }

    /**
     * This is useful to override if the panel, itself, has an embedded scrollpane, so you don't want the container
     * panel to have one as well.
     * 
     * @return {@link ScrollPaneConstants#VERTICAL_SCROLLBAR_ALWAYS},
     *         {@link ScrollPaneConstants#VERTICAL_SCROLLBAR_AS_NEEDED}, or
     *         {@link ScrollPaneConstants#VERTICAL_SCROLLBAR_NEVER} as needed for the panel. By default this returns
     *         {@link ScrollPaneConstants#VERTICAL_SCROLLBAR_AS_NEEDED}.
     */
    public int getVerticalScrollBarPolicy()
    {
        return ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED;
    }

    /**
     * See {@link #getVerticalScrollBarPolicy()}; same idea, but for the horizontal axis.
     */
    public int getHorizontalScrollBarPolicy()
    {
        return ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED;
    }
}
