package ohd.hseb.charter.parameters.panels;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import ohd.hseb.charter.parameters.DateAxisParameters;
import ohd.hseb.charter.tools.DateAxisPlus;
import ohd.hseb.hefs.utils.arguments.ArgumentsProcessor;
import ohd.hseb.hefs.utils.arguments.DefaultArgumentsProcessor;
import ohd.hseb.hefs.utils.datetime.DateComboGenericParameterPanel;
import ohd.hseb.hefs.utils.datetime.HEFSDateTools;
import ohd.hseb.hefs.utils.gui.components.BufferJPanel;
import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInPanelListener;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInParameters;
import ohd.hseb.hefs.utils.plugins.GenericParameterList;

import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;

public class DateAxisParametersPanel extends ChartParametersPanel implements FocusListener, ChangeListener,
GeneralPlugInPanelListener, ItemListener, ActionListener
{
    private static final long serialVersionUID = -1362053619948762289L;

    public static final String[] UNIT_ARRAY = new String[]{"years", "months", "weeks", "days", "hours"};

    protected ArgumentsProcessor _argumentsProcessor = null;
    protected ValueAxis _currentAxis = null;

    protected JPanel _axisBoundEditPanel = null;
    private JComboBox _autoRangeChoices;
    protected JRadioButton _defaultAxisBoundsRadioButton = new JRadioButton("Default", true);
    protected JRadioButton _selectedAxisBoundsRadioButton = new JRadioButton("User Specified");
    private DateComboGenericParameterPanel _lowerBoundDateComboPanel = null;
    private DateComboGenericParameterPanel _upperBoundDateComboPanel = null;

    protected JPanel _tickSpacingEditPanel = null;
    protected JRadioButton _defaultTickSpacingRadioButton = new JRadioButton("Default", true);
    protected JRadioButton _selectedTickSpacingRadioButton = new JRadioButton("User Specified");
    private final JCheckBox _autoTickSpacingBox = HSwingFactory.createJCheckBox("Auto", null, true);
    private final JSpinner _tickSpacingQuantitySpinner = HSwingFactory.createJSpinner(null, 3, 1, 1, null, 1);
    private final JComboBox _tickSpacingUnitComboBox = HSwingFactory.createJComboBox(UNIT_ARRAY, null);
    private final JLabel _unitSpacingLabel = new JLabel("Tick Spacing:");

    private final JRadioButton _defaultTickFormatRadioButton = new JRadioButton("Default", true);
    private final JRadioButton _selectedTickFormatRadioButton = new JRadioButton("User Specified", true);
    private JTextArea _dateFormatTextArea = null;

    private final JRadioButton _defaultTickStartHourRadioButton = new JRadioButton("Default", true);
    private final JRadioButton _selectedTickStartHourRadioButton = new JRadioButton("User Specified", true);
    private JSpinner _dateTickStartHourSpinner = null;

    public DateAxisParametersPanel(DateAxisParameters managedParameters,
                                   DateAxisParameters defaultParameters,
                                   DefaultArgumentsProcessor argumentsProcessor)
    {
        setArgumentsProcessor(argumentsProcessor);
        setManagedParameters(managedParameters);
        setDefaultParameters(defaultParameters);
        createDisplay();
        makePanelReflectParameters();
    }

    private void createDisplay()
    {
        _autoRangeChoices = HSwingFactory.createJComboBox(this.determineAutoRangeChoices(), null);
        setupAxisBoundEditingPanel();
        setupTickSpacingEditPanel();

        GridBagConstraints constraints;
        this.setLayout(new GridBagLayout());
        int gridy = 0;
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          gridy,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        this.add(_axisBoundEditPanel, constraints);
        gridy++;
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          gridy,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        this.add(_tickSpacingEditPanel, constraints);
        gridy++;
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          gridy,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        this.add(setupTickFormatPanel(), constraints);
        gridy++;
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          gridy,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        this.add(setupTickStartHourPanel(), constraints);
    }

    /**
     * Build Date Axis lower/upper bound Panel
     */
    private JPanel setupAxisBoundDateEditPanel()
    {
        createDateComboPanels();
        JPanel axisBoundDatePanel = new JPanel(new GridBagLayout());

        GridBagConstraints constraints = null;
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          0,
                                                          1,
                                                          1,
                                                          0,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        axisBoundDatePanel.add(new JLabel("Lower Bound:"), constraints);
        constraints = SwingTools.returnGridBagConstraints(1,
                                                          0,
                                                          1,
                                                          1,
                                                          0,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        axisBoundDatePanel.add(_lowerBoundDateComboPanel.getEditingDisplayPanel(), constraints);
        constraints = SwingTools.returnGridBagConstraints(2,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        axisBoundDatePanel.add(new BufferJPanel(), constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        axisBoundDatePanel.add(new JLabel("Upper Bound:"), constraints);
        constraints = SwingTools.returnGridBagConstraints(1,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        axisBoundDatePanel.add(_upperBoundDateComboPanel.getEditingDisplayPanel(), constraints);
        constraints = SwingTools.returnGridBagConstraints(2,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        axisBoundDatePanel.add(new BufferJPanel(), constraints);

        return axisBoundDatePanel;
    }

    private void setupAxisBoundEditingPanel()
    {
        //Auto range
        JPanel autoRangePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        autoRangePanel.add(new JLabel("Auto Range Calculation:"));
        autoRangePanel.add(_autoRangeChoices);

        _axisBoundEditPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = null;
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        _axisBoundEditPanel.add(autoRangePanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        _axisBoundEditPanel.add(setupAxisBoundDateEditPanel(), constraints);

        _axisBoundEditPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                                       "Select Date Axis Limits",
                                                                       null));
    }

    private JPanel setupTickFormatPanel()
    {
        ButtonGroup group = new ButtonGroup();
        group.add(this._defaultTickFormatRadioButton);
        group.add(this._selectedTickFormatRadioButton);

        JScrollPane dateFormatPane = HSwingFactory.createScrollPanedJTextArea(null, "-default-", 2, 20, false, true);
        _dateFormatTextArea = (JTextArea)(dateFormatPane.getViewport().getView());
        _dateFormatTextArea.addFocusListener(this);

        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                             0,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             GridBagConstraints.WEST,
                                                                             GridBagConstraints.NONE,
                                                                             new Insets(0, 0, 0, 0),
                                                                             0,
                                                                             0);
        buttonPanel.add(this._defaultTickFormatRadioButton, constraints);
        constraints = SwingTools.returnGridBagConstraints(1,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.NONE,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        buttonPanel.add(this._selectedTickFormatRadioButton, constraints);

        JPanel returnedPanel = new JPanel(new GridBagLayout());
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        returnedPanel.add(buttonPanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.NONE,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        returnedPanel.add(dateFormatPane, constraints);
        returnedPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), "Set Date Tick Format", null));
        return returnedPanel;
    }

    /**
     * Add Axis tick unit Panels
     */
    private void setupTickSpacingEditPanel()
    {
        _tickSpacingEditPanel = new JPanel(new GridBagLayout());
        _tickSpacingEditPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                                         "Select Tick Spacing",
                                                                         null));

        ButtonGroup group = new ButtonGroup();
        group.add(_defaultTickSpacingRadioButton);
        group.add(_selectedTickSpacingRadioButton);

        //Button panel
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = null;
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        buttonPanel.add(_defaultTickSpacingRadioButton, constraints);
        constraints = SwingTools.returnGridBagConstraints(1,
                                                          0,
                                                          1,
                                                          1,
                                                          0,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        buttonPanel.add(_selectedTickSpacingRadioButton, constraints);
        constraints = SwingTools.returnGridBagConstraints(2,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        buttonPanel.add(new BufferJPanel(), constraints);

        JPanel editPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        editPanel.add(_autoTickSpacingBox);
        editPanel.add(_unitSpacingLabel);
        editPanel.add(_tickSpacingQuantitySpinner);
        editPanel.add(_tickSpacingUnitComboBox);

        constraints = SwingTools.returnGridBagConstraints(0,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        _tickSpacingEditPanel.add(buttonPanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        _tickSpacingEditPanel.add(editPanel, constraints);

        initTickSpacingPanel();
        _tickSpacingQuantitySpinner.setEnabled(!_defaultTickSpacingRadioButton.isSelected());
        _tickSpacingUnitComboBox.setEnabled(!_defaultTickSpacingRadioButton.isSelected());
    }

    private JPanel setupTickStartHourPanel()
    {
        ButtonGroup group = new ButtonGroup();
        group.add(this._defaultTickStartHourRadioButton);
        group.add(this._selectedTickStartHourRadioButton);

        this._dateTickStartHourSpinner = HSwingFactory.createJSpinner(null, 2, 0, 0, 24, 1);
        JPanel spinnerPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        spinnerPanel.add(new JLabel("Hour of Day (0-23):"));
        spinnerPanel.add(this._dateTickStartHourSpinner);
        this._dateTickStartHourSpinner.addChangeListener(this);

        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                             0,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             GridBagConstraints.WEST,
                                                                             GridBagConstraints.NONE,
                                                                             new Insets(0, 0, 0, 0),
                                                                             0,
                                                                             0);
        buttonPanel.add(this._defaultTickStartHourRadioButton, constraints);
        constraints = SwingTools.returnGridBagConstraints(1,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.NONE,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        buttonPanel.add(this._selectedTickStartHourRadioButton, constraints);

        JPanel returnedPanel = new JPanel(new GridBagLayout());
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        returnedPanel.add(buttonPanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.NONE,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        returnedPanel.add(spinnerPanel, constraints);
        returnedPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                                 "Set Initial Hour for Date Ticks",
                                                                 null));
        return returnedPanel;
    }

    private List<String> determineAutoRangeChoices()
    {
        List<String> choices = new ArrayList<String>();
        if(getDefaults().getAutoRange())
        {
            choices.add("Default (Auto)");
        }
        else
        {
            choices.add("Default (Manual)");
        }
        choices.add("Auto");
        choices.add("Manual");
        return choices;
    }

    private void createDateComboPanels()
    {
        GenericParameterList parametersDateList = new GenericParameterList();

        String lowerDate = null;
        String upperDate = null;

        DateAxisParameters defaultParameter = (DateAxisParameters)getDefaultParameters();
        lowerDate = defaultParameter.getLowerBound();
        upperDate = defaultParameter.getUpperBound();

        parametersDateList.addParameter("axisLowerDate", "T0");
        parametersDateList.addParameter("axisUpperDate", "T0");
        if(lowerDate != null)
        {
            parametersDateList.addParameter("axisLowerDate", lowerDate);
        }
        if(upperDate != null)
        {
            parametersDateList.addParameter("axisUpperDate", upperDate);
        }

        String[] fixRelOptions = new String[]{DateComboGenericParameterPanel.SET_TO_FIXED,
            DateComboGenericParameterPanel.SET_TO_RELATIVE};
        String[] dateTypeOptions = new String[]{HEFSDateTools.SYSTEM_TIME_BASIS_STR};
        _lowerBoundDateComboPanel = new DateComboGenericParameterPanel(parametersDateList,
                                                                       "axisLowerDate",
                                                                       getArgumentsProcessor(),
                                                                       null,
                                                                       fixRelOptions,
                                                                       DateComboGenericParameterPanel.SET_TO_FIXED,
                                                                       dateTypeOptions);
        _upperBoundDateComboPanel = new DateComboGenericParameterPanel(parametersDateList,
                                                                       "axisUpperDate",
                                                                       getArgumentsProcessor(),
                                                                       null,
                                                                       fixRelOptions,
                                                                       DateComboGenericParameterPanel.SET_TO_FIXED,
                                                                       dateTypeOptions);
    }

    private void initTickSpacingPanel()
    {
        _tickSpacingQuantitySpinner.setValue(1);
        _tickSpacingUnitComboBox.setSelectedIndex(UNIT_ARRAY.length - 2); //default to "day" option    
    }

    private void disableAxisBoundsEditingPanel()
    {
        disableLimitsEditing();
        this._autoRangeChoices.setEnabled(false);
    }

    private void enableAxisBoundEditingPanel()
    {
        this._autoRangeChoices.setEnabled(true);
        enableLimitsEditing();
    }

    private void disableLimitsEditing()
    {
        _lowerBoundDateComboPanel.setEnabled(false);
        _upperBoundDateComboPanel.setEnabled(false);
    }

    private void enableLimitsEditing()
    {
        _lowerBoundDateComboPanel.setEnabled(true);
        _upperBoundDateComboPanel.setEnabled(true);
    }

    private void disableTickSpacingEditPanel()
    {
        _defaultTickSpacingRadioButton.setEnabled(false);
        _selectedTickSpacingRadioButton.setEnabled(false);
        disableTickSpacingEditing();
    }

    private void enableTickSpacingEditPanel()
    {
        _defaultTickSpacingRadioButton.setEnabled(true);
        _selectedTickSpacingRadioButton.setEnabled(true);
        enableTickSpacingEditing();
    }

    private void enableTickSpacingEditing()
    {
        _autoTickSpacingBox.setEnabled(true);
        enableQuantityAndUnits();
    }

    private void disableTickSpacingEditing()
    {
        _autoTickSpacingBox.setEnabled(false);
        disableQuantityAndUnits();
    }

    private void enableQuantityAndUnits()
    {
        _unitSpacingLabel.setEnabled(true);
        _tickSpacingQuantitySpinner.setEnabled(true);
        _tickSpacingUnitComboBox.setEnabled(true);
    }

    private void disableQuantityAndUnits()
    {
        _unitSpacingLabel.setEnabled(false);
        _tickSpacingQuantitySpinner.setEnabled(false);
        _tickSpacingUnitComboBox.setEnabled(false);
    }

    private void disableTickFormatPanel()
    {
        this._defaultTickFormatRadioButton.setEnabled(false);
        this._selectedTickFormatRadioButton.setEnabled(false);
        this._dateFormatTextArea.setEnabled(false);
    }

    private void enableTickFormatPanel()
    {
        this._defaultTickFormatRadioButton.setEnabled(true);
        this._selectedTickFormatRadioButton.setEnabled(true);
        this._dateFormatTextArea.setEnabled(true);
    }

    private void disableTickStartHourPanel()
    {
        this._defaultTickStartHourRadioButton.setEnabled(false);
        this._selectedTickStartHourRadioButton.setEnabled(false);
        this._dateTickStartHourSpinner.setEnabled(false);
    }

    private void enableTickStartHourPanel()
    {
        this._defaultTickStartHourRadioButton.setEnabled(true);
        this._selectedTickStartHourRadioButton.setEnabled(true);
        this._dateTickStartHourSpinner.setEnabled(true);
    }

    private void determineAxisBoundsFields()
    {
        String lb = null;
        String ub = null;

        //If auto is chosen, have it display the number axis limits in the field.
        //If the default is chosen, then get the bounds to display from default.  This may or may not
        //display the calculated number axis limits, depending on default settings.
        if(getParameters().getAutoRange() == null)
        {
            if(!getDefaults().getAutoRange())
            {
                lb = getDefaults().getLowerBound();
                ub = getDefaults().getUpperBound();
            }
        }
        else if(!getParameters().getAutoRange())
        {
            return;
        }

        if((getCurrentAxis() != null) && (getCurrentAxis() instanceof DateAxisPlus))
        {
            DateAxis dateAxis = (DateAxis)getCurrentAxis();
            SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy hh:mm:ss");

            //GMT is used for both text fields.  
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));

            GenericParameterList dateParms = (GenericParameterList)_lowerBoundDateComboPanel.getManagedParameters();
            if(lb == null)
            {
                dateParms.getParameterWithName("axisLowerDate").setValue(sdf.format(dateAxis.getMinimumDate()));
                this._lowerBoundDateComboPanel.setDefaultValueIfUnchecked(sdf.format(dateAxis.getMinimumDate()));
            }
            else
            {
                dateParms.getParameterWithName("axisLowerDate").setValue(lb);
                this._lowerBoundDateComboPanel.setDefaultValueIfUnchecked(lb);
            }

            dateParms = (GenericParameterList)_upperBoundDateComboPanel.getManagedParameters();
            if(ub == null)
            {
                dateParms.getParameterWithName("axisUpperDate").setValue(sdf.format(dateAxis.getMaximumDate()));
                this._upperBoundDateComboPanel.setDefaultValueIfUnchecked(sdf.format(dateAxis.getMaximumDate()));
            }
            else
            {
                dateParms.getParameterWithName("axisUpperDate").setValue(ub);
                this._upperBoundDateComboPanel.setDefaultValueIfUnchecked(ub);
            }

            _lowerBoundDateComboPanel.makePanelReflectParameters();
            _upperBoundDateComboPanel.makePanelReflectParameters();
        }
    }

    protected boolean makeParametersReflectPanel()
    {
        boolean changeMade = makeAxisBoundParametersReflectPanel();
        changeMade = makeTickSpacingParametersReflectPanel() || changeMade;
        changeMade = makeDateTickFormatParameterReflectPanel() || changeMade;
        changeMade = makeDateTickStartHourParameterReflectPanel() || changeMade;
        return changeMade;
    }

    private void makeAxisBoundPanelReflectParameters()
    {
        removeListeners();

        //Means that both are null.
        if(getParameters().getAutoRange() == null)
        {
            _autoRangeChoices.setSelectedIndex(0);
            determineAxisBoundsFields();
            disableLimitsEditing();
        }
        else if(getParameters().getAutoRange())
        {
            _autoRangeChoices.setSelectedIndex(1);
            determineAxisBoundsFields();
            disableLimitsEditing();
        }
        else
        {
            _autoRangeChoices.setSelectedIndex(2);
            GenericParameterList dateParms = (GenericParameterList)_lowerBoundDateComboPanel.getManagedParameters();
            dateParms.getParameterWithName("axisLowerDate").setValue(getParameters().getLowerBound());
            dateParms = (GenericParameterList)_upperBoundDateComboPanel.getManagedParameters();
            dateParms.getParameterWithName("axisUpperDate").setValue(getParameters().getUpperBound());
            _lowerBoundDateComboPanel.makePanelReflectParameters();
            _upperBoundDateComboPanel.makePanelReflectParameters();
            enableLimitsEditing();
        }

        addListeners();
    }

    private boolean makeAxisBoundParametersReflectPanel()
    {
        removeListeners();
        boolean changeMade = false;

        //Default is selected; make sure the bounds are both null
        if(_autoRangeChoices.getSelectedIndex() == 0)
        {
            disableLimitsEditing();
            if(getParameters().getAutoRange() != null)
            {
                changeMade = true;
                getParameters().setAutoRange(null);
                getParameters().setLowerBound(null);
                getParameters().setUpperBound(null);
                determineAxisBoundsFields();
            }
        }

        //Auto is selected; don't change the bounds
        else if(_autoRangeChoices.getSelectedIndex() == 1)
        {
            disableLimitsEditing();
            if(!ohd.hseb.hefs.utils.tools.GeneralTools.checkForFullEqualityOfObjects(getParameters().getAutoRange(),
                                                                                     Boolean.TRUE))
            {
                changeMade = true;
                getParameters().setAutoRange(true);
                getParameters().setLowerBound(null);
                getParameters().setUpperBound(null);
                determineAxisBoundsFields();
            }
        }

        //Manual is selected; make sure bounds equal the fields
        else
        {
            enableLimitsEditing();
            if(!ohd.hseb.hefs.utils.tools.GeneralTools.checkForFullEqualityOfObjects(getParameters().getAutoRange(),
                                                                                     Boolean.FALSE))
            {
                changeMade = true;
                getParameters().setAutoRange(false);
            }
            changeMade = makeLowerBoundReflectField() || changeMade;
            changeMade = makeUpperBoundReflectField() || changeMade;
        }

        addListeners();
        return changeMade;
    }

    private boolean makeUpperBoundReflectField()
    {
        Calendar systemTime = ohd.hseb.hefs.utils.tools.GeneralTools.getSystemTime(getArgumentsProcessor());
        String dateString = _upperBoundDateComboPanel.getValueTextFieldText();
        if(dateString.trim().length() > 0)
        {
            //check if the input upper value is not greater than the existed lower value
            if(getParameters().getLowerBound() != null)
            {
                Long lower = HEFSDateTools.computeTime(systemTime, null, getParameters().getLowerBound());
                Long upper = HEFSDateTools.computeTime(systemTime, null, dateString);
                if(lower >= upper)
                {
                    JOptionPane.showMessageDialog(this,
                                                  "Axis upper date limit value is not greater than the lower date value.",
                                                  "axis limit error",
                                                  JOptionPane.ERROR_MESSAGE);
                    _upperBoundDateComboPanel.getValueTextField().setText(getParameters().getUpperBound());
                    return false;
                }
            }
            if(!ohd.hseb.hefs.utils.tools.StringTools.checkForFullEqualityOfStrings(dateString,
                                                                                    getParameters().getUpperBound(),
                                                                                    true))
            {
                getParameters().setUpperBound(dateString);
                return true;
            }
            return false;
        }

        _upperBoundDateComboPanel.getValueTextField().setText(getParameters().getUpperBound());
        return false;
    }

    private boolean makeLowerBoundReflectField()
    {
        Calendar systemTime = ohd.hseb.hefs.utils.tools.GeneralTools.getSystemTime(getArgumentsProcessor());
        String dateString = _lowerBoundDateComboPanel.getValueTextFieldText();
        if(dateString.trim().length() > 0)
        {
            //check if the input lower value is not less than the existed upper value
            if(getParameters().getUpperBound() != null)
            {
                Long lower = HEFSDateTools.computeTime(systemTime, null, dateString);
                Long upper = HEFSDateTools.computeTime(systemTime, null, getParameters().getUpperBound());
                if(lower >= upper)
                {
                    JOptionPane.showMessageDialog(this,
                                                  "Axis lower date limit value is not less than the upper date value.",
                                                  "axis limit error",
                                                  JOptionPane.ERROR_MESSAGE);
                    _lowerBoundDateComboPanel.getValueTextField().setText(getParameters().getLowerBound());
                    return false;
                }
            }
            if(!ohd.hseb.hefs.utils.tools.StringTools.checkForFullEqualityOfStrings(dateString,
                                                                                    getParameters().getLowerBound(),
                                                                                    true))
            {
                getParameters().setLowerBound(dateString);
                return true;
            }
            return false;
        }
        _lowerBoundDateComboPanel.getValueTextField().setText(getParameters().getLowerBound());
        return false;
    }

    private void makeTickSpacingPanelReflectParameters()
    {
        if(getParameters().getTickSpacing() == null)
        {
            _defaultTickSpacingRadioButton.setSelected(true);
            disableTickSpacingEditing();
            updateTickSpacingComponentsToReflectValue(getDefaults());
        }
        else if(getParameters().isAutoTickSpacing())
        {
            enableTickSpacingEditing();
            disableQuantityAndUnits();
            _selectedTickSpacingRadioButton.setSelected(true);
            updateTickSpacingComponentsToReflectValue(getParameters());
        }
        else
        {
            enableTickSpacingEditing();
            _selectedTickSpacingRadioButton.setSelected(true);
            _autoTickSpacingBox.setSelected(false);
            updateTickSpacingComponentsToReflectValue(getParameters());
        }
    }

    private boolean makeTickSpacingParametersReflectPanel()
    {
        boolean changeMade = false;
        if(_defaultTickSpacingRadioButton.isSelected())
        {
            disableTickSpacingEditing();
            if(getParameters().getTickSpacing() != null)
            {
                changeMade = true;
                getParameters().setTickSpacing(null);
                this.updateTickSpacingComponentsToReflectValue(getDefaults());
            }
        }
        else
        {
            enableTickSpacingEditing();
            if(_autoTickSpacingBox.isSelected())
            {
                disableQuantityAndUnits();
                if(!ohd.hseb.hefs.utils.tools.StringTools.checkForFullEqualityOfStrings(getParameters().getTickSpacing(),
                                                                                        DateAxisParameters.AUTO_TICK_SPACING_VALUE,
                                                                                        true))
                {
                    changeMade = true;
                    getParameters().setTickSpacing(DateAxisParameters.AUTO_TICK_SPACING_VALUE);
                }
            }
            else
            {
                String tickSpacingValue = "" + _tickSpacingQuantitySpinner.getValue() + " "
                    + _tickSpacingUnitComboBox.getSelectedItem();
                if(!ohd.hseb.hefs.utils.tools.StringTools.checkForFullEqualityOfStrings(getParameters().getTickSpacing(),
                                                                                        tickSpacingValue,
                                                                                        true))
                {
                    getParameters().setTickSpacing(tickSpacingValue);
                    changeMade = true;
                }
            }
        }
        return changeMade;

    }

    private void updateTickSpacingComponentsToReflectValue(DateAxisParameters parms)
    {
        _autoTickSpacingBox.setSelected(parms.isAutoTickSpacing());
        if(!parms.isAutoTickSpacing())
        {
            Integer quantity = parms.getTickSpacingQuantity();
            String unit = parms.getTickSpacingUnit();
            _tickSpacingQuantitySpinner.setValue(quantity);
            _tickSpacingUnitComboBox.setSelectedItem(unit);
        }
    }

    private void makeDateTickFormatPanelReflectParameters()
    {
        removeListeners();
        DateAxisParameters defaultParms = (DateAxisParameters)this.getDefaultParameters();

        //Tick format.
        if(getParameters().getTickFormat() == null)
        {
            this._defaultTickFormatRadioButton.setSelected(true);
            this._dateFormatTextArea.setText(defaultParms.getTickFormat());
            this._dateFormatTextArea.setEnabled(false);
        }
        else
        {
            this._selectedTickFormatRadioButton.setSelected(true);
            this._dateFormatTextArea.setEnabled(true);
            this._dateFormatTextArea.setText(this.getParameters().getTickFormat());
        }

        addListeners();
    }

    private boolean makeDateTickFormatParameterReflectPanel()
    {
        if(this._defaultTickFormatRadioButton.isSelected())
        {
            this._dateFormatTextArea.setEnabled(false);
            if(getParameters().getTickFormat() != null)
            {
                getParameters().setTickFormat(null);
                return true;
            }
        }
        else
        {
            this._dateFormatTextArea.setEnabled(true);
            if((getParameters().getTickFormat() == null)
                || (!getParameters().getTickFormat().equals(this._dateFormatTextArea.getText())))
            {
                getParameters().setTickFormat(this._dateFormatTextArea.getText());
                return true;
            }
        }
        return false;
    }

    private void makeDateTickStartHourPanelReflectParameters()
    {
        removeListeners();
        DateAxisParameters defaultParms = (DateAxisParameters)this.getDefaultParameters();

        //Tick start hour.
        if(getParameters().getTickStartHour() == null)
        {
            this._defaultTickStartHourRadioButton.setSelected(true);
            this._dateTickStartHourSpinner.setEnabled(false);
            this._dateTickStartHourSpinner.setValue(defaultParms.getTickStartHour());
        }
        else
        {
            this._selectedTickStartHourRadioButton.setSelected(true);
            this._dateTickStartHourSpinner.setEnabled(true);
            this._dateTickStartHourSpinner.setValue(getParameters().getTickStartHour());
        }

        addListeners();
    }

    private boolean makeDateTickStartHourParameterReflectPanel()
    {
        if(this._defaultTickStartHourRadioButton.isSelected())
        {
            _dateTickStartHourSpinner.setEnabled(false);
            _dateTickStartHourSpinner.setValue(getDefaults().getTickStartHour());
            if(getParameters().getTickStartHour() != null)
            {
                getParameters().setTickStartHour(null);
                return true;
            }
        }
        else
        {
            _dateTickStartHourSpinner.setEnabled(true);
            if((getParameters().getTickStartHour() == null)
                || (!getParameters().getTickStartHour().equals(this._dateTickStartHourSpinner.getValue())))
            {
                getParameters().setTickStartHour((Integer)this._dateTickStartHourSpinner.getValue());
                return true;
            }
        }
        return false;
    }

    protected void addListeners()
    {
        _lowerBoundDateComboPanel.addGraphicsGeneratorPlugInPanelListener(this);
        _upperBoundDateComboPanel.addGraphicsGeneratorPlugInPanelListener(this);

        _tickSpacingUnitComboBox.addItemListener(this);
        _tickSpacingQuantitySpinner.addChangeListener(this);

        _defaultTickFormatRadioButton.addActionListener(this);
        _selectedTickFormatRadioButton.addActionListener(this);

        _defaultTickStartHourRadioButton.addActionListener(this);
        _selectedTickStartHourRadioButton.addActionListener(this);
        _autoRangeChoices.addActionListener(this);
        _defaultTickSpacingRadioButton.addActionListener(this);
        _selectedTickSpacingRadioButton.addActionListener(this);

        _autoTickSpacingBox.addActionListener(this);
        _defaultAxisBoundsRadioButton.addActionListener(this);
        _selectedAxisBoundsRadioButton.addActionListener(this);
    }

    protected void removeListeners()
    {
        _lowerBoundDateComboPanel.removeGraphicsGeneratorPlugInPanelListener(this);
        _upperBoundDateComboPanel.removeGraphicsGeneratorPlugInPanelListener(this);

        _tickSpacingUnitComboBox.removeItemListener(this);
        _tickSpacingQuantitySpinner.removeChangeListener(this);

        _defaultTickFormatRadioButton.removeActionListener(this);
        _selectedTickFormatRadioButton.removeActionListener(this);

        _defaultTickStartHourRadioButton.removeActionListener(this);
        _selectedTickStartHourRadioButton.removeActionListener(this);

        _autoRangeChoices.removeActionListener(this);
        _autoTickSpacingBox.removeActionListener(this);
        _defaultTickSpacingRadioButton.removeActionListener(this);
        _selectedTickSpacingRadioButton.removeActionListener(this);
        _defaultAxisBoundsRadioButton.removeActionListener(this);
        _selectedAxisBoundsRadioButton.removeActionListener(this);
    }

    public ValueAxis getCurrentAxis()
    {
        return _currentAxis;
    }

    public void setCurrentAxis(ValueAxis currAxis)
    {
        this._currentAxis = currAxis;
        this.determineAxisBoundsFields();
    }

    public ArgumentsProcessor getArgumentsProcessor()
    {
        return this._argumentsProcessor;
    }

    public void setArgumentsProcessor(DefaultArgumentsProcessor argumentsProcessor)
    {
        this._argumentsProcessor = argumentsProcessor;
    }

    public DateAxisParameters getParameters()
    {
        return (DateAxisParameters)this.getManagedParameters();
    }

    public DateAxisParameters getDefaults()
    {
        return (DateAxisParameters)this.getDefaultParameters();
    }

    @Override
    public void makePanelReflectParameters()
    {
        makeAxisBoundPanelReflectParameters();
        makeTickSpacingPanelReflectParameters();
        makeDateTickFormatPanelReflectParameters();
        makeDateTickStartHourPanelReflectParameters();
    }

    @Override
    public void disableSubPanel()
    {
        disableAxisBoundsEditingPanel();
        disableTickSpacingEditPanel();
        disableTickFormatPanel();
        disableTickStartHourPanel();
    }

    @Override
    public void enableSubPanel()
    {
        enableAxisBoundEditingPanel();
        enableTickSpacingEditPanel();
        enableTickFormatPanel();
        enableTickStartHourPanel();
    }

    @Override
    /**
     * This is the parameter changed method that is called when the data limit subpanels are modified!
     */
    public void parameterChanged(GeneralPlugInParameters parameters)
    {
        //Set the parameters based on the date panels that triggered this event.
        if(makeAxisBoundParametersReflectPanel())
        {
            fireParametersChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt)
    {
        if((evt.getSource() == this._defaultTickSpacingRadioButton)
            || (evt.getSource() == this._selectedTickSpacingRadioButton))
        {
            if(makeTickSpacingParametersReflectPanel())
            {
                fireParametersChanged();
            }
        }
        else if((evt.getSource() == this._defaultTickFormatRadioButton)
            || (evt.getSource() == this._selectedTickFormatRadioButton))
        {
            if(makeDateTickFormatParameterReflectPanel())
            {
                fireParametersChanged();
            }
        }
        else if((evt.getSource() == this._defaultTickStartHourRadioButton)
            || (evt.getSource() == this._selectedTickStartHourRadioButton))
        {
            if(makeDateTickStartHourParameterReflectPanel())
            {
                fireParametersChanged();
            }
        }
        else if(evt.getSource() == this._autoRangeChoices)
        {
            if(this.makeAxisBoundParametersReflectPanel())
            {
                fireParametersChanged();
            }
        }
        else if(evt.getSource() == _autoTickSpacingBox)
        {
            if(makeTickSpacingParametersReflectPanel())
            {
                fireParametersChanged();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt)
    {
        //Date unit selection made.
        if((evt.getSource() == this._tickSpacingUnitComboBox) && (evt.getStateChange() == ItemEvent.SELECTED))
        {
            if(makeTickSpacingParametersReflectPanel())
            {
                fireParametersChanged();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt)
    {
        if(evt.getSource() == _tickSpacingQuantitySpinner)
        {
            Integer quantity = (Integer)this._tickSpacingQuantitySpinner.getValue();
            String unit = (String)this._tickSpacingUnitComboBox.getSelectedItem();
            getParameters().setTickSpacing("" + quantity + " " + unit);

            fireParametersChanged();
        }
        else if(evt.getSource() == this._dateTickStartHourSpinner)
        {
            if(makeDateTickStartHourParameterReflectPanel())
            {
                fireParametersChanged();
            }
        }
    }

    @Override
    public void focusGained(FocusEvent arg0)
    {
    }

    @Override
    public void focusLost(FocusEvent arg0)
    {
        if(arg0.getSource() == this._dateFormatTextArea)
        {
            if(makeDateTickFormatParameterReflectPanel())
            {
                fireParametersChanged();
            }
        }
    }

}
