package ohd.hseb.charter.parameters.panels;

import javax.swing.JComboBox;

import ohd.hseb.charter.ChartEngine;

/**
 * Designed {@link ChartEngine} {@link ChartParametersPanel} instances, this displays a three item combo box triggered
 * by a {@link Boolean} value: 'Default(...)' for null, {@link #YES_STR} for true, and {@link #NO_STR} for false. The
 * default value of the {@link Boolean} that corresponds to index 0 is specified in the constructor. The methods
 * 
 * @author Hank.Herr
 */
@SuppressWarnings("serial")
public class DefaultYesNoComboBox extends JComboBox<String>
{
    public static final String YES_STR = "Yes";
    public static final String NO_STR = "No";

    /**
     * @param defaultValue The boolean that represents the default value corresponding to a selection of the default
     *            item at index 0.
     */
    public DefaultYesNoComboBox(final boolean defaultValue)
    {
        super(new String[]{"Default (" + convertBooleanToStr(defaultValue) + ")", convertBooleanToStr(true),
            convertBooleanToStr(false)});
    }

    /**
     * @return Null if item 0 is select, true if 'Yes' is chosen, false if 'No' is chosen.
     */
    public Boolean getSelectedValue()
    {
        if(getSelectedIndex() == 0)
        {
            return null;
        }
        return DefaultYesNoComboBox.convertStrToBoolean((String)getSelectedItem());
    }

    /**
     * Selects item 0 if null is porvided, item 1 (yes) if true is provided, item 2 (no) if false is provided.
     * 
     * @param b
     */
    public void setSelectedValue(final Boolean b)
    {
        if(b == null)
        {
            setSelectedIndex(0);
        }
        else
        {
            setSelectedItem(convertBooleanToStr(b));
        }
    }

    /**
     * @return True if the string matches {@link #YES_STR} (case insensitive); false if not.
     */
    private static boolean convertStrToBoolean(final String yesNoStr)
    {
        if(yesNoStr.equalsIgnoreCase(YES_STR))
        {
            return true;
        }
        return false;
    }

    /**
     * @return {@link #YES_STR} for true, {@link #NO_STR} otherwise.
     */
    private static String convertBooleanToStr(final boolean b)
    {
        if(b)
        {
            return YES_STR;
        }
        return NO_STR;
    }

}
