package ohd.hseb.charter.parameters.panels;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.DecimalFormat;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

import ohd.hseb.charter.parameters.GeneralParameters;
import ohd.hseb.charter.parameters.ImageParameters;
import ohd.hseb.hefs.utils.arguments.ArgumentInsertingEditableComboBox;
import ohd.hseb.hefs.utils.datetime.HEFSTimeZoneTools;
import ohd.hseb.hefs.utils.filechooser.HGlobalFileChooser;
import ohd.hseb.hefs.utils.gui.components.BufferJPanel;
import ohd.hseb.hefs.utils.gui.components.SeparatableJComboBoxRenderer;
import ohd.hseb.hefs.utils.gui.tools.ColorTools;
import ohd.hseb.hefs.utils.gui.tools.DialogHelper;
import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInPanelListener;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInParameters;

public class GeneralParametersPanel extends ChartParametersPanel implements GeneralPlugInPanelListener, ActionListener,
ItemListener, FocusListener
{
    private static final long serialVersionUID = 4417965549262198816L;

    //components for time zone panel
    private final ButtonGroup _timeZoneIdRadioButtonGroup = new ButtonGroup();
    private final JRadioButton _defaultTimeZoneIdRadioButton = new JRadioButton("Default", true);
    private final JRadioButton _selectedTimeZoneIdRadioButton = new JRadioButton("User Specified");
    private ArgumentInsertingEditableComboBox _timeZoneIdChoicesComboBox = null;

    //components for background image panel
    private final JRadioButton _defaultBackgroundImageRadioButton = new JRadioButton("Default", true);
    private final JRadioButton _selectedBackgroundImageRadioButton = new JRadioButton("User Specified");
    private final JButton _backgroundImageButton = new JButton("Select");

    private final JComboBox _backgroundImageComboBox = new ArgumentInsertingEditableComboBox(null,
                                                                                             ImageParameters.DEFAULT_IMAGE_PATHS);
    private final JComboBox _alignmentChoicesComboBox = HSwingFactory.createJComboBox(ImageParameters.buildAlignmentDisplayedStrings(),
                                                                                      null);
    /* FB 1835 */
    final JComboBox _imageTransparencyComboBox = HSwingFactory.createJComboBox(ImageParameters.buildTansparencyDisplayedStrings(),
                                                                               null);
    private final JSpinner _imageTransparencySpinner = HSwingFactory.createJSpinner(null, 5, null, 0.5, 0.1, 1.0, 0.1);

    //components for chart background panel
    private final JRadioButton _defaultChartBackgroundColorRadioButton = new JRadioButton("Default", true);
    private final JRadioButton _selectedChartBackgroundColorRadioButton = new JRadioButton("User Specified");
    private final JButton _chartBackgroundColorButton = new JButton("");
    private final JComboBox _dashedGridLineComboBox = new JComboBox(GeneralParameters.DEFAULT_ISDASHED_DISPLAYED_STRING);

    //used for JFormattedTextFields
    private static final String _decimalFormatString = "0.00";
    private final DecimalFormat _decimalFormat = new DecimalFormat(_decimalFormatString);

    //components for plot background panel
    private final JRadioButton _defaultPlotBackgroundColorRadioButton = new JRadioButton("Default", true);
    private final JRadioButton _selectedPlotBackgroundColorRadioButton = new JRadioButton("User Specified");
    private final JButton _plotBackgroundColorButton = new JButton("");

    //components for grid line panel
    private final JRadioButton _defaultGridLineRadioButton = new JRadioButton("Default", true);
    private final JRadioButton _selectedGridLineRadioButton = new JRadioButton("User Specified");
    private final JFormattedTextField _gridLineWidthTextField = new JFormattedTextField(_decimalFormat);

    private final GeneralParameters _defaultParameters;

    public GeneralParametersPanel(final GeneralParameters managedParameters, final GeneralParameters defaultParameters)
    {
        this.setManagedParameters(managedParameters);
        this._defaultParameters = defaultParameters;
        createDisplay();
        addListeners();
        makePanelReflectParameters();
    }

    private void addListeners()
    {
        _chartBackgroundColorButton.addActionListener(this);
        _defaultChartBackgroundColorRadioButton.addActionListener(this);
        _selectedChartBackgroundColorRadioButton.addActionListener(this);

        _plotBackgroundColorButton.addActionListener(this);
        _defaultPlotBackgroundColorRadioButton.addActionListener(this);
        _selectedPlotBackgroundColorRadioButton.addActionListener(this);

        _backgroundImageButton.addActionListener(this);
        _defaultBackgroundImageRadioButton.addActionListener(this);
        _selectedBackgroundImageRadioButton.addActionListener(this);
        _alignmentChoicesComboBox.addItemListener(this);
        /* FB 1835 */
        _imageTransparencyComboBox.addItemListener(this);
        // TODO: _imageTransparencySpinner.addChangeListener(this);
        _imageTransparencySpinner.addFocusListener(this);

        _defaultTimeZoneIdRadioButton.addActionListener(this);
        _selectedTimeZoneIdRadioButton.addActionListener(this);
        _timeZoneIdChoicesComboBox.addActionListener(this);
        _timeZoneIdChoicesComboBox.addFocusListener(this);

        _defaultGridLineRadioButton.addActionListener(this);
        _selectedGridLineRadioButton.addActionListener(this);

        _backgroundImageComboBox.addItemListener(this);

        _dashedGridLineComboBox.addItemListener(this);
        _gridLineWidthTextField.addFocusListener(this);
        _gridLineWidthTextField.addActionListener(this);

    }

    /**
     * Setup the Background Image Panel
     */
    private JPanel createBackgroundImagePanel()
    {
        //For now, I'm going to add the NOAA water mark manually to the choice box.
        final JPanel filePanel = new JPanel();
        filePanel.add(this._backgroundImageButton);
        filePanel.add(new JLabel("File:"));
        filePanel.add(_backgroundImageComboBox);
        _backgroundImageComboBox.setEditable(true);
        ((JTextField)_backgroundImageComboBox.getEditor()).setColumns(30);
        _backgroundImageButton.setToolTipText("Select Image File");

        final ButtonGroup group = new ButtonGroup();
        group.add(_defaultBackgroundImageRadioButton);
        group.add(_selectedBackgroundImageRadioButton);
        final JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.add(_defaultBackgroundImageRadioButton);
        radioButtonPanel.add(_selectedBackgroundImageRadioButton);

        final JPanel choicesPanel = new JPanel();
        choicesPanel.add(new JLabel("Image Alignment:"));
        choicesPanel.add(_alignmentChoicesComboBox);

        /* FB 1835 */
        final JPanel imageTransparencyPanel = new JPanel();
        imageTransparencyPanel.add(new JLabel("Image Transparency:"));
        imageTransparencyPanel.add(_imageTransparencyComboBox);

        final Insets theinsets = new Insets(0, 0, 0, 0);
        final JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), "Select Background Image", null));
        GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                             0,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             0,
                                                                             GridBagConstraints.WEST,
                                                                             GridBagConstraints.NONE,
                                                                             theinsets,
                                                                             0,
                                                                             0);
        panel.add(radioButtonPanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        panel.add(filePanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          2,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        panel.add(choicesPanel, constraints);
        /* FB 1835 */
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          3,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        panel.add(imageTransparencyPanel, constraints);

        return panel;
    }

    /**
     * Setup the Chart Background Color Panel
     */
    private JPanel createChartBackgroundColorPanel()
    {
        final JPanel colorPanel = new JPanel(new GridBagLayout());

        final Insets theinsets = new Insets(0, 0, 0, 0);

        _chartBackgroundColorButton.setToolTipText("Select Color");

        colorPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), "Select Chart Background Color", null));
        final ButtonGroup group = new ButtonGroup();
        group.add(_defaultChartBackgroundColorRadioButton);
        group.add(_selectedChartBackgroundColorRadioButton);

        GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                             0,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             0,
                                                                             GridBagConstraints.LINE_START,
                                                                             GridBagConstraints.NONE,
                                                                             theinsets,
                                                                             0,
                                                                             0);

        colorPanel.add(_defaultChartBackgroundColorRadioButton, constraints);

        constraints = SwingTools.returnGridBagConstraints(1,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.LINE_START,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        colorPanel.add(_selectedChartBackgroundColorRadioButton, constraints);

        constraints = SwingTools.returnGridBagConstraints(2,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.LINE_START,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        colorPanel.add(_chartBackgroundColorButton, constraints);

        return colorPanel;
    }

    private void createDisplay()
    {
        final Insets insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        int gridy = 0;
        GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                             gridy,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             0,
                                                                             GridBagConstraints.WEST,
                                                                             GridBagConstraints.BOTH,
                                                                             insets,
                                                                             0,
                                                                             0);
        this.add(createChartBackgroundColorPanel(), constraints);

        gridy++;
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          gridy,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          insets,
                                                          0,
                                                          0);
        this.add(createPlotBackgroundColorPanel(), constraints);

        gridy++;
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          gridy,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          insets,
                                                          0,
                                                          0);
        this.add(createBackgroundImagePanel(), constraints);

        gridy++;
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          gridy,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          insets,
                                                          0,
                                                          0);
        this.add(createGridLinePanel(), constraints);

        gridy++;
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          gridy,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          insets,
                                                          0,
                                                          0);
        this.add(createTimeZoneIdPanel(), constraints);

        gridy++;
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          gridy,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        this.add(new BufferJPanel(), constraints);

    }

    /**
     * Setup the Grid Line Panel
     */
    private JPanel createGridLinePanel()
    {
        final ButtonGroup group = new ButtonGroup();
        group.add(_defaultGridLineRadioButton);
        group.add(_selectedGridLineRadioButton);

        final JPanel panel = new JPanel(new GridBagLayout());

        final Insets theinsets = new Insets(0, 0, 0, 0);

        panel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), "Select Grid Line", null));

        GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                             0,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             0,
                                                                             GridBagConstraints.LINE_START,
                                                                             GridBagConstraints.NONE,
                                                                             theinsets,
                                                                             0,
                                                                             0);

        panel.add(_defaultGridLineRadioButton, constraints);

        constraints = SwingTools.returnGridBagConstraints(1,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.LINE_START,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        panel.add(_selectedGridLineRadioButton, constraints);

        final JPanel stylePanel = new JPanel(new FlowLayout());
        stylePanel.add(HSwingFactory.createJLabel("Dashed Line? ", null, null));
        stylePanel.add(_dashedGridLineComboBox);

        constraints = SwingTools.returnGridBagConstraints(0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.LINE_START,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        panel.add(stylePanel, constraints);

        final JPanel widthPanel = new JPanel(new GridLayout(1, 0));
        widthPanel.add(HSwingFactory.createJLabel("Line Width: ", null, null));
        _gridLineWidthTextField.setText(String.valueOf(_defaultParameters.getGridLineWidth()));
        widthPanel.add(_gridLineWidthTextField);

        constraints = SwingTools.returnGridBagConstraints(1,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.LINE_START,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        panel.add(widthPanel, constraints);

        return panel;

    }

    /**
     * Setup the Plot Area Background Color Panel
     */
    private JPanel createPlotBackgroundColorPanel()
    {
        final JPanel colorPanel = new JPanel(new GridBagLayout());

        final Insets theinsets = new Insets(0, 0, 0, 0);

        this._plotBackgroundColorButton.setToolTipText("Select Color");

        colorPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                              "Select Plot Area Background Color",
                                                              null));
        final ButtonGroup group = new ButtonGroup();
        group.add(_defaultPlotBackgroundColorRadioButton);
        group.add(_selectedPlotBackgroundColorRadioButton);

        GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                             0,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             0,
                                                                             GridBagConstraints.LINE_START,
                                                                             GridBagConstraints.NONE,
                                                                             theinsets,
                                                                             0,
                                                                             0);

        colorPanel.add(_defaultPlotBackgroundColorRadioButton, constraints);

        constraints = SwingTools.returnGridBagConstraints(1,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.LINE_START,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        colorPanel.add(_selectedPlotBackgroundColorRadioButton, constraints);

        constraints = SwingTools.returnGridBagConstraints(2,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.LINE_START,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        colorPanel.add(_plotBackgroundColorButton, constraints);

        _selectedPlotBackgroundColorRadioButton.setSelected(true);

        return colorPanel;
    }

    /**
     * Setup the Background Image Panel
     */
    private JPanel createTimeZoneIdPanel()
    {
        _timeZoneIdRadioButtonGroup.add(_defaultTimeZoneIdRadioButton);
        _timeZoneIdRadioButtonGroup.add(_selectedTimeZoneIdRadioButton);
        final JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.add(_defaultTimeZoneIdRadioButton);
        radioButtonPanel.add(_selectedTimeZoneIdRadioButton);

        _timeZoneIdChoicesComboBox = new ArgumentInsertingEditableComboBox(getParameters().getArguments(),
                                                                           HEFSTimeZoneTools.getValidTimeZoneIdentifiersIncludingSeparators()
                                                                                            .toArray());
        _timeZoneIdChoicesComboBox.setRenderer(new SeparatableJComboBoxRenderer());
        _timeZoneIdChoicesComboBox.setEditable(true);
        final JPanel choicesPanel = new JPanel();
        choicesPanel.add(new JLabel("Time Zone:"));
        choicesPanel.add(_timeZoneIdChoicesComboBox);

        final Insets theinsets = new Insets(0, 0, 0, 0);
        final JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), "Select Time Zone", null));
        GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                             0,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             0,
                                                                             GridBagConstraints.WEST,
                                                                             GridBagConstraints.NONE,
                                                                             theinsets,
                                                                             0,
                                                                             0);
        panel.add(radioButtonPanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        panel.add(choicesPanel, constraints);

        return panel;
    }

    public GeneralParameters getOverRideParameters()
    {
        return (GeneralParameters)getManagedParameters();
    }

    public GeneralParameters getParameters()
    {
        return (GeneralParameters)getManagedParameters();
    }

    public boolean isDefaultBackgroundImageSelected()
    {
        return _defaultBackgroundImageRadioButton.isSelected();
    }

    public boolean isDefaultChartBackgroundColorSelected()
    {
        return _defaultChartBackgroundColorRadioButton.isSelected();
    }

    public boolean isDefaultPlotBackgroundColorSelected()
    {
        return _defaultPlotBackgroundColorRadioButton.isSelected();
    }

    private void makeParametersReflectPanel()
    {
        final GeneralParameters overRideParameters = getOverRideParameters();

        if(this._defaultChartBackgroundColorRadioButton.isSelected())
        {
            overRideParameters.setChartBackgroundColor(null);
        }
        else
        {
            overRideParameters.setChartBackgroundColor(((ColorIcon)_chartBackgroundColorButton.getIcon()).getColor());
        }

        if(this._defaultPlotBackgroundColorRadioButton.isSelected())
        {
            overRideParameters.setPlotBackgroundColor(null);
        }
        else
        {
            overRideParameters.setPlotBackgroundColor(((ColorIcon)_plotBackgroundColorButton.getIcon()).getColor());
        }

        if(this._defaultBackgroundImageRadioButton.isSelected())
        {
            overRideParameters.getBackgroundImageParameters().clearParameters();
        }
        else
        {
            final String imagePath = (String)_backgroundImageComboBox.getSelectedItem();
            if(imagePath != null && imagePath.trim().length() > 0)
            {
                overRideParameters.getBackgroundImageParameters().setImagePath(imagePath);
            }
            final String strAlignment = (String)_alignmentChoicesComboBox.getSelectedItem();
            overRideParameters.getBackgroundImageParameters()
                              .setImageAlignment(ImageParameters.determineAlignmentForAlignmentString(strAlignment));
            /* FB 1835 */
            final String strTransparency = (String)_imageTransparencyComboBox.getSelectedItem();
            overRideParameters.getBackgroundImageParameters()
                              .setImageTransparency(ImageParameters.determineTransparencyForTransparencyString(strTransparency));

        }

        if(this._defaultTimeZoneIdRadioButton.isSelected())
        {
            overRideParameters.setTimeZoneId(null);
        }
        else
        {
            overRideParameters.setTimeZoneId((String)_timeZoneIdChoicesComboBox.getSelectedItem());
        }

        if(this._defaultGridLineRadioButton.isSelected())
        {
            overRideParameters.setGridLineWidth(null);
            overRideParameters.setDashedGridLine(null);
        }
        else
        {
            final Number lineWidthNumber = (Number)_gridLineWidthTextField.getValue();

            if(lineWidthNumber != null)
            {
                overRideParameters.setGridLineWidth(lineWidthNumber.floatValue());
            }

            final Boolean isDashed = GeneralParameters.getGridLineIsDashedValue((String)_dashedGridLineComboBox.getSelectedItem());

            overRideParameters.setDashedGridLine(isDashed);
        }
    }

    private void processBackgroundImageAction()
    {
        final HGlobalFileChooser fileChooser = new HGlobalFileChooser(".");
        fileChooser.addFileFilter("gif", "GIF Image");
        fileChooser.addFileFilter("jpg", "JPG Image");
        fileChooser.addFileFilter("jpeg", "JPEG Image");
        fileChooser.addFileFilter("png", "PNG Image");
        fileChooser.setDialogTitle("Select Image File");
        final File selectedFile = fileChooser.chooseFile(JFileChooser.FILES_ONLY, this);
        if(selectedFile == null)
        {
            return;
        }

        final String filePath = selectedFile.getPath();
        this._backgroundImageComboBox.setSelectedItem(filePath);

        processBackgroundImagePath();
        fireParametersChanged();
    }

    private void processBackgroundImagePath()
    {
        try
        {
            final Image image = ImageParameters.loadImageBasedOnPath((String)_backgroundImageComboBox.getSelectedItem(),
                                                                     this.getParameters().getArguments());
            final String path = (String)_backgroundImageComboBox.getSelectedItem();

            //Do nothing if there is no change in the path.
            if(path.equals(getParameters().getBackgroundImageParameters().getImagePath()))
            {
                return;
            }

            //Otherwise, make the change and let the makeParametersReflect call execute.
            getParameters().getBackgroundImageParameters().setImagePath(path);
            getParameters().getBackgroundImageParameters().setImage(image);
        }
        catch(final Exception e)
        {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error Loading Image!", JOptionPane.ERROR_MESSAGE);
            _backgroundImageComboBox.removeItemListener(this);
            _backgroundImageComboBox.setSelectedItem(getParameters().getBackgroundImageParameters().getImagePath());
            _backgroundImageComboBox.addItemListener(this);
        }

        makeParametersReflectPanel();
    }

    private void processBackgroundImageRadioAction()
    {
        setBackgroundImagePanel(_defaultBackgroundImageRadioButton.isSelected());
        makeParametersReflectPanel();
        fireParametersChanged();
    }

    private void processChartBackgroundColorAction()
    {
        Color color = getOverRideParameters().getChartBackgroundColor();
        if(color == null)
        {
            color = GeneralParameters.DEFAULT_CHART_BACKGROUND_COLOR;
        }
        color = ColorTools.chooseColor(this, color);
        if(color != null)
        {
            getOverRideParameters().setChartBackgroundColor(color);
            updateChartBackgroundColorPanel();
            makeParametersReflectPanel();
            fireParametersChanged();
        }
    }

    private void processChartBackgroundColorRadioAction()
    {
        setChartBackgroundColorButton(_defaultChartBackgroundColorRadioButton.isSelected());
        makeParametersReflectPanel();
        fireParametersChanged();
    }

    private void processGridLineRadioAction()
    {
        setGridLinePanel(_defaultGridLineRadioButton.isSelected());
        makeParametersReflectPanel();
        fireParametersChanged();
    }

    private void processGridLineWidth()
    {
        final String strWidth = _gridLineWidthTextField.getText().trim();

        if(!strWidth.isEmpty())
        {
            try
            {
                final Number lineWidthNumber = (Number)_gridLineWidthTextField.getValue();

                if(lineWidthNumber == null)
                {
                    throw new Exception("INVALID grid line width value.");
                }

                final Float lineWidthFloat = lineWidthNumber.floatValue();

                getOverRideParameters().setGridLineWidth(lineWidthFloat);
                updateGridLineWidthTextField();
            }
            catch(final Exception e)
            {
                DialogHelper.displayErrorDialog(null, e.getMessage(), "PARAMETER ERROR");

                updateGridLineWidthTextField();
            }
        }
        else
        {
            updateGridLineWidthTextField();
        }

        makeParametersReflectPanel();
        fireParametersChanged();
    }

    private void processPlotBackgroundColorAction()
    {
        Color color = getOverRideParameters().getPlotBackgroundColor();
        if(color == null)
        {
            color = GeneralParameters.DEFAULT_PLOT_BACKGROUND_COLOR;
        }

        color = ColorTools.chooseColor(this, color);
        if(color != null)
        {
            getOverRideParameters().setPlotBackgroundColor(color);
            updatePlotBackgroundColorPanel();
            makeParametersReflectPanel();
            fireParametersChanged();
        }
    }

    private void processPlotBackgroundColorRadioAction()
    {
        setPlotBackgroundColorButton(_defaultPlotBackgroundColorRadioButton.isSelected());
        makeParametersReflectPanel();
        fireParametersChanged();
    }

    private void processTimeZoneIdRadioAction()
    {
        setTimeZonePanel(_defaultTimeZoneIdRadioButton.isSelected());
        makeParametersReflectPanel();
        fireParametersChanged();
    }

    private void removeListeners()
    {
        _chartBackgroundColorButton.removeActionListener(this);
        _defaultChartBackgroundColorRadioButton.removeActionListener(this);
        _selectedChartBackgroundColorRadioButton.removeActionListener(this);

        _plotBackgroundColorButton.removeActionListener(this);
        _defaultPlotBackgroundColorRadioButton.removeActionListener(this);
        _selectedPlotBackgroundColorRadioButton.removeActionListener(this);

        _backgroundImageButton.removeActionListener(this);
        _defaultBackgroundImageRadioButton.removeActionListener(this);
        _selectedBackgroundImageRadioButton.removeActionListener(this);
        _alignmentChoicesComboBox.removeItemListener(this);
        /* FB 1835 */
        _imageTransparencyComboBox.removeItemListener(this);
        _defaultTimeZoneIdRadioButton.removeActionListener(this);
        _selectedTimeZoneIdRadioButton.removeActionListener(this);
        _timeZoneIdChoicesComboBox.removeActionListener(this);
        _timeZoneIdChoicesComboBox.removeFocusListener(this);

        _defaultGridLineRadioButton.removeActionListener(this);
        _selectedGridLineRadioButton.removeActionListener(this);
        _dashedGridLineComboBox.removeItemListener(this);
        _gridLineWidthTextField.removeFocusListener(this);
        _gridLineWidthTextField.removeActionListener(this);

        _backgroundImageComboBox.removeItemListener(this);
    }

    private void setBackgroundImagePanel(final boolean setDefault)
    {
        String bgImagePath = null;

        // Default radio button is selected.  Get the properties from the defaultParameters
        if(setDefault)
        {
            _backgroundImageButton.setEnabled(false);
            _alignmentChoicesComboBox.setEnabled(false);
            /* FB 1835 */
            _imageTransparencyComboBox.setEnabled(false);
            _backgroundImageComboBox.setEnabled(false);

            _backgroundImageComboBox.setSelectedItem("");
            _alignmentChoicesComboBox.setSelectedIndex(0);
            /* FB 1835 */
            _imageTransparencyComboBox.setSelectedIndex(0);
        }
        else
        {
            _backgroundImageButton.setEnabled(true);
            _alignmentChoicesComboBox.setEnabled(true);
            /* FB 1835 */
            _imageTransparencyComboBox.setEnabled(true);
            _backgroundImageComboBox.setEnabled(true);

            _alignmentChoicesComboBox.setSelectedItem(ImageParameters.determineAlignmentStringForAlignment(getOverRideParameters().getBackgroundImageParameters()
                                                                                                                                  .getImageAlignment()));
            /* FB 1835 */
            _imageTransparencyComboBox.setSelectedItem(ImageParameters.determineTransparencyStringForTransparency(getOverRideParameters().getBackgroundImageParameters()
                                                                                                                                         .getImageTransparency()));

            bgImagePath = getOverRideParameters().getBackgroundImageParameters().getImagePath();
            if(bgImagePath == null)
            {
                bgImagePath = _defaultParameters.getBackgroundImageParameters().getImagePath();
            }

            if(bgImagePath != null)
            {
                _backgroundImageComboBox.setSelectedItem(bgImagePath);
            }
            else
            {
                _backgroundImageComboBox.setSelectedItem("");
            }
        }
    }

    private void setChartBackgroundColorButton(final boolean setDefault)
    {
        Color bgColor = null;

        // Default radio button is selected.  Get the color from the defaultParameters
        if(setDefault)
        {
            _chartBackgroundColorButton.setEnabled(false);
            bgColor = _defaultParameters.getChartBackgroundColor();
        }
        else
        {
            _chartBackgroundColorButton.setEnabled(true);
            bgColor = getOverRideParameters().getChartBackgroundColor();
            if(bgColor == null)
            {
                bgColor = _defaultParameters.getChartBackgroundColor();
            }
        }
        _chartBackgroundColorButton.setIcon(new ColorIcon(bgColor));
    }

    private void setGridLinePanel(final boolean setDefault)
    {
        String strWidth = null;
        String strIsDashed = null;

        // Default radio button is selected.  Get the properties from the defaultParameters
        if(setDefault)
        {
            _dashedGridLineComboBox.setEnabled(false);
            _gridLineWidthTextField.setEnabled(false);

            strWidth = String.valueOf(_defaultParameters.getGridLineWidth());
            strIsDashed = GeneralParameters.DEFAULT_ISDASHED_DISPLAYED_STRING[0];
        }
        else
        {
            _dashedGridLineComboBox.setEnabled(true);
            _gridLineWidthTextField.setEnabled(true);

            strIsDashed = GeneralParameters.getGridLineIsDashedDisplayedString(getOverRideParameters().isDashedGridLine());

            Float width = getOverRideParameters().getGridLineWidth();
            if(width == null)
            {
                width = _defaultParameters.getGridLineWidth();
            }
            strWidth = String.valueOf(width);
        }

        _gridLineWidthTextField.setText(strWidth);
        _dashedGridLineComboBox.setSelectedItem(strIsDashed);
    }

    private void setPlotBackgroundColorButton(final boolean setDefault)
    {
        Color bgColor = null;

        // Default radio button is selected.  Get the color from the defaultParameters
        if(setDefault)
        {
            _plotBackgroundColorButton.setEnabled(false);
            bgColor = _defaultParameters.getPlotBackgroundColor();
        }
        else
        {
            _plotBackgroundColorButton.setEnabled(true);
            bgColor = getOverRideParameters().getPlotBackgroundColor();
            if(bgColor == null)
            {
                bgColor = _defaultParameters.getPlotBackgroundColor();
            }
        }
        _plotBackgroundColorButton.setIcon(new ColorIcon(bgColor));
    }

    private void setTimeZonePanel(final boolean setDefault)
    {
        // Default radio button is selected.  Get the properties from the defaultParameters
        if(setDefault)
        {
            _timeZoneIdChoicesComboBox.setEnabled(false);

            _timeZoneIdChoicesComboBox.setSelectedIndex(0);
        }
        else
        {
            _timeZoneIdChoicesComboBox.setEnabled(true);
            if(getOverRideParameters().getTimeZoneId() != null)
            {
                _timeZoneIdChoicesComboBox.setSelectedItem(getOverRideParameters().getTimeZoneId());
            }
        }
    }

    private void updateBackgroundImagePanel()
    {
        if(getParameters().getBackgroundImageParameters().getImagePath() == null)
        {
            _defaultBackgroundImageRadioButton.setSelected(true);
            setBackgroundImagePanel(true);
        }
        else
        {
            _selectedBackgroundImageRadioButton.setSelected(true);
            setBackgroundImagePanel(false);
        }
    }

    private void updateChartBackgroundColorPanel()
    {
        final GeneralParameters params = getOverRideParameters();
        Color paramsColor = null;

        if(params != null)
        {
            paramsColor = params.getChartBackgroundColor();
        }

        if(paramsColor == null)
        {
            _defaultChartBackgroundColorRadioButton.setSelected(true);
            setChartBackgroundColorButton(true);
        }
        else
        {
            _selectedChartBackgroundColorRadioButton.setSelected(true);
            setChartBackgroundColorButton(false);
        }
    }

    private void updateGridLinePanel()
    {
        final GeneralParameters params = getOverRideParameters();
        Boolean isDashed = null;
        Float width = null;

        if(params != null)
        {
            isDashed = params.isDashedGridLine();
            width = params.getGridLineWidth();
        }

        if(isDashed == null && width == null)
        {
            _defaultGridLineRadioButton.setSelected(true);
            setGridLinePanel(true);
        }
        else
        {
            _selectedGridLineRadioButton.setSelected(true);
            setGridLinePanel(false);
        }
    }

    private void updateGridLineWidthTextField()
    {
        Float width = getOverRideParameters().getGridLineWidth();
        if(width == null)
        {
            width = _defaultParameters.getGridLineWidth();
        }

        _gridLineWidthTextField.setText(String.valueOf(width));
    }

    private void updatePlotBackgroundColorPanel()
    {
        final GeneralParameters params = getOverRideParameters();
        Color paramsColor = null;

        if(params != null)
        {
            paramsColor = params.getPlotBackgroundColor();
        }

        if(paramsColor == null)
        {
            _defaultPlotBackgroundColorRadioButton.setSelected(true);
            setPlotBackgroundColorButton(true);
        }
        else
        {
            _selectedPlotBackgroundColorRadioButton.setSelected(true);
            setPlotBackgroundColorButton(false);
        }
    }

    private void updateTimeZonePanel()
    {
        final GeneralParameters params = getOverRideParameters();
        String timeZoneId = null;

        if(params != null)
        {
            timeZoneId = params.getTimeZoneId();
        }

        if(timeZoneId == null)
        {
            _defaultTimeZoneIdRadioButton.setSelected(true);
            setTimeZonePanel(true);
        }
        else
        {
            _selectedTimeZoneIdRadioButton.setSelected(true);
            setTimeZonePanel(false);
        }
    }

    @Override
    public void actionPerformed(final ActionEvent e)
    {
        if(e.getSource() == this._chartBackgroundColorButton)
        {
            processChartBackgroundColorAction();
        }
        else if(e.getSource() == this._defaultChartBackgroundColorRadioButton)
        {
            processChartBackgroundColorRadioAction();
        }
        else if(e.getSource() == this._selectedChartBackgroundColorRadioButton)
        {
            processChartBackgroundColorRadioAction();
        }
        else if(e.getSource() == this._plotBackgroundColorButton)
        {
            processPlotBackgroundColorAction();
        }
        else if(e.getSource() == this._defaultPlotBackgroundColorRadioButton)
        {
            processPlotBackgroundColorRadioAction();
        }
        else if(e.getSource() == this._selectedPlotBackgroundColorRadioButton)
        {
            processPlotBackgroundColorRadioAction();
        }
        else if(e.getSource() == this._backgroundImageButton)
        {
            processBackgroundImageAction();
        }
        else if(e.getSource() == this._defaultBackgroundImageRadioButton)
        {
            processBackgroundImageRadioAction();
        }
        else if(e.getSource() == this._selectedBackgroundImageRadioButton)
        {
            processBackgroundImageRadioAction();
        }
        else if(e.getSource() == this._defaultTimeZoneIdRadioButton)
        {
            processTimeZoneIdRadioAction();
        }
        else if(e.getSource() == this._selectedTimeZoneIdRadioButton)
        {
            processTimeZoneIdRadioAction();
        }
        else if(e.getSource() == this._defaultGridLineRadioButton)
        {
            processGridLineRadioAction();
        }
        else if(e.getSource() == this._selectedGridLineRadioButton)
        {
            processGridLineRadioAction();
        }
        else if(e.getSource() == this._gridLineWidthTextField)
        {
            processGridLineWidth();
        }
        /* FB 1835 */
        else if(e.getSource() == this._imageTransparencyComboBox)
        {
            final String strTransparency = (String)_imageTransparencyComboBox.getSelectedItem();
            getOverRideParameters().getBackgroundImageParameters()
                                   .setImageTransparency(ImageParameters.determineTransparencyForTransparencyString(strTransparency));
            fireParametersChanged();
        }
        else if(e.getSource() == this._timeZoneIdChoicesComboBox)
        {
            if(SeparatableJComboBoxRenderer.isSeparator(_timeZoneIdChoicesComboBox.getSelectedItem()))
            {
                _timeZoneIdChoicesComboBox.setSelectedItem(getOverRideParameters().getTimeZoneId());
            }
            else
            {
                getOverRideParameters().setTimeZoneId((String)_timeZoneIdChoicesComboBox.getSelectedItem());
                _timeZoneIdChoicesComboBox.setSelectedItem(getOverRideParameters().getTimeZoneId());
                fireParametersChanged();
            }
        }
    }

    @Override
    public void itemStateChanged(final ItemEvent evt)
    {
        if((evt.getSource() == this._alignmentChoicesComboBox) && (evt.getStateChange() == ItemEvent.SELECTED))
        {
            final String strAlignment = (String)_alignmentChoicesComboBox.getSelectedItem();

            getOverRideParameters().getBackgroundImageParameters()
                                   .setImageAlignment(ImageParameters.determineAlignmentForAlignmentString(strAlignment));
        }
        /* FB 1835 */
        if((evt.getSource() == this._imageTransparencyComboBox) && (evt.getStateChange() == ItemEvent.SELECTED))
        {
            final String strTransparency = (String)_imageTransparencyComboBox.getSelectedItem();

            getOverRideParameters().getBackgroundImageParameters()
                                   .setImageTransparency(ImageParameters.determineTransparencyForTransparencyString(strTransparency));
        }
        else if((evt.getSource() == this._dashedGridLineComboBox) && (evt.getStateChange() == ItemEvent.SELECTED))
        {
            final String strIsDashed = (String)_dashedGridLineComboBox.getSelectedItem();

            getOverRideParameters().setDashedGridLine(GeneralParameters.getGridLineIsDashedValue(strIsDashed));
        }
        else if(evt.getSource() == this._backgroundImageComboBox)
        {
            if(evt.getStateChange() == ItemEvent.SELECTED)
            {
                processBackgroundImagePath();
            }
        }
        fireParametersChanged();
    }

    @Override
    public void makePanelReflectParameters()
    {
        removeListeners();

        updateChartBackgroundColorPanel();
        updatePlotBackgroundColorPanel();
        updateBackgroundImagePanel();
        updateGridLinePanel();
        updateTimeZonePanel();

        addListeners();
    }

    @Override
    public void parameterChanged(final GeneralPlugInParameters parameters)
    {
        fireParametersChanged();
    }

    @Override
    public void disableSubPanel()
    {
    }

    @Override
    public void enableSubPanel()
    {
    }

    @Override
    public void focusGained(final FocusEvent e)
    {

    }

    @Override
    public void focusLost(final FocusEvent e)
    {
        if(e.getSource() == this._gridLineWidthTextField)
        {
            processGridLineWidth();
        }
        else if(e.getSource() == this._timeZoneIdChoicesComboBox)
        {
            getOverRideParameters().setTimeZoneId((String)_timeZoneIdChoicesComboBox.getSelectedItem());
            fireParametersChanged();
        }
    }
}