package ohd.hseb.charter.parameters.panels;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import ohd.hseb.charter.parameters.LegendParameters;
import ohd.hseb.hefs.utils.gui.components.BufferJPanel;
import ohd.hseb.hefs.utils.gui.tools.ColorTools;
import ohd.hseb.hefs.utils.gui.tools.ComponentHelper;
import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInPanelListener;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInParameters;

public class LegendParametersPanel extends ChartParametersPanel implements GeneralPlugInPanelListener, ItemListener,
ActionListener, FocusListener, ChangeListener
{
    private static final long serialVersionUID = 1L;

    private final static String[] VISIBLE_CHOICES = {"Default (Yes)", "Yes", "No"};
    private final JComboBox _visibleChoices = HSwingFactory.createJComboBox(VISIBLE_CHOICES, null);
    private final JPanel _visibleChoicesComboBox = HSwingFactory.createLabeledComboBox(new JLabel("Select Legend Visibility:"),
                                                                                       _visibleChoices);

    private final JComboBox _positionChoicesComboBox = HSwingFactory.createJComboBox(LegendParameters.buildPositionDisplayedStrings(),
                                                                                     null);
    private final JPanel _positionComboBox = HSwingFactory.createLabeledComboBox(new JLabel("Select Legend Position:"),
                                                                                 _positionChoicesComboBox);

    private TextFontSelectionPanel _legendTitlePanel;

    private TextFontSelectionPanel _legendEntryFontPanel;

    //Border line color panels
    private final JPanel _borderColorButtonPanel = new JPanel(new GridBagLayout());    
    private final JRadioButton _defaultBorderColorRadioButton = new JRadioButton("Default");
    private final JRadioButton _selectedBorderColorRadioButton = new JRadioButton("User Specified");
    private final JButton _borderColorButton = new JButton();
    // Start FB 1835
    //Fill line color panels
    private final JPanel _fillColorButtonPanel = new JPanel(new GridBagLayout());
    private final JRadioButton _defaultFillColorRadioButton = new JRadioButton("Default");
    private final JRadioButton _selectedFillColorRadioButton = new JRadioButton("User Specified");
    private final JButton _fillColorButton = new JButton();
    // End FB 1835 

    //Border line width
    private final JRadioButton _defaultBorderLineWidthRadioButton = new JRadioButton("Default");
    private final JRadioButton _selectedBorderLineWidthRadioButton = new JRadioButton("User Specified");
    private final JSpinner _borderLineWidthSpinner = HSwingFactory.createJSpinner(null,
                                                                                  5,
                                                                                  1.0f,
                                                                                  0.0f,
                                                                                  (Float)null,
                                                                                  1.0f);
    private final JPanel _borderLineWidthPanel = new JPanel(new GridBagLayout());
    private final JButton _noLineButton = HSwingFactory.createJButton("No Line", null, this);

    public LegendParametersPanel(final LegendParameters managedParameters, final LegendParameters defaultParameters)
    {
        this.setManagedParameters(managedParameters);
        this.setDefaultParameters(defaultParameters);
        createDisplay();
        addListeners();
        makePanelReflectParameters();
    }

    private void createBorderLineWidthPanel()
    {
        final ButtonGroup lineWidthRadioButtonGroup = new ButtonGroup();
        lineWidthRadioButtonGroup.add(_defaultBorderLineWidthRadioButton);
        lineWidthRadioButtonGroup.add(_selectedBorderLineWidthRadioButton);
        _selectedBorderLineWidthRadioButton.setSelected(true);

        final Insets theinsets = new Insets(0, 0, 0, 0);
        final JPanel selectedLineWidthPanel = new JPanel();

        _borderLineWidthPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), "Select Line Width", null));
        _borderLineWidthPanel.add(_defaultBorderLineWidthRadioButton,
                                  SwingTools.returnGridBagConstraints(0,
                                                                      0,
                                                                      1,
                                                                      1,
                                                                      0,
                                                                      0,
                                                                      GridBagConstraints.LINE_START,
                                                                      GridBagConstraints.NONE,
                                                                      theinsets,
                                                                      0,
                                                                      0));

        selectedLineWidthPanel.add(_selectedBorderLineWidthRadioButton);
        selectedLineWidthPanel.add(_borderLineWidthSpinner);
        selectedLineWidthPanel.add(_noLineButton);
        _borderLineWidthPanel.add(selectedLineWidthPanel,
                                  SwingTools.returnGridBagConstraints(1,
                                                                      0,
                                                                      1,
                                                                      1,
                                                                      1,
                                                                      0,
                                                                      GridBagConstraints.LINE_START,
                                                                      GridBagConstraints.NONE,
                                                                      theinsets,
                                                                      0,
                                                                      0));

    }

    private void createBorderLineColorPanel()
    {
        final ButtonGroup colorRadioButtonGroup = new ButtonGroup();
        colorRadioButtonGroup.add(_defaultBorderColorRadioButton);
        colorRadioButtonGroup.add(_selectedBorderColorRadioButton);
        _selectedBorderColorRadioButton.setSelected(true);

        final JPanel selectedColorButtonPanel = new JPanel();
        final Insets theinsets = new Insets(0, 0, 0, 0);
        final int gridX = 1;

        _borderColorButtonPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                                           "Select Line Color",
                                                                           null));
        _borderColorButtonPanel.add(_defaultBorderColorRadioButton,
                                    SwingTools.returnGridBagConstraints(0,
                                                                        0,
                                                                        1,
                                                                        1,
                                                                        0,
                                                                        0,
                                                                        GridBagConstraints.LINE_START,
                                                                        GridBagConstraints.NONE,
                                                                        theinsets,
                                                                        0,
                                                                        0));

        selectedColorButtonPanel.add(_selectedBorderColorRadioButton);
        selectedColorButtonPanel.add(_borderColorButton);
        _borderColorButton.setToolTipText("Edit Color");
        _borderColorButtonPanel.add(selectedColorButtonPanel,
                                    SwingTools.returnGridBagConstraints(gridX,
                                                                        0,
                                                                        1,
                                                                        1,
                                                                        1,
                                                                        0,
                                                                        GridBagConstraints.LINE_START,
                                                                        GridBagConstraints.NONE,
                                                                        theinsets,
                                                                        0,
                                                                        0));
    }
    
    /*START FB 1835*/    
    private void createFillColorPanel()
    {
        final ButtonGroup fillRadioButtonGroup = new ButtonGroup();
        fillRadioButtonGroup.add(_defaultFillColorRadioButton);
        fillRadioButtonGroup.add(_selectedFillColorRadioButton);
        _selectedFillColorRadioButton.setSelected(true);

        final JPanel selectedFillButtonPanel = new JPanel();
        final Insets theinsets = new Insets(0, 0, 0, 0);
        final int gridX = 1;

        _fillColorButtonPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                                           "Select Fill Color",
                                                                           null));
        _fillColorButtonPanel.add(_defaultFillColorRadioButton,
                                    SwingTools.returnGridBagConstraints(0,
                                                                        0,
                                                                        1,
                                                                        1,
                                                                        0,
                                                                        0,
                                                                        GridBagConstraints.LINE_START,
                                                                        GridBagConstraints.NONE,
                                                                        theinsets,
                                                                        0,
                                                                        0));

        selectedFillButtonPanel.add(_selectedFillColorRadioButton);
        selectedFillButtonPanel.add(_fillColorButton);
        _fillColorButton.setToolTipText("Edit Color");
        _fillColorButtonPanel.add(selectedFillButtonPanel,
                                    SwingTools.returnGridBagConstraints(gridX,
                                                                        0,
                                                                        1,
                                                                        1,
                                                                        1,
                                                                        0,
                                                                        GridBagConstraints.LINE_START,
                                                                        GridBagConstraints.NONE,
                                                                        theinsets,
                                                                        0,
                                                                        0));

    }        
    /* END FB 1835*/
    
    
    private void createDisplay()
    {
        _legendTitlePanel = new TextFontSelectionPanel(getParameters().getLegendTitle(),
                                                       getParameterDefaults().getLegendTitle(),
                                                       true,
                                                       true,
                                                       "Select Legend Title Text:",
                                                       "Select Legend Title Font:");
        _legendEntryFontPanel = new TextFontSelectionPanel(getParameters().getLegendEntryFont(),
                                                           getParameterDefaults().getLegendEntryFont(),
                                                           true,
                                                           false,
                                                           "SHOULD NOT BE SEEN",
                                                           "Select Legend Entry Font:");        
        createBorderLineColorPanel();
        createFillColorPanel();        
        createBorderLineWidthPanel();

        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                             0,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             0,
                                                                             GridBagConstraints.WEST,
                                                                             GridBagConstraints.BOTH,
                                                                             new Insets(2, 2, 2, 2),
                                                                             0,
                                                                             0);
        this.add(_visibleChoicesComboBox, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        this.add(_positionComboBox, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          2,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        this.add(ComponentHelper.removeEndingBufferJPanelIfAny(_legendTitlePanel), constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          3,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        this.add(this._borderLineWidthPanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          4,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        
        /*FB 1835*/
        this.add(this._fillColorButtonPanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          5,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        /*FB 1835*/
        
        this.add(this._borderColorButtonPanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          6,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        this.add(ComponentHelper.removeEndingBufferJPanelIfAny(_legendEntryFontPanel), constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          7,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        this.add(new BufferJPanel(), constraints);

    }

    public LegendParameters getParameters()
    {
        return (LegendParameters)getManagedParameters();
    }

    public LegendParameters getParameterDefaults()
    {
        return (LegendParameters)getDefaultParameters();
    }

    @Override
    public void makePanelReflectParameters()
    {
        final LegendParameters params = this.getParameters();

        //Visible flag.
        if(params.getVisible() == null)
        {
            this._visibleChoices.setSelectedIndex(0);
        }
        else if(params.getVisible() == true)
        {
            this._visibleChoices.setSelectedIndex(1);
        }
        else if(params.getVisible() == false)
        {
            this._visibleChoices.setSelectedIndex(2);
        }

        //Position string.
        if(params.getPositionString() == null)
        {
            this._positionChoicesComboBox.setSelectedIndex(0);
        }
        else if(params.getPositionString().equalsIgnoreCase("TOP"))
        {
            this._positionChoicesComboBox.setSelectedIndex(1);
        }
        else if(params.getPositionString().equalsIgnoreCase("RIGHT"))
        {
            this._positionChoicesComboBox.setSelectedIndex(2);
        }
        else if(params.getPositionString().equalsIgnoreCase("LEFT"))
        {
            this._positionChoicesComboBox.setSelectedIndex(3);
        }
        else if(params.getPositionString().equalsIgnoreCase("BOTTOM"))
        {
            this._positionChoicesComboBox.setSelectedIndex(4);
        }

        _legendTitlePanel.makePanelReflectParameters();
        _legendEntryFontPanel.makePanelReflectParameters();        
        makeBorderColorPanelReflectParameters();
        makeFillColorPanelReflectParameters();        
        makeBorderLineWidthPanelReflectParameters();
    }

    /* Start FB 1835*/
    private void makeFillColorPanelReflectParameters()
    {
        this.removeListeners();
        Color buttonBG = null;

        if(this.getParameters().getFillColor() == null)
        {
            this._defaultFillColorRadioButton.setSelected(true);
            buttonBG = this.getParameterDefaults().getFillColor();
            this._fillColorButton.setEnabled(false);
        }
        else
        {
            this._selectedFillColorRadioButton.setSelected(true);
            buttonBG = this.getParameters().getFillColor();
            this._fillColorButton.setEnabled(true);
        }

        this._fillColorButton.setIcon(new ColorIcon(buttonBG));

        this.addListeners();
    } 
    /* End FB 1835*/
    
    private void makeBorderColorPanelReflectParameters()
    {
        this.removeListeners();
        Color buttonBG = null;

        if(this.getParameters().getBorderLineColor() == null)
        {
            this._defaultBorderColorRadioButton.setSelected(true);
            buttonBG = this.getParameterDefaults().getBorderLineColor();
            this._borderColorButton.setEnabled(false);
        }
        else
        {
            this._selectedBorderColorRadioButton.setSelected(true);
            buttonBG = this.getParameters().getBorderLineColor();
            this._borderColorButton.setEnabled(true);
        }

        this._borderColorButton.setIcon(new ColorIcon(buttonBG));

        this.addListeners();
    }

    private void makeBorderLineWidthPanelReflectParameters()
    {
        this.removeListeners();

        if(this.getParameters().getBorderLineWidth() == null)
        {
            this._defaultBorderLineWidthRadioButton.setSelected(true);
            _borderLineWidthSpinner.setValue(getParameterDefaults().getBorderLineWidth());
            this._borderLineWidthSpinner.setEnabled(false);
            this._noLineButton.setEnabled(false);
        }
        else
        {
            this._selectedBorderLineWidthRadioButton.setSelected(true);
            _borderLineWidthSpinner.setValue(getParameters().getBorderLineWidth());
            this._borderLineWidthSpinner.setEnabled(true);
            _noLineButton.setEnabled(true);
        }

        this.addListeners();
    }

    @SuppressWarnings("unused")
    private void makeParametersReflectPanel()
    {
        makeVisibleParameterReflectPanel();
        makePositionStringParameterReflectPanel();        
        makeBorderLineColorParameterReflectPanel();
        makeFillColorParameterReflectPanel();
        makeBorderLineWidthParameterReflectPanel();
    }

    private boolean makeVisibleParameterReflectPanel()
    {
        Boolean newValue = null;
        if(_visibleChoices.getSelectedIndex() == 1)
        {
            newValue = true;
        }
        else if(_visibleChoices.getSelectedIndex() == 2)
        {
            newValue = false;
        }
        if(!ohd.hseb.hefs.utils.tools.GeneralTools.checkForFullEqualityOfObjects(getParameters().getVisible(), newValue))
        {
            getParameters().setVisible(newValue);
            return true;
        }
        return false;
    }

    private boolean makePositionStringParameterReflectPanel()
    {
        final int index = _positionChoicesComboBox.getSelectedIndex();
        String newValue = null;
        if(index == 1)
        {
            newValue = "TOP";
        }
        else if(index == 2)
        {
            newValue = "RIGHT";
        }
        else if(index == 3)
        {
            newValue = "LEFT";
        }
        else if(index == 4)
        {
            newValue = "BOTTOM";
        }

        if(!ohd.hseb.hefs.utils.tools.StringTools.checkForFullEqualityOfStrings(newValue,
                                                                                getParameters().getPositionString(),
                                                                                false))
        {
            getParameters().setPositionString(newValue);
            return true;
        }
        return false;
    }

    
    /* Start FB 1835 */
    private boolean makeFillColorParameterReflectPanel()
    {
        if(this._defaultFillColorRadioButton.isSelected())
        {
            getParameters().setFillColor(null);
            return true;
        }
        else
        {
            final Color newColor = ((ColorIcon)this._fillColorButton.getIcon()).getColor();
            if((getParameters().getFillColor() == null)
                || (!getParameters().getFillColor().equals(newColor)))
            {
                getParameters().setFillColor(((ColorIcon)this._fillColorButton.getIcon()).getColor());
                return true;
            }
        }
        return false;
    }    
    /* End FB 1835 */
    
    
    private boolean makeBorderLineColorParameterReflectPanel()
    {
        if(this._defaultBorderColorRadioButton.isSelected())
        {
            getParameters().setBorderLineColor(null);
            return true;
        }
        else
        {
            final Color newColor = ((ColorIcon)this._borderColorButton.getIcon()).getColor();
            if((getParameters().getBorderLineColor() == null)
                || (!getParameters().getBorderLineColor().equals(newColor)))
            {
                getParameters().setBorderLineColor(((ColorIcon)this._borderColorButton.getIcon()).getColor());
                return true;
            }
        }
        return false;
    }

    private boolean makeBorderLineWidthParameterReflectPanel()
    {
        if(this._defaultBorderLineWidthRadioButton.isSelected())
        {
            getParameters().setBorderLineWidth(null);
            return true;
        }
        else
        {
            try
            {
                final float lineWidthFloat = (Float)_borderLineWidthSpinner.getValue();
                if((getParameters().getBorderLineWidth() == null)
                    || (!getParameters().getBorderLineWidth().equals(lineWidthFloat)))
                {
                    getParameters().setBorderLineWidth(lineWidthFloat);
                    return true;
                }
            }
            catch(final NumberFormatException e)
            {
                _borderLineWidthSpinner.setValue(getParameters().getBorderLineWidth());
            }
        }
        return false;
    }

    private void addListeners()
    {
        _visibleChoices.addItemListener(this);
        _positionChoicesComboBox.addItemListener(this);

        _legendEntryFontPanel.addGraphicsGeneratorPlugInPanelListener(this);
        _legendTitlePanel.addGraphicsGeneratorPlugInPanelListener(this);

        this._borderColorButton.addActionListener(this);
        this._borderLineWidthSpinner.addChangeListener(this);
        this._borderLineWidthSpinner.addFocusListener(this);

        this._defaultBorderColorRadioButton.addActionListener(this);
        this._defaultBorderLineWidthRadioButton.addActionListener(this);
        this._selectedBorderColorRadioButton.addActionListener(this);
        this._selectedBorderLineWidthRadioButton.addActionListener(this);
        
        /* Start FB 1835 */
        this._fillColorButton.addActionListener(this);
        this._defaultFillColorRadioButton.addActionListener(this);
        this._selectedFillColorRadioButton.addActionListener(this);      
        /* End FB 1835 */
    }

    private void removeListeners()
    {
        _visibleChoices.removeItemListener(this);
        _positionChoicesComboBox.removeItemListener(this);

        _legendEntryFontPanel.removeGraphicsGeneratorPlugInPanelListener(this);
        _legendTitlePanel.removeGraphicsGeneratorPlugInPanelListener(this);

        this._borderColorButton.removeActionListener(this);
        this._borderLineWidthSpinner.removeChangeListener(this);
        this._borderLineWidthSpinner.removeFocusListener(this);

        this._defaultBorderColorRadioButton.removeActionListener(this);
        this._defaultBorderLineWidthRadioButton.removeActionListener(this);
        this._selectedBorderColorRadioButton.removeActionListener(this);
        this._selectedBorderLineWidthRadioButton.removeActionListener(this);
        /* Start FB 1835 */
        this._fillColorButton.removeActionListener(this);
        this._defaultFillColorRadioButton.removeActionListener(this);
        this._defaultFillColorRadioButton.removeActionListener(this);
        /* End FB 1835 */
    }

    @Override
    public void disableSubPanel()
    {
        this._legendEntryFontPanel.disableSubPanel();
        this._legendTitlePanel.disableSubPanel();
    }

    @Override
    public void enableSubPanel()
    {
        this._legendEntryFontPanel.enableSubPanel();
        this._legendTitlePanel.enableSubPanel();
    }

    @Override
    public void parameterChanged(final GeneralPlugInParameters parameters)
    {
        fireParametersChanged();
    }

    @Override
    public void itemStateChanged(final ItemEvent e)
    {
        if(e.getSource() == this._visibleChoices)
        {
            if(makeVisibleParameterReflectPanel())
            {
                fireParametersChanged();
            }
        }
        else if(e.getSource() == this._positionChoicesComboBox)
        {
            if(makePositionStringParameterReflectPanel())
            {
                fireParametersChanged();
            }
        }
    }

    @Override
    public void actionPerformed(final ActionEvent e)
    {
        if((e.getSource() == this._defaultBorderColorRadioButton)
                || (e.getSource() == this._selectedBorderColorRadioButton))
            {
                if(makeBorderLineColorParameterReflectPanel())
                {
                    fireParametersChanged();
                }
                this.makeBorderColorPanelReflectParameters();
            }
        /*FB 1835*/
    	else if((e.getSource() == this._defaultFillColorRadioButton)
            || (e.getSource() == this._selectedFillColorRadioButton))
        {
            if(makeFillColorParameterReflectPanel())
            {
                fireParametersChanged();
            }
            this.makeFillColorPanelReflectParameters();
        } /*FB 1835*/
        else if((e.getSource() == this._defaultBorderLineWidthRadioButton)
            || (e.getSource() == this._selectedBorderLineWidthRadioButton))
        {
            if(makeBorderLineWidthParameterReflectPanel())
            {
                fireParametersChanged();
            }
            this.makeBorderLineWidthPanelReflectParameters();
        }/*FB 1835*/
        else if(e.getSource() == this._fillColorButton)
        {
            Color color = getParameters().getFillColor();
            color = ColorTools.chooseColor(this, color);
            if(color != null)
            {
                this._fillColorButton.setIcon(new ColorIcon(color));
            }
            if(this.makeFillColorParameterReflectPanel())
            {
                fireParametersChanged();
            }
            this.makeFillColorPanelReflectParameters();
        }  /*FB 1835*/      
        else if(e.getSource() == this._borderColorButton)
        {
            Color color = getParameters().getBorderLineColor();
            color = ColorTools.chooseColor(this, color);
            if(color != null)
            {
                this._borderColorButton.setIcon(new ColorIcon(color));
            }
            if(this.makeBorderLineColorParameterReflectPanel())
            {
                fireParametersChanged();
            }
            this.makeBorderColorPanelReflectParameters();
        }
        else if(e.getSource() == this._noLineButton)
        {
            this._borderLineWidthSpinner.setValue(Float.valueOf(0.0f));
            if(makeBorderLineWidthParameterReflectPanel())
            {
                fireParametersChanged();
            }
            this.makeBorderLineWidthPanelReflectParameters();
        }
    }

    @Override
    public void focusGained(final FocusEvent e)
    {
    }

    @Override
    public void focusLost(final FocusEvent e)
    {
        if(e.getSource() == this._borderLineWidthSpinner)
        {
            if(makeBorderLineWidthParameterReflectPanel())
            {
                fireParametersChanged();
            }
            this.makeBorderLineWidthPanelReflectParameters();
        }
    }

    @Override
    public void stateChanged(final ChangeEvent e)
    {
        if(e.getSource() == this._borderLineWidthSpinner)
        {
            if(makeBorderLineWidthParameterReflectPanel())
            {
                fireParametersChanged();
            }
            this.makeBorderLineWidthPanelReflectParameters();
        }
    }
}