package ohd.hseb.charter.parameters.panels;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import ohd.hseb.charter.parameters.ImageParameters;
import ohd.hseb.charter.parameters.SubPlotParameters;
import ohd.hseb.hefs.utils.filechooser.HGlobalFileChooser;
import ohd.hseb.hefs.utils.gui.components.BufferJPanel;
import ohd.hseb.hefs.utils.gui.tools.ColorTools;
import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;

import com.google.common.base.Strings;

public class SubPlotParametersPanel extends ChartParametersPanel implements ChangeListener, ActionListener,
ItemListener, FocusListener
{
    private static final long serialVersionUID = 1L;

    private final JSpinner _subPlotWeightSpinner = HSwingFactory.createJSpinner(null, 2, 1, 1, Integer.MAX_VALUE, 1);

    //components for background image panel
    private final ButtonGroup _backgroundImageRadioButtonGroup = new ButtonGroup();
    private final JRadioButton _defaultBackgroundImageRadioButton = new JRadioButton("Default", true);
    private final JRadioButton _selectedBackgroundImageRadioButton = new JRadioButton("User Specified");
    private final JButton _backgroundImageButton = new JButton("Select");
    private final JTextField _backgroundImageTextField = new JTextField();
    private final JComboBox _alignmentChoicesComboBox = HSwingFactory.createJComboBox(ImageParameters.buildAlignmentDisplayedStrings(),
                                                                                      null);
    /* FB 1835 */
    private final JComboBox _imageTransparencyComboBox = HSwingFactory.createJComboBox(ImageParameters.buildTansparencyDisplayedStrings(),
                                                                                       null);

    private DefaultYesNoComboBox _reverseRenderingComboBox;
    private DefaultYesNoComboBox _reverseLegendItemOrderComboBox;

    //components for plot background panel
    private final ButtonGroup _plotBackgroundColorRadioButtonGroup = new ButtonGroup();
    private final JRadioButton _defaultPlotBackgroundColorRadioButton = new JRadioButton("Default", true);
    private final JRadioButton _selectedPlotBackgroundColorRadioButton = new JRadioButton("User Specified");
    private final JButton _plotBackgroundColorButton = new JButton("");

    public SubPlotParametersPanel(final SubPlotParameters managedParameters, final SubPlotParameters defaultParameters)
    {

        setManagedParameters(managedParameters);
        setDefaultParameters(defaultParameters);

        createDisplay();

        makePanelReflectParameters();
    }

    private void createDisplay()
    {
        final JPanel weightPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        weightPanel.add(new JLabel("Specify Subplot Weight: "));
        weightPanel.add(_subPlotWeightSpinner);

        //reverse rendering combo box.
        final JPanel reversePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        _reverseRenderingComboBox = new DefaultYesNoComboBox(getDefault().getReverseRendering());
        reversePanel.add(new JLabel("Select Reverse Rendering:"));
        reversePanel.add(_reverseRenderingComboBox);

        //reverse rendering combo box.
        final JPanel reverseLegendItemOrderPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        _reverseLegendItemOrderComboBox = new DefaultYesNoComboBox(getDefault().getReverseLegendItemOrder());
        reverseLegendItemOrderPanel.add(new JLabel("Select Reverse Legend Item Order:"));
        reverseLegendItemOrderPanel.add(_reverseLegendItemOrderComboBox);

        final Insets insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        int gridy = 0;
        final GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                                   gridy,
                                                                                   1,
                                                                                   1,
                                                                                   1,
                                                                                   0,
                                                                                   GridBagConstraints.WEST,
                                                                                   GridBagConstraints.BOTH,
                                                                                   insets,
                                                                                   0,
                                                                                   0);
        this.add(weightPanel, constraints);

        constraints.gridy++;
        this.add(reversePanel, constraints);

        constraints.gridy++;
        this.add(reverseLegendItemOrderPanel, constraints);

        constraints.gridy++;
        this.add(createPlotBackgroundColorPanel(), constraints);

        constraints.gridy++;
        this.add(createBackgroundImagePanel(), constraints);

        gridy++;
        constraints.gridy++;
        constraints.weighty = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add(new BufferJPanel(), constraints);

    }

    /**
     * Setup the Background Image Panel
     */
    private JPanel createBackgroundImagePanel()
    {
        final JPanel filePanel = new JPanel();
        filePanel.add(this._backgroundImageButton);
        filePanel.add(new JLabel("File:"));
        filePanel.add(_backgroundImageTextField);
        _backgroundImageTextField.setEditable(true);
        _backgroundImageTextField.setColumns(25);
        _backgroundImageButton.setToolTipText("Select Image File");

        _backgroundImageRadioButtonGroup.add(_defaultBackgroundImageRadioButton);
        _backgroundImageRadioButtonGroup.add(_selectedBackgroundImageRadioButton);
        final JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.add(_defaultBackgroundImageRadioButton);
        radioButtonPanel.add(_selectedBackgroundImageRadioButton);

        final JPanel choicesPanel = new JPanel();
        choicesPanel.add(new JLabel("Image Alignment:"));
        choicesPanel.add(_alignmentChoicesComboBox);

        /* FB 1835 */
        final JPanel transparencysPanel = new JPanel();
        transparencysPanel.add(new JLabel("Image Transparency:"));
        transparencysPanel.add(_imageTransparencyComboBox);

        final Insets theinsets = new Insets(0, 0, 0, 0);
        final JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), "Select Background Image", null));
        GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                             0,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             0,
                                                                             GridBagConstraints.WEST,
                                                                             GridBagConstraints.NONE,
                                                                             theinsets,
                                                                             0,
                                                                             0);
        panel.add(radioButtonPanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        panel.add(filePanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          2,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        panel.add(choicesPanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          3,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        panel.add(transparencysPanel, constraints);

        return panel;
    }

    /**
     * Setup the Plot Area Background Color Panel
     */
    private JPanel createPlotBackgroundColorPanel()
    {
        final JPanel colorPanel = new JPanel(new GridBagLayout());

        final Insets theinsets = new Insets(0, 0, 0, 0);

        this._plotBackgroundColorButton.setToolTipText("Select Color");

        colorPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                              "Select Plot Area Background Color",
                                                              null));
        _plotBackgroundColorRadioButtonGroup.add(_defaultPlotBackgroundColorRadioButton);
        _plotBackgroundColorRadioButtonGroup.add(_selectedPlotBackgroundColorRadioButton);

        GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                             0,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             0,
                                                                             GridBagConstraints.LINE_START,
                                                                             GridBagConstraints.NONE,
                                                                             theinsets,
                                                                             0,
                                                                             0);

        colorPanel.add(_defaultPlotBackgroundColorRadioButton, constraints);

        constraints = SwingTools.returnGridBagConstraints(1,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.LINE_START,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        colorPanel.add(_selectedPlotBackgroundColorRadioButton, constraints);

        constraints = SwingTools.returnGridBagConstraints(2,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.LINE_START,
                                                          GridBagConstraints.NONE,
                                                          theinsets,
                                                          0,
                                                          0);
        colorPanel.add(_plotBackgroundColorButton, constraints);

        _selectedPlotBackgroundColorRadioButton.setSelected(true);

        return colorPanel;
    }

    private void addListeners()
    {
        _subPlotWeightSpinner.addChangeListener(this);

        _plotBackgroundColorButton.addActionListener(this);
        _defaultPlotBackgroundColorRadioButton.addActionListener(this);
        _selectedPlotBackgroundColorRadioButton.addActionListener(this);

        _backgroundImageButton.addActionListener(this);
        _defaultBackgroundImageRadioButton.addActionListener(this);
        _selectedBackgroundImageRadioButton.addActionListener(this);
        _alignmentChoicesComboBox.addActionListener(this);
        /* FB 1835 */
        _imageTransparencyComboBox.addActionListener(this);
        _backgroundImageTextField.addFocusListener(this);
        _backgroundImageTextField.addActionListener(this);

        _reverseRenderingComboBox.addActionListener(this);
        _reverseLegendItemOrderComboBox.addActionListener(this);

    }

    private void removeListeners()
    {
        _subPlotWeightSpinner.removeChangeListener(this);

        _plotBackgroundColorButton.removeActionListener(this);
        _defaultPlotBackgroundColorRadioButton.removeActionListener(this);
        _selectedPlotBackgroundColorRadioButton.removeActionListener(this);

        _backgroundImageButton.removeActionListener(this);
        _defaultBackgroundImageRadioButton.removeActionListener(this);
        _selectedBackgroundImageRadioButton.removeActionListener(this);
        _alignmentChoicesComboBox.removeActionListener(this);
        /* FB 1835 */
        _imageTransparencyComboBox.removeActionListener(this);
        _backgroundImageTextField.removeFocusListener(this);
        _backgroundImageTextField.removeActionListener(this);

        _reverseRenderingComboBox.removeActionListener(this);
        _reverseLegendItemOrderComboBox.removeActionListener(this);
    }

    public SubPlotParameters getParameters()
    {
        return (SubPlotParameters)this.getManagedParameters();
    }

    public SubPlotParameters getDefault()
    {
        return (SubPlotParameters)this.getDefaultParameters();
    }

    /**
     * Process a background image selection action by opening up a dialog to allow for selecting an image file. If a
     * selection is made, it updates the text field and then calls the usual suspects:
     * {@link #makeBackgroundColorParameterReflectPanel()} and {@link #makeBackgroundColorPanelReflectParameters()}.
     */
    private void processBackgroundImageSelectionAction()
    {
        //It will initialize the directory to the currently specified image, if one exists.
        String initialPath = ".";
        if(!Strings.isNullOrEmpty(getParameters().getBackgroundImageParameters().getImagePath()))
        {
            initialPath = getParameters().getBackgroundImageParameters().getImagePath();
        }
        final HGlobalFileChooser fileChooser = new HGlobalFileChooser(initialPath);
        fileChooser.addFileFilter("gif", "GIF Image");
        fileChooser.addFileFilter("jpg", "JPG Image");
        fileChooser.addFileFilter("jpeg", "JPEG Image");
        fileChooser.addFileFilter("png", "PNG Image");
        fileChooser.setDialogTitle("Select Image File");
        final File selectedFile = fileChooser.chooseFile(JFileChooser.FILES_ONLY, this);
        if(selectedFile == null)
        {
            return;
        }

        final String filePath = selectedFile.getPath();
        _backgroundImageTextField.setText(filePath);
        if(makeBackgroundImageParametersReflectPanel())
        {
            fireParametersChanged();
        }
        makeBackgroundImagePanelReflectParameters();
    }

    private void updateBackgroundImagePanelForRadioButtonClick(final boolean setDefault)
    {
        String bgImagePath = null;

        // Default radio button is selected.  Get the properties from the defaultParameters
        if(setDefault)
        {
            _backgroundImageButton.setEnabled(false);
            _alignmentChoicesComboBox.setEnabled(false);
            /* FB 1835 */
            _imageTransparencyComboBox.setEnabled(false);
            _backgroundImageTextField.setEnabled(false);
            _backgroundImageTextField.setText("");
            _alignmentChoicesComboBox.setSelectedIndex(0);
            /* FB 1835 */
            _imageTransparencyComboBox.setSelectedIndex(0);
        }
        else
        {
            _backgroundImageButton.setEnabled(true);
            _alignmentChoicesComboBox.setEnabled(true);
            /* FB 1835 */
            _imageTransparencyComboBox.setEnabled(true);
            _backgroundImageTextField.setEnabled(true);
            _alignmentChoicesComboBox.setSelectedItem(ImageParameters.determineAlignmentStringForAlignment(getParameters().getBackgroundImageParameters()
                                                                                                                          .getImageAlignment()));
            /* FB 1835 */
            _imageTransparencyComboBox.setSelectedItem(ImageParameters.determineTransparencyStringForTransparency(getParameters().getBackgroundImageParameters()
                                                                                                                                 .getImageTransparency()));

            bgImagePath = getParameters().getBackgroundImageParameters().getImagePath();
            if(bgImagePath == null)
            {
                bgImagePath = this.getDefault().getBackgroundImageParameters().getImagePath();
            }

            if(bgImagePath != null)
            {
                _backgroundImageTextField.setText(bgImagePath);
            }
            else
            {
                _backgroundImageTextField.setText("");
            }
        }
    }

    private void processPlotBackgroundColorAction()
    {
        Color color = getParameters().getPlotBackgroundColor();

        color = ColorTools.chooseColor(this, color);
        if(color != null)
        {
            _plotBackgroundColorButton.setIcon(new ColorIcon(color));
            if(makeBackgroundColorParameterReflectPanel())
            {
                fireParametersChanged();
            }
            makeBackgroundColorPanelReflectParameters();
        }
    }

    private void updatePlotBackgroundColorButton(final boolean defaultSelected)
    {
        Color bgColor = null;

        if(defaultSelected) // Default radio button is selected.  Get the color from the defaultParameters
        {
            _plotBackgroundColorButton.setEnabled(false);

            bgColor = getDefault().getPlotBackgroundColor();
            if(bgColor == null)
            {
                bgColor = new Color(255, 255, 255, 0);
            }
        }
        else
        {
            _plotBackgroundColorButton.setEnabled(true);
            bgColor = getParameters().getPlotBackgroundColor();
            if(bgColor == null)
            {
                bgColor = getDefault().getPlotBackgroundColor();
            }
            if(bgColor == null)
            {
                bgColor = new Color(255, 255, 255, 0);
            }
        }
        _plotBackgroundColorButton.setIcon(new ColorIcon(bgColor));
    }

    @SuppressWarnings("unused")
    private void makeParametersReflectPanel()
    {
        makeWeightParameterReflectPanel();
        makeReverseRenderingParameterReflectPanel();
        makeBackgroundColorParameterReflectPanel();
        makeBackgroundImageParametersReflectPanel();
    }

    private void makeWeightParameterReflectPanel()
    {
        if(getParameters().getPlotWeight() != (Integer)this._subPlotWeightSpinner.getValue())
        {
            getParameters().setPlotWeight((Integer)this._subPlotWeightSpinner.getValue());
            fireParametersChanged();
        }
    }

    private boolean makeReverseRenderingParameterReflectPanel()
    {
        final Boolean newValue = _reverseRenderingComboBox.getSelectedValue();
        if(!ohd.hseb.hefs.utils.tools.GeneralTools.checkForFullEqualityOfObjects(newValue,
                                                                                 getParameters().getReverseRendering()))
        {
            getParameters().setReverseRendering(newValue);
            return true;
        }
        return false;
    }

    private boolean makeReverseLegendItemOrderParameterReflectPanel()
    {
        final Boolean newValue = _reverseLegendItemOrderComboBox.getSelectedValue();
        if(!ohd.hseb.hefs.utils.tools.GeneralTools.checkForFullEqualityOfObjects(newValue,
                                                                                 getParameters().getReverseLegendItemOrder()))
        {
            getParameters().setReverseLegendItemOrder(newValue);
            return true;
        }
        return false;
    }

    private boolean makeBackgroundColorParameterReflectPanel()
    {
        Color newValue = null;
        if(this._selectedPlotBackgroundColorRadioButton.isSelected())
        {
            newValue = ((ColorIcon)this._plotBackgroundColorButton.getIcon()).getColor();
        }
        if(!ohd.hseb.hefs.utils.tools.GeneralTools.checkForFullEqualityOfObjects(newValue,
                                                                                 getParameters().getPlotBackgroundColor()))
        {
            getParameters().setPlotBackgroundColor(newValue);
            return true;
        }
        return false;
    }

    private boolean makeBackgroundImageParametersReflectPanel()
    {
        if(this._defaultBackgroundImageRadioButton.isSelected())
        {
            getParameters().getBackgroundImageParameters().clearParameters();
        }
        else
        {
            final String imagePath = _backgroundImageTextField.getText();

            if(imagePath != null)
            {
                getParameters().getBackgroundImageParameters().setImagePath(imagePath);
            }

            final String strAlignment = (String)_alignmentChoicesComboBox.getSelectedItem();

            getParameters().getBackgroundImageParameters()
                           .setImageAlignment(ImageParameters.determineAlignmentForAlignmentString(strAlignment));
            /* FB 1835 */
            final String strTransparency = (String)_imageTransparencyComboBox.getSelectedItem();

            getParameters().getBackgroundImageParameters()
                           .setImageTransparency(ImageParameters.determineTransparencyForTransparencyString(strTransparency));
        }
        return true;
    }

    private void makeBackgroundColorPanelReflectParameters()
    {
        removeListeners();
        final Color paramsColor = getParameters().getPlotBackgroundColor();

        if(paramsColor == null)
        {
            _defaultPlotBackgroundColorRadioButton.setSelected(true);
            updatePlotBackgroundColorButton(true);
        }
        else
        {
            _selectedPlotBackgroundColorRadioButton.setSelected(true);
            updatePlotBackgroundColorButton(false);
        }
        addListeners();
    }

    private void makeBackgroundImagePanelReflectParameters()
    {
        removeListeners();
        if(getParameters().getBackgroundImageParameters().getImagePath() == null)
        {
            _defaultBackgroundImageRadioButton.setSelected(true);
            updateBackgroundImagePanelForRadioButtonClick(true);
        }
        else
        {
            _selectedBackgroundImageRadioButton.setSelected(true);
            updateBackgroundImagePanelForRadioButtonClick(false);
        }
        addListeners();
    }

    private void makeReverseRenderingPanelReflectParameters()
    {
        _reverseRenderingComboBox.setSelectedValue(getParameters().getReverseRendering());
    }

    private void makeReverseLegendOrderPanelReflectParameters()
    {
        _reverseLegendItemOrderComboBox.setSelectedValue(getParameters().getReverseLegendItemOrder());
    }

    private void makeWeightPanelReflectParameters()
    {
        this.removeListeners();
        //No possibility of null for weight 
        _subPlotWeightSpinner.setValue(getParameters().getPlotWeight());
        this.addListeners();
    }

    @Override
    public void makePanelReflectParameters()
    {
        makeWeightPanelReflectParameters();
        makeReverseRenderingPanelReflectParameters();
        makeReverseLegendOrderPanelReflectParameters();
        makeBackgroundColorPanelReflectParameters();
        makeBackgroundImagePanelReflectParameters();
    }

    @Override
    public void disableSubPanel()
    {
        _subPlotWeightSpinner.setEnabled(false);
    }

    @Override
    public void enableSubPanel()
    {
        _subPlotWeightSpinner.setEnabled(true);
    }

    @Override
    public void stateChanged(final ChangeEvent arg0)
    {
        if(arg0.getSource() == this._subPlotWeightSpinner)
        {
            makeWeightParameterReflectPanel();
        }
    }

    @Override
    public void actionPerformed(final ActionEvent e)
    {
        if((e.getSource() == this._defaultPlotBackgroundColorRadioButton)
            || (e.getSource() == this._selectedPlotBackgroundColorRadioButton))
        {
            if(makeBackgroundColorParameterReflectPanel())
            {
                fireParametersChanged();
            }
            makeBackgroundColorPanelReflectParameters();
        }
        else if(e.getSource() == this._plotBackgroundColorButton)
        {
            processPlotBackgroundColorAction();
        }
        else if((e.getSource() == this._defaultBackgroundImageRadioButton)
            || (e.getSource() == this._selectedBackgroundImageRadioButton))
        {
            if(makeBackgroundImageParametersReflectPanel())
            {
                fireParametersChanged();
            }
            makeBackgroundImagePanelReflectParameters();
        }
        else if(e.getSource() == this._backgroundImageButton)
        {
            processBackgroundImageSelectionAction();
        }
        else if(e.getSource() == this._backgroundImageTextField)
        {
            if(makeBackgroundImageParametersReflectPanel())
            {
                fireParametersChanged();
            }
            makeBackgroundImagePanelReflectParameters();
        }
        else if(e.getSource() == this._reverseRenderingComboBox)
        {
            if(makeReverseRenderingParameterReflectPanel())
            {
                fireParametersChanged();
            }
            makeReverseRenderingPanelReflectParameters();
        }
        else if(e.getSource() == this._reverseLegendItemOrderComboBox)
        {
            if(makeReverseLegendItemOrderParameterReflectPanel())
            {
                fireParametersChanged();
            }
            makeReverseLegendOrderPanelReflectParameters();
        }
        else if(e.getSource() == this._alignmentChoicesComboBox)
        {
            if(makeBackgroundImageParametersReflectPanel())
            {
                fireParametersChanged();
            }
            makeBackgroundImagePanelReflectParameters();
        }
        /* FB 1835 */
        else if(e.getSource() == this._imageTransparencyComboBox)
        {
            if(makeBackgroundImageParametersReflectPanel())
            {
                fireParametersChanged();
            }
            makeBackgroundImagePanelReflectParameters();
        }
    }

    @Override
    public void itemStateChanged(final ItemEvent e)
    {
        if((e.getSource() == this._alignmentChoicesComboBox) && (e.getStateChange() == ItemEvent.SELECTED))
        {
            final String strAlignment = (String)_alignmentChoicesComboBox.getSelectedItem();
            getParameters().getBackgroundImageParameters()
                           .setImageAlignment(ImageParameters.determineAlignmentForAlignmentString(strAlignment));
        }

        /* FB 1835 */
        if((e.getSource() == this._imageTransparencyComboBox) && (e.getStateChange() == ItemEvent.SELECTED))
        {
            final String strTransparency = (String)_imageTransparencyComboBox.getSelectedItem();
            getParameters().getBackgroundImageParameters()
                           .setImageTransparency(ImageParameters.determineTransparencyForTransparencyString(strTransparency));
        }

        this.fireParametersChanged();
    }

    @Override
    public void focusGained(final FocusEvent e)
    {
    }

    @Override
    public void focusLost(final FocusEvent e)
    {
        if(makeBackgroundImageParametersReflectPanel())
        {
            fireParametersChanged();
        }
        makeBackgroundImagePanelReflectParameters();
    }
}
